/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.BucketMetricsPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.InternalPercentilesBucket;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class PercentilesBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    private final double[] percents;
    private boolean keyed = true;
    private List<Double> data;

    PercentilesBucketPipelineAggregator(String name, double[] percents, boolean keyed, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, DocValueFormat formatter, Map<String, Object> metaData) {
        super(name, bucketsPaths, gapPolicy, formatter, metaData);
        this.percents = percents;
        this.keyed = keyed;
    }

    public PercentilesBucketPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.percents = in.readDoubleArray();
        if (in.getVersion().onOrAfter(Version.V_7_0_0)) {
            this.keyed = in.readBoolean();
        }
    }

    @Override
    public void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDoubleArray(this.percents);
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            out.writeBoolean(this.keyed);
        }
    }

    @Override
    public String getWriteableName() {
        return "percentiles_bucket";
    }

    @Override
    protected void preCollection() {
        this.data = new ArrayList<Double>(1024);
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        this.data.add(bucketValue);
    }

    @Override
    protected InternalAggregation buildAggregation(List<PipelineAggregator> pipelineAggregators, Map<String, Object> metadata) {
        Collections.sort(this.data);
        double[] percentiles = new double[this.percents.length];
        if (this.data.size() == 0) {
            for (int i = 0; i < this.percents.length; ++i) {
                percentiles[i] = Double.NaN;
            }
        } else {
            for (int i = 0; i < this.percents.length; ++i) {
                int index = (int)Math.round(this.percents[i] / 100.0 * (double)(this.data.size() - 1));
                percentiles[i] = this.data.get(index);
            }
        }
        return new InternalPercentilesBucket(this.name(), this.percents, percentiles, this.keyed, this.format, pipelineAggregators, metadata);
    }
}

