/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subawardReporting.printing.print;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.kuali.coeus.sys.framework.util.PdfBoxUtils;
import org.kuali.kra.award.printing.schema.AwardType;
import org.kuali.kra.subaward.bo.FinalStatementDue;
import org.kuali.kra.subaward.printing.schema.SubContractDataDocument;
import org.kuali.kra.subawardReporting.printing.print.SubawardFdp;

public class SubAwardFDPAgreement
extends SubawardFdp {
    @Override
    protected void setSubrecipientInfo(PDDocument document, SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail) {
        PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.SUBRECIPIENT.getfName(), subcontractDetail.getSubcontractorName());
        PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.SUB_PI.getfName(), subcontractDetail.getSiteInvestigator());
    }

    @Override
    protected void setMiscellaneousItems(PDDocument pdfDocument, SubContractDataDocument xmlObject) {
    }

    @Override
    protected void setPteInfo(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator;
        SubContractDataDocument.SubContractData.PrimeRecipientContacts primeRecipientContacts = xmlObject.getSubContractData().getPrimeRecipientContacts() != null ? xmlObject.getSubContractData().getPrimeRecipientContacts() : SubContractDataDocument.SubContractData.PrimeRecipientContacts.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator2 = primePrincipalInvestigator = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimePrincipalInvestigatorArray()) ? xmlObject.getSubContractData().getPrimePrincipalInvestigatorArray()[0] : SubContractDataDocument.SubContractData.PrimePrincipalInvestigator.Factory.newInstance();
        if (primeRecipientContacts.getRequisitionerOrgDetails() != null) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.PASS_THROUGH_ENTITY.getfName(), primeRecipientContacts.getRequisitionerOrgDetails().getOrganizationName());
        }
        if (primePrincipalInvestigator.getPersonDetailsType() != null) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.PTE_PI.getfName(), primePrincipalInvestigator.getPersonDetailsType().getFullName());
        }
    }

    @Override
    protected void setAwardSubawardNumbers(PDDocument document, SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail, AwardType award) {
        if (award.getAwardDetails() != null && award.getAwardDetails().getAwardHeader() != null) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.PTE_FEDERAL_AWARD_NO.getfName(), award.getAwardDetails().getAwardHeader().getSponsorAwardNumber());
        }
        PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.SUBAWARD_NO.getfName(), subcontractDetail.getFsrsSubawardNumber());
    }

    @Override
    protected void setTitle(PDDocument document, AwardType award) {
        if (award.getAwardDetails() != null && award.getAwardDetails().getAwardHeader() != null) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.PROJECT_TITLE.getfName(), award.getAwardDetails().getAwardHeader().getTitle());
        }
    }

    @Override
    protected void setDates(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractAmountInfo amountInfo;
        SubContractDataDocument.SubContractData.SubcontractDetail subcontractDetail = xmlObject.getSubContractData().getSubcontractDetail() != null ? xmlObject.getSubContractData().getSubcontractDetail() : SubContractDataDocument.SubContractData.SubcontractDetail.Factory.newInstance();
        SubContractDataDocument.SubContractData.SubcontractAmountInfo subcontractAmountInfo = amountInfo = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getSubcontractAmountInfoArray()) ? xmlObject.getSubContractData().getSubcontractAmountInfoArray()[0] : SubContractDataDocument.SubContractData.SubcontractAmountInfo.Factory.newInstance();
        if (subcontractDetail.getStartDate() != null) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.POP_START.getfName(), this.formatDate(subcontractDetail.getStartDate().getTime()));
        }
        if (amountInfo.getPerformanceEndDate() != null) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.POP_END.getfName(), this.formatDate(amountInfo.getPerformanceEndDate().getTime()));
        }
        PdfBoxUtils.hideField(document, SubawardFdp.AgreementPdf.Field.PROJECT_START_TIP.getfName());
        if (subcontractDetail.getStartDate() != null) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.PROJECT_START.getfName(), this.formatDate(subcontractDetail.getStartDate().getTime()));
        }
        PdfBoxUtils.hideField(document, SubawardFdp.AgreementPdf.Field.PROJECT_END_TIP.getfName());
        if (subcontractDetail.getEndDate() != null) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.PROJECT_END.getfName(), this.formatDate(subcontractDetail.getEndDate().getTime()));
        }
    }

    @Override
    protected void setAmounts(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.SubcontractAmountInfo amountInfo;
        SubContractDataDocument.SubContractData.SubcontractAmountInfo subcontractAmountInfo = amountInfo = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getSubcontractAmountInfoArray()) ? xmlObject.getSubContractData().getSubcontractAmountInfoArray()[0] : SubContractDataDocument.SubContractData.SubcontractAmountInfo.Factory.newInstance();
        if (amountInfo.getObligatedAmount() != null) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.AMOUNT_FUNDED_THIS_ACTION.getfName(), amountInfo.getObligatedAmount().toPlainString());
        }
        if (amountInfo.getAnticipatedAmount() != null) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.INCREMENTALLY_ESTIMATED_TOTAL.getfName(), amountInfo.getAnticipatedAmount().toPlainString());
        }
    }

    @Override
    protected void setTermsAndConditions(PDDocument document, SubContractDataDocument xmlObject) {
        SubContractDataDocument.SubContractData.OtherConfigInfo configInfo = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getOtherConfigInfoArray()) ? xmlObject.getSubContractData().getOtherConfigInfoArray(0) : SubContractDataDocument.SubContractData.OtherConfigInfo.Factory.newInstance();
        SubContractDataDocument.SubContractData.SubcontractTemplateInfo templateInfo = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getSubcontractTemplateInfoArray()) ? xmlObject.getSubContractData().getSubcontractTemplateInfoArray(0) : SubContractDataDocument.SubContractData.SubcontractTemplateInfo.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial primeAuthorizedOfficial = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimeAuthorizedOfficialArray()) ? xmlObject.getSubContractData().getPrimeAuthorizedOfficialArray()[0] : SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimePrincipalInvestigatorArray()) ? xmlObject.getSubContractData().getPrimePrincipalInvestigatorArray()[0] : SubContractDataDocument.SubContractData.PrimePrincipalInvestigator.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimeAdministrativeContact primeAdministrativeContact = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimeAdministrativeContactArray()) ? xmlObject.getSubContractData().getPrimeAdministrativeContactArray()[0] : SubContractDataDocument.SubContractData.PrimeAdministrativeContact.Factory.newInstance();
        SubContractDataDocument.SubContractData.PrimeFinancialContact primeFinancialContact = ArrayUtils.isNotEmpty((Object[])xmlObject.getSubContractData().getPrimeFinancialContactArray()) ? xmlObject.getSubContractData().getPrimeFinancialContactArray()[0] : SubContractDataDocument.SubContractData.PrimeFinancialContact.Factory.newInstance();
        PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.TERM_2_CONTACT.getfName(), this.getTermContactFromCode(templateInfo.getInvoiceOrPaymentContactCd(), primeAuthorizedOfficial, primePrincipalInvestigator, primeAdministrativeContact, primeFinancialContact));
        PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.TERM_3_CONTACT.getfName(), this.getTermContactFromCode(templateInfo.getFinalStmtOfCostsContactCd(), primeAuthorizedOfficial, primePrincipalInvestigator, primeAdministrativeContact, primeFinancialContact));
        PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.PROJECT_BUDGET_INVOICE_DROPDOWN.getfName(), "");
        if (StringUtils.isNotBlank((CharSequence)templateInfo.getFinalStatementDueCd())) {
            PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.PROJECT_BUDGET_INVOICE_DROPDOWN.getfName(), FinalStatementDue.PTE.getCode().equals(templateInfo.getFinalStatementDueCd()) ? "Project Period end date." : "Budget Period end date.");
        }
        PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.TERM_6_CONTACT.getfName(), this.getTermContactFromCode(templateInfo.getChangeRequestsContactCd(), primeAuthorizedOfficial, primePrincipalInvestigator, primeAdministrativeContact, primeFinancialContact));
        PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.UNI_BI_MOD_DROPOWN.getfName(), configInfo.getFdpSubawardBilateralAgreements() ? "Bilaterally" : "Unilaterally");
        PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.TERM_7_CONTACT.getfName(), this.getTermContactFromCode(templateInfo.getChangeRequestsContactCd(), primeAuthorizedOfficial, primePrincipalInvestigator, primeAdministrativeContact, primeFinancialContact));
        PdfBoxUtils.setField(document, SubawardFdp.AgreementPdf.Field.TERM_9_CONTACT.getfName(), this.getTermContactFromCode(templateInfo.getTerminationContactCd(), primeAuthorizedOfficial, primePrincipalInvestigator, primeAdministrativeContact, primeFinancialContact));
    }

    private String getTermContactFromCode(String contactCode, SubContractDataDocument.SubContractData.PrimeAuthorizedOfficial primeAuthorizedOfficial, SubContractDataDocument.SubContractData.PrimePrincipalInvestigator primePrincipalInvestigator, SubContractDataDocument.SubContractData.PrimeAdministrativeContact primeAdministrativeContact, SubContractDataDocument.SubContractData.PrimeFinancialContact primeFinancialContact) {
        String termContact = StringUtils.isBlank((CharSequence)contactCode) ? "" : (contactCode.equals(primeAuthorizedOfficial.getContactTypeCode()) ? "Authorized Official" : (contactCode.equals(primePrincipalInvestigator.getContactTypeCode()) ? "Principal Investigator" : (contactCode.equals(primeAdministrativeContact.getContactTypeCode()) ? "Administrative" : (contactCode.equals(primeFinancialContact.getContactTypeCode()) ? "Financial" : ""))));
        return termContact;
    }
}

