/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import org.kuali.coeus.propdev.api.attachment.NarrativeAttachmentContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.impl.s2s.map.Attachment;
import org.kuali.coeus.propdev.impl.s2s.map.AttachmentMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.Attachments;
import org.kuali.coeus.propdev.impl.s2s.map.MappingConstants;
import org.kuali.coeus.s2sgen.api.hash.GrantApplicationHashService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="attachmentMappingService")
public class AttachmentMappingServiceImpl
implements AttachmentMappingService {
    @Autowired
    @Qualifier(value="grantApplicationHashService")
    private GrantApplicationHashService hashService;

    @Override
    public Attachments getAttachments(DevelopmentProposalContract proposal) {
        Attachments attachments = new Attachments();
        proposal.getNarratives().forEach(narrative -> attachments.setAdditionalProperty(this.mapType(narrative.getNarrativeType().getDescription()), this.toAttachment((NarrativeContract)narrative)));
        return attachments;
    }

    private Attachment toAttachment(NarrativeContract narrative) {
        byte[] content;
        NarrativeAttachmentContract narrativeAttachment = narrative.getNarrativeAttachment();
        if (narrativeAttachment != null && (content = narrativeAttachment.getData()) != null && content.length > 0) {
            Attachment attachment = new Attachment();
            attachment.setFileName(narrativeAttachment.getName());
            attachment.setHashValue(this.hashService.computeAttachmentHash(content));
            attachment.setFileId(narrativeAttachment.getFileDataId());
            return attachment;
        }
        return null;
    }

    private String mapType(String attachmentType) {
        return MappingConstants.ATTACHMENT_TYPES.getOrDefault(attachmentType, attachmentType);
    }
}

