/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.dao.AwardLookupDao;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.document.authorization.AwardDocumentAuthorizer;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public class AwardLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = 6304433555064511153L;
    static final String PERSON_ID = "personId";
    static final String ROLODEX_ID = "rolodexId";
    static final String UNIT_NUMBER = "unitNumber";
    static final String PI_NAME = "principalInvestigatorName";
    static final String OSP_ADMIN_NAME = "ospAdministratorName";
    public static final String OSP_ADMIN_USERNAME_PATH = "leadUnit.unitAdministrators.person.userName";
    public static final String OSP_ADMIN_PERSON_ID_PATH = "leadUnit.unitAdministrators.personId";
    public static final String OSP_ADMIN_TYPE_CODE_PATH = "leadUnit.unitAdministrators.unitAdministratorTypeCode";
    public static final String OSP_ADMIN_TYPE_CODE_VALUE = "2";
    public static final String PRINCIPAL_ID = "principalId";
    public static final String PRINCIPAL_NAME = "principalName";
    private transient KcPersonService kcPersonService;
    private AwardLookupDao awardLookupDao;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        KcPerson person;
        HashMap formProps = new HashMap();
        if (!StringUtils.isEmpty((CharSequence)fieldValues.get(OSP_ADMIN_USERNAME_PATH)) && (person = this.kcPersonService.getKcPersonByUserName(fieldValues.get(OSP_ADMIN_USERNAME_PATH))) != null) {
            fieldValues.put(OSP_ADMIN_PERSON_ID_PATH, person.getPersonId());
            fieldValues.put(OSP_ADMIN_TYPE_CODE_PATH, OSP_ADMIN_TYPE_CODE_VALUE);
        }
        boolean usePrimaryKeys = this.getLookupService().allPrimaryKeyValuesPresentAndNotWildcard(Award.class, fieldValues);
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        List<? extends BusinessObject> unboundedResults = this.getAwardLookupDao().getAwardSearchResults(fieldValues, usePrimaryKeys);
        CollectionIncomplete filteredResults = new ArrayList();
        filteredResults = this.filterForPermissions(unboundedResults);
        if (unboundedResults instanceof CollectionIncomplete) {
            filteredResults = new CollectionIncomplete(filteredResults, ((CollectionIncomplete)unboundedResults).getActualSizeIfTruncated());
        }
        return filteredResults;
    }

    public List<Award> filterForPermissions(List<Award> results) {
        Person user = GlobalVariables.getUserSession().getPerson();
        AwardDocumentAuthorizer authorizer = new AwardDocumentAuthorizer();
        ArrayList<Award> filteredResults = new ArrayList<Award>();
        for (Award award : results) {
            if (award == null || !authorizer.canOpen((Document)award.getAwardDocument(), user)) continue;
            filteredResults.add(award);
        }
        return filteredResults;
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List<HtmlData> htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        AwardDocument document = ((Award)businessObject).getAwardDocument();
        htmlDataList.add((HtmlData)this.getOpenLink((Award)businessObject, false));
        htmlDataList.add((HtmlData)this.getCopyLink((Award)businessObject, false));
        htmlDataList.add((HtmlData)this.getMedusaLink((Award)businessObject, (Boolean)false));
        return htmlDataList;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName().equals(PI_NAME)) {
                    super.updateLookupField(field, PI_NAME, AwardPerson.class.getName());
                    continue;
                }
                if (!field.getPropertyName().equals(OSP_ADMIN_USERNAME_PATH)) continue;
                field.setFieldConversions("principalName:leadUnit.unitAdministrators.person.userName,principalId:leadUnit.unitAdministrators.personId");
            }
        }
        return rows;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        Award award = (Award)bo;
        HtmlData inquiryUrl = super.getInquiryUrl(bo, propertyName);
        if (propertyName.equals(UNIT_NUMBER)) {
            inquiryUrl = this.getUnitNumberInquiryUrl(award);
        } else if (propertyName.equals(PI_NAME)) {
            inquiryUrl = this.getPrincipalInvestigatorNameInquiryUrl(award);
        } else if (propertyName.equals(OSP_ADMIN_NAME)) {
            inquiryUrl = this.getOspAdminNameInquiryUrl(award);
        }
        return inquiryUrl;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(Award award, Boolean viewOnly) {
        AwardDocument awardDocument = award.getAwardDocument();
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("open");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", viewOnly.toString());
        parameters.put("docOpenedFromAwardSearch", "true");
        parameters.put("docId", awardDocument.getDocumentNumber());
        parameters.put("placeHolderAwardId", award.getAwardId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getMedusaLink(Award award, Boolean readOnly) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("medusa");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "medusa");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", readOnly.toString());
        parameters.put("docId", award.getAwardDocument().getDocumentNumber());
        parameters.put("docOpenedFromAwardSearch", "true");
        parameters.put("placeHolderAwardId", award.getAwardId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getCopyLink(Award award, Boolean readOnly) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("copy");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "awardActions");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", readOnly.toString());
        parameters.put("docId", award.getAwardDocument().getDocumentNumber());
        parameters.put("docOpenedFromAwardSearch", "true");
        parameters.put("placeHolderAwardId", award.getAwardId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData getOspAdminNameInquiryUrl(Award award) {
        KcPerson ospAdministrator = award.getOspAdministrator();
        if (ospAdministrator != null) {
            KcPerson inqBo = this.kcPersonService.getKcPersonByPersonId(ospAdministrator.getPersonId());
            return super.getInquiryUrl((BusinessObject)inqBo, PERSON_ID);
        }
        return null;
    }

    protected HtmlData getPrincipalInvestigatorNameInquiryUrl(Award award) {
        HtmlData inquiryUrl = null;
        AwardPerson principalInvestigator = award.getPrincipalInvestigator();
        if (principalInvestigator != null) {
            if (StringUtils.isNotBlank((CharSequence)principalInvestigator.getPersonId())) {
                try {
                    KcPerson inqBo = this.kcPersonService.getKcPersonByPersonId(principalInvestigator.getPersonId());
                    inquiryUrl = super.getInquiryUrl((BusinessObject)inqBo, PERSON_ID);
                }
                catch (IllegalArgumentException e) {
                    LOG.info("getPrincipalInvestigatorNameInquiryUrl(Award award): ignoring missing person/entity: " + principalInvestigator.getPersonId());
                }
            } else if (principalInvestigator.getRolodexId() != null) {
                Rolodex inqBo = new Rolodex();
                inqBo.setRolodexId(principalInvestigator.getRolodexId());
                inquiryUrl = super.getInquiryUrl((BusinessObject)inqBo, ROLODEX_ID);
            }
        }
        return inquiryUrl;
    }

    protected HtmlData getUnitNumberInquiryUrl(Award award) {
        Unit inqBo = new Unit();
        Unit leadUnit = award.getLeadUnit();
        inqBo.setUnitNumber(leadUnit != null ? leadUnit.getUnitNumber() : null);
        return super.getInquiryUrl((BusinessObject)inqBo, UNIT_NUMBER);
    }

    @Override
    protected String getHtmlAction() {
        return "awardHome.do";
    }

    @Override
    protected void addEditHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
    }

    @Override
    protected String getDocumentTypeName() {
        return "AwardDocument";
    }

    @Override
    protected String getKeyFieldName() {
        return "awardId";
    }

    public AwardLookupDao getAwardLookupDao() {
        return this.awardLookupDao;
    }

    public void setAwardLookupDao(AwardLookupDao awardLookupDao) {
        this.awardLookupDao = awardLookupDao;
    }
}

