/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.printing.xmlstream;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewApprovalType;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewType;
import org.kuali.coeus.common.framework.costshare.CostShareService;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeService;
import org.kuali.coeus.common.framework.noo.NoticeOfOpportunity;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.framework.sponsor.Sponsor;
import org.kuali.coeus.common.framework.type.ActivityType;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.institutionalproposal.ProposalStatus;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.customdata.InstitutionalProposalCustomData;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCfda;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalComment;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalScienceKeyword;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.kra.institutionalproposal.printing.InstitutionalProposalPrintType;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.printing.schema.ActivityType;
import org.kuali.kra.printing.schema.AnticipatedAwardType;
import org.kuali.kra.printing.schema.BudgetDataType;
import org.kuali.kra.printing.schema.CostSharingType;
import org.kuali.kra.printing.schema.IDCRateType;
import org.kuali.kra.printing.schema.IPDisclosureItemType;
import org.kuali.kra.printing.schema.IPKeyPersonType;
import org.kuali.kra.printing.schema.IPSchoolInfoType;
import org.kuali.kra.printing.schema.IPsponsorType;
import org.kuali.kra.printing.schema.InstProposalMasterData;
import org.kuali.kra.printing.schema.InstituteProposalDocument;
import org.kuali.kra.printing.schema.InvestigatorType2;
import org.kuali.kra.printing.schema.MailingInfoType;
import org.kuali.kra.printing.schema.NSFcodeType;
import org.kuali.kra.printing.schema.NoticeOfOppType;
import org.kuali.kra.printing.schema.OtherGroupDetailsTypes;
import org.kuali.kra.printing.schema.OtherGroupTypes;
import org.kuali.kra.printing.schema.PersonType;
import org.kuali.kra.printing.schema.ProposalStatusType;
import org.kuali.kra.printing.schema.ProposalType;
import org.kuali.kra.printing.schema.ScienceCodeType;
import org.kuali.kra.printing.schema.SpecialReviewType2;
import org.kuali.kra.printing.schema.UnitType;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class InstitutionalProposalXmlStream
implements XmlStream<InstituteProposalDocument> {
    private static final String PROPOSAL_SUMMARY_COMMENT_CODE = "21";
    private static final String SPONSOR_CODE = "sponsorCode";
    private static final String NOTICE_OF_OPPORTUNITY_CODE = "code";
    private static final String PROPOSAL_TYPE_CODE = "code";
    private static final String PROPOSAL_STATUS_CODE = "proposalStatusCode";
    private static final String SCHOOL_NAME = "SCHOOL_NAME";
    private static final String SCHOOL_ACRONYM = "SCHOOL_ACRONYM";
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private ParameterService parameterService;
    private CostShareService costShareService;
    private CustomAttributeService customAttributeService;

    @Override
    public Class<InstituteProposalDocument> type() {
        return InstituteProposalDocument.class;
    }

    @Override
    public Map<String, InstituteProposalDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, InstituteProposalDocument> xmlObjectList = new LinkedHashMap<String, InstituteProposalDocument>();
        InstitutionalProposal institutionalProposal = (InstitutionalProposal)printableBusinessObject;
        InstituteProposalDocument instituteProposalDocument = InstituteProposalDocument.Factory.newInstance();
        InstituteProposalDocument.InstituteProposal instituteProposalXmlObject = this.getInstituteProposal(institutionalProposal);
        instituteProposalDocument.setInstituteProposal(instituteProposalXmlObject);
        xmlObjectList.put(InstitutionalProposalPrintType.INSTITUTIONAL_PROPOSAL_REPORT.getInstitutionalProposalPrintType(), instituteProposalDocument);
        return xmlObjectList;
    }

    private InstituteProposalDocument.InstituteProposal getInstituteProposal(InstitutionalProposal institutionalProposal) {
        InstituteProposalDocument.InstituteProposal instituteProposalXmlObject = InstituteProposalDocument.InstituteProposal.Factory.newInstance();
        instituteProposalXmlObject.setInstProposalMaster(this.getInstProposalMasterData(institutionalProposal));
        instituteProposalXmlObject.setInvestigatorsArray(this.getInvestigatorTypes(institutionalProposal));
        instituteProposalXmlObject.setBudgetData(this.getBudgetDataType(institutionalProposal));
        instituteProposalXmlObject.setMailingInfo(this.getMailingInfoType(institutionalProposal));
        instituteProposalXmlObject.setIDCRatesArray(this.getIdcRateTypes(institutionalProposal));
        if (institutionalProposal.getUnrecoveredFandAComment() != null) {
            instituteProposalXmlObject.setIDCRatesComments(institutionalProposal.getUnrecoveredFandAComment().getComments());
        }
        if (institutionalProposal.getCostShareComment() != null) {
            instituteProposalXmlObject.setCostSharingComments(institutionalProposal.getCostShareComment().getComments());
        }
        instituteProposalXmlObject.setSpecialReviewsArray(this.getSpecialReviewTypes(institutionalProposal));
        instituteProposalXmlObject.setCostSharingInfoArray(this.getCostSharingTypes(institutionalProposal));
        instituteProposalXmlObject.setScienceCodeArray(this.getScienceCodes(institutionalProposal));
        instituteProposalXmlObject.setSchoolInfo(this.getSchoolInfoType());
        IPDisclosureItemType[] disclosureItemTypes = this.getDisclosureItems();
        instituteProposalXmlObject.setDisclosureItemArray(disclosureItemTypes);
        instituteProposalXmlObject.setKeyPersonsArray(this.getKeyPersons(institutionalProposal));
        instituteProposalXmlObject.setCostSharingProjectPeriodFieldDescription(this.getProjectPeriodFieldDescription());
        instituteProposalXmlObject.setCFDANum(institutionalProposal.getProposalCfdas().stream().map(InstitutionalProposalCfda::getCfdaNumber).collect(Collectors.joining(",")));
        instituteProposalXmlObject.setOpportunityID(institutionalProposal.getOpportunity());
        instituteProposalXmlObject.setOtherData(this.getCustomData(institutionalProposal));
        return instituteProposalXmlObject;
    }

    private String getProjectPeriodFieldDescription() {
        return this.getCostShareService().getCostShareLabel();
    }

    private OtherGroupTypes getCustomData(InstitutionalProposal institutionalProposal) {
        Map<String, CustomAttributeDocument> customAttributeDocuments = this.getCustomAttributeService().getDefaultCustomAttributeDocuments(institutionalProposal.getInstitutionalProposalDocument().getDocumentTypeCode(), institutionalProposal.getInstitutionalProposalCustomDataList());
        OtherGroupTypes otherGroup = OtherGroupTypes.Factory.newInstance();
        LinkedList<OtherGroupDetailsTypes> otherGroupDetailsTypesList = new LinkedList<OtherGroupDetailsTypes>();
        block0: for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
            OtherGroupDetailsTypes otherGroupDetails = OtherGroupDetailsTypes.Factory.newInstance();
            for (InstitutionalProposalCustomData custData : institutionalProposal.getInstitutionalProposalCustomDataList()) {
                if (custData.getCustomAttributeId().longValue() != customAttributeDocumentEntry.getValue().getCustomAttribute().getId().longValue() || !customAttributeDocuments.get(custData.getCustomAttributeId().toString()).getCustomAttribute().getGroupName().equalsIgnoreCase(this.getParameterService().getParameterValueAsString("KC-IP", "Document", "INSTITUTE_PROPOSAL_OTHER_GROUP"))) continue;
                otherGroup.setGroupName(customAttributeDocuments.get(custData.getCustomAttributeId().toString()).getCustomAttribute().getGroupName());
                otherGroupDetails.setColumnValue(custData.getValue());
                otherGroupDetails.setColumnName(customAttributeDocuments.get(custData.getCustomAttributeId().toString()).getCustomAttribute().getLabel());
                otherGroupDetailsTypesList.add(otherGroupDetails);
                continue block0;
            }
        }
        otherGroup.setOtherGroupDetailsArray(otherGroupDetailsTypesList.toArray(new OtherGroupDetailsTypes[0]));
        return otherGroup;
    }

    private IPKeyPersonType[] getKeyPersons(InstitutionalProposal institutionalProposal) {
        ArrayList<IPKeyPersonType> keyPersonTypes = new ArrayList<IPKeyPersonType>();
        for (InstitutionalProposalPerson proposalPerson : institutionalProposal.getProjectPersons()) {
            ContactRole role;
            KcPerson person;
            IPKeyPersonType keyPersonType = IPKeyPersonType.Factory.newInstance();
            if (institutionalProposal.getProposalNumber() != null) {
                keyPersonType.setProposalNumber(institutionalProposal.getProposalNumber());
            }
            if (proposalPerson.getPersonId() != null) {
                keyPersonType.setPersonId(proposalPerson.getPersonId());
            }
            if ((person = proposalPerson.getPerson()) != null && person.getFullName() != null) {
                keyPersonType.setPersonName(person.getFullName());
            }
            if ((role = proposalPerson.getContactRole()) != null && role.getRoleDescription() != null) {
                keyPersonType.setRoleName(role.getRoleDescription());
            }
            if (proposalPerson.getPerson() != null) {
                if (proposalPerson.getPerson().getAddressLine1() != null) {
                    keyPersonType.setPersonAddress(proposalPerson.getPerson().getAddressLine1());
                }
            } else if (proposalPerson.getRolodex() != null && proposalPerson.getRolodex().getAddressLine1() != null) {
                keyPersonType.setPersonAddress(proposalPerson.getRolodex().getAddressLine1());
            }
            if (proposalPerson.getTotalEffort() != null) {
                keyPersonType.setPercentEffort(proposalPerson.getTotalEffort().bigDecimalValue());
            }
            keyPersonType.setFaculty(proposalPerson.isFaculty());
            if (proposalPerson.getRolodexId() != null) {
                keyPersonType.setNonEmployee(true);
            }
            keyPersonTypes.add(keyPersonType);
        }
        return keyPersonTypes.toArray(new IPKeyPersonType[0]);
    }

    private InvestigatorType2[] getInvestigatorTypes(InstitutionalProposal institutionalProposal) {
        ArrayList<InvestigatorType2> investigatorTypesList = new ArrayList<InvestigatorType2>();
        for (InstitutionalProposalPerson proposalPerson : institutionalProposal.getProjectPersons()) {
            InvestigatorType2 investigatorType = InvestigatorType2.Factory.newInstance();
            PersonType personType = PersonType.Factory.newInstance();
            KcPerson person = proposalPerson.getPerson();
            if (person != null) {
                if (person.getAddressLine1() != null) {
                    personType.setAddress(person.getAddressLine1());
                }
                if (person.getCity() != null) {
                    personType.setCity(person.getCity());
                }
                if (person.getFirstName() != null) {
                    personType.setFirstName(person.getFirstName());
                }
                if (proposalPerson.getFullName() != null) {
                    personType.setFullName(proposalPerson.getFullName());
                }
                if (person.getLastName() != null) {
                    personType.setLastName(person.getLastName());
                }
                if (person.getMiddleName() != null) {
                    personType.setMiddleName(person.getMiddleName());
                }
                if (proposalPerson.getPhoneNumber() != null) {
                    personType.setPhone(proposalPerson.getPhoneNumber());
                }
                if (person.getState() != null) {
                    personType.setState(person.getState());
                }
                if (person.getPostalCode() != null) {
                    personType.setZip(person.getPostalCode());
                }
            } else {
                NonOrganizationalRolodex rolodex = proposalPerson.getRolodex();
                if (rolodex != null) {
                    if (rolodex.getAddressLine1() != null) {
                        personType.setAddress(rolodex.getAddressLine1());
                    }
                    if (rolodex.getCity() != null) {
                        personType.setCity(rolodex.getCity());
                    }
                    if (rolodex.getFirstName() != null) {
                        personType.setFirstName(rolodex.getFirstName());
                    }
                    if (proposalPerson.getFullName() != null) {
                        personType.setFullName(proposalPerson.getFullName());
                    }
                    if (rolodex.getLastName() != null) {
                        personType.setLastName(rolodex.getLastName());
                    }
                    if (rolodex.getMiddleName() != null) {
                        personType.setMiddleName(rolodex.getMiddleName());
                    }
                    if (proposalPerson.getPhoneNumber() != null) {
                        personType.setPhone(proposalPerson.getPhoneNumber());
                    }
                    if (rolodex.getState() != null) {
                        personType.setState(rolodex.getState());
                    }
                    if (rolodex.getPostalCode() != null) {
                        personType.setZip(rolodex.getPostalCode());
                    }
                }
            }
            investigatorType.setPIName(personType);
            investigatorType.setFacultyFlag(proposalPerson.isFaculty());
            investigatorType.setPrincipalInvFlag(proposalPerson.isPrincipalInvestigator());
            List<UnitType> unitTypes = this.getUnitTypes(proposalPerson);
            investigatorType.setUnitArray(unitTypes.toArray(new UnitType[0]));
            investigatorTypesList.add(investigatorType);
        }
        return investigatorTypesList.toArray(new InvestigatorType2[0]);
    }

    private List<UnitType> getUnitTypes(InstitutionalProposalPerson proposalPerson) {
        ArrayList<UnitType> unitTypes = new ArrayList<UnitType>();
        for (InstitutionalProposalPersonUnit proposalPersonUnit : proposalPerson.getUnits()) {
            UnitType unitType = UnitType.Factory.newInstance();
            unitType.setLeadUnitFlag(proposalPersonUnit.isLeadUnit());
            Unit unit = proposalPersonUnit.getUnit();
            if (unit != null) {
                if (unit.getUnitName() != null) {
                    unitType.setUnitName(unit.getUnitName());
                }
                if (unit.getUnitNumber() != null) {
                    unitType.setUnitNumber(unit.getUnitNumber());
                }
            }
            unitTypes.add(unitType);
        }
        return unitTypes;
    }

    private IPDisclosureItemType[] getDisclosureItems() {
        ArrayList<IPDisclosureItemType> disclosureItemTypesList = new ArrayList<IPDisclosureItemType>();
        IPDisclosureItemType disclosureItemType = IPDisclosureItemType.Factory.newInstance();
        disclosureItemTypesList.add(disclosureItemType);
        return disclosureItemTypesList.toArray(new IPDisclosureItemType[0]);
    }

    private IPSchoolInfoType getSchoolInfoType() {
        IPSchoolInfoType schoolInfoType = IPSchoolInfoType.Factory.newInstance();
        String schoolName = this.getIPParameterValue(SCHOOL_NAME);
        String schoolAcronym = this.getIPParameterValue(SCHOOL_ACRONYM);
        if (schoolName != null) {
            schoolInfoType.setSchoolName(schoolName);
        }
        if (schoolAcronym != null) {
            schoolInfoType.setAcronym(schoolAcronym);
        }
        return schoolInfoType;
    }

    private ScienceCodeType[] getScienceCodes(InstitutionalProposal institutionalProposal) {
        ArrayList<ScienceCodeType> scienceCodeTypelist = new ArrayList<ScienceCodeType>();
        for (InstitutionalProposalScienceKeyword institutionalProposalScienceKeyword : institutionalProposal.getInstitutionalProposalScienceKeywords()) {
            ScienceCodeType scienceCodeType = ScienceCodeType.Factory.newInstance();
            if (institutionalProposalScienceKeyword.getScienceKeywordCode() != null) {
                scienceCodeType.setScienceCode(institutionalProposalScienceKeyword.getScienceKeywordCode());
            }
            if (institutionalProposalScienceKeyword.getScienceKeyword().getDescription() != null) {
                scienceCodeType.setScienceCodeDesc(institutionalProposalScienceKeyword.getScienceKeyword().getDescription());
            }
            scienceCodeTypelist.add(scienceCodeType);
        }
        return scienceCodeTypelist.toArray(new ScienceCodeType[0]);
    }

    private CostSharingType[] getCostSharingTypes(InstitutionalProposal institutionalProposal) {
        ArrayList<CostSharingType> costSharingTypes = new ArrayList<CostSharingType>();
        for (InstitutionalProposalCostShare institutionalProposalCostShare : institutionalProposal.getInstitutionalProposalCostShares()) {
            CostSharingType costSharingType = CostSharingType.Factory.newInstance();
            if (institutionalProposalCostShare.getAmount() != null) {
                costSharingType.setAmount(institutionalProposalCostShare.getAmount().doubleValue());
            }
            institutionalProposalCostShare.refreshReferenceObject("costShareType");
            if (institutionalProposalCostShare.getCostShareType() != null) {
                costSharingType.setCostSharingType(institutionalProposalCostShare.getCostShareTypeCode() + " - " + institutionalProposalCostShare.getCostShareType().getDescription());
            }
            if (institutionalProposalCostShare.getProjectPeriod() != null) {
                costSharingType.setFY(institutionalProposalCostShare.getProjectPeriod());
            }
            if (institutionalProposalCostShare.getSourceAccount() != null) {
                costSharingType.setSourceAccount(institutionalProposalCostShare.getSourceAccount());
            }
            if (institutionalProposalCostShare.getCostSharePercentage() != null) {
                costSharingType.setPercentage(institutionalProposalCostShare.getCostSharePercentage().doubleValue());
            }
            costSharingTypes.add(costSharingType);
        }
        return costSharingTypes.toArray(new CostSharingType[0]);
    }

    private SpecialReviewType2[] getSpecialReviewTypes(InstitutionalProposal institutionalProposal) {
        ArrayList<SpecialReviewType2> specialReviewTypes = new ArrayList<SpecialReviewType2>();
        for (InstitutionalProposalSpecialReview institutionalProposalSpecialReview : institutionalProposal.getSpecialReviews()) {
            SpecialReviewType2 specialReviewType = SpecialReviewType2.Factory.newInstance();
            institutionalProposalSpecialReview.refreshNonUpdateableReferences();
            SpecialReviewApprovalType specialReviewApprovalType = institutionalProposalSpecialReview.getApprovalType();
            if (institutionalProposalSpecialReview.getApplicationDate() != null) {
                specialReviewType.setApplicationDate(this.dateTimeService.getCalendar((Date)institutionalProposalSpecialReview.getApplicationDate()));
            }
            if (institutionalProposalSpecialReview.getApprovalDate() != null) {
                specialReviewType.setApprovalDate(this.dateTimeService.getCalendar((Date)institutionalProposalSpecialReview.getApprovalDate()));
            }
            if (specialReviewApprovalType != null) {
                specialReviewType.setSpecialReviewStatus(specialReviewApprovalType.getDescription());
            }
            specialReviewType.setProtocolNumber(institutionalProposalSpecialReview.getProtocolNumber());
            SpecialReviewType specialReview = institutionalProposalSpecialReview.getSpecialReviewType();
            if (specialReview != null && specialReview.getDescription() != null) {
                specialReviewType.setSpecialReviewType(specialReview.getDescription());
            }
            if (institutionalProposalSpecialReview.getComments() != null) {
                specialReviewType.setComments(institutionalProposalSpecialReview.getComments());
            }
            specialReviewTypes.add(specialReviewType);
        }
        return specialReviewTypes.toArray(new SpecialReviewType2[0]);
    }

    private IDCRateType[] getIdcRateTypes(InstitutionalProposal institutionalProposal) {
        ArrayList<IDCRateType> idcRateTypes = new ArrayList<IDCRateType>();
        for (InstitutionalProposalUnrecoveredFandA institutionalProposalUnrecoveredFandA : institutionalProposal.getInstitutionalProposalUnrecoveredFandAs()) {
            IDCRateType idcRateType = IDCRateType.Factory.newInstance();
            if (institutionalProposalUnrecoveredFandA.getFiscalYear() != null) {
                idcRateType.setFY(institutionalProposalUnrecoveredFandA.getFiscalYear());
            }
            idcRateType.setOnCampus(institutionalProposalUnrecoveredFandA.getOnCampusFlag());
            if (institutionalProposalUnrecoveredFandA.getSourceAccount() != null) {
                idcRateType.setSourceAccount(institutionalProposalUnrecoveredFandA.getSourceAccount());
            }
            if (institutionalProposalUnrecoveredFandA.getUnderrecoveryOfIndirectcost() != null) {
                idcRateType.setUnderRecovery(institutionalProposalUnrecoveredFandA.getUnderrecoveryOfIndirectcost().doubleValue());
            }
            institutionalProposalUnrecoveredFandA.refreshReferenceObject("indirectcostRateType");
            if (institutionalProposalUnrecoveredFandA.getIndirectcostRateType() != null) {
                idcRateType.setRateType(institutionalProposalUnrecoveredFandA.getIndirectcostRateTypeCode() + " - " + institutionalProposalUnrecoveredFandA.getIndirectcostRateType().getDescription());
            }
            if (institutionalProposalUnrecoveredFandA.getApplicableIndirectcostRate() != null) {
                idcRateType.setRate(institutionalProposalUnrecoveredFandA.getApplicableIndirectcostRate().doubleValue());
            }
            idcRateTypes.add(idcRateType);
        }
        return idcRateTypes.toArray(new IDCRateType[0]);
    }

    private MailingInfoType getMailingInfoType(InstitutionalProposal institutionalProposal) {
        Rolodex rolodex;
        MailingInfoType mailingInfoType = MailingInfoType.Factory.newInstance();
        if (institutionalProposal.getDeadlineDate() != null) {
            mailingInfoType.setDeadlineDate(this.dateTimeService.getCalendar((Date)institutionalProposal.getDeadlineDate()));
        }
        mailingInfoType.setDeadlineType(institutionalProposal.getDeadlineType());
        mailingInfoType.setMailByOSP(institutionalProposal.getMailBy());
        mailingInfoType.setMailType(institutionalProposal.getMailType());
        if (institutionalProposal.getMailAccountNumber() != null) {
            mailingInfoType.setMailAccount(institutionalProposal.getMailAccountNumber());
        }
        if (institutionalProposal.getNumberOfCopies() != null) {
            mailingInfoType.setNumberCopies(Integer.valueOf(institutionalProposal.getNumberOfCopies()));
        }
        if ((rolodex = institutionalProposal.getRolodex()) != null) {
            PersonType personType = PersonType.Factory.newInstance();
            if (rolodex.getFirstName() != null) {
                personType.setFirstName(rolodex.getFirstName());
            }
            if (rolodex.getLastName() != null) {
                personType.setLastName(rolodex.getLastName());
            }
            if (rolodex.getCity() != null) {
                personType.setCity(rolodex.getCity());
            }
            if (rolodex.getMiddleName() != null) {
                personType.setMiddleName(rolodex.getMiddleName());
            }
            if (rolodex.getPhoneNumber() != null) {
                personType.setPhone(rolodex.getPhoneNumber());
            }
            if (rolodex.getState() != null) {
                personType.setState(rolodex.getState());
            }
            if (rolodex.getFullName() != null) {
                personType.setFullName(rolodex.getFullName());
            }
            if (rolodex.getPostalCode() != null) {
                personType.setZip(rolodex.getPostalCode());
            }
            if (rolodex.getAddressLine1() != null) {
                personType.setAddress(rolodex.getAddressLine1());
            }
            mailingInfoType.setMailToPerson(personType);
        }
        if (institutionalProposal.getProposalComments() != null && institutionalProposal.getDeliveryComment().getComments() != null) {
            mailingInfoType.setComments(institutionalProposal.getDeliveryComment().getComments());
        }
        return mailingInfoType;
    }

    private BudgetDataType getBudgetDataType(InstitutionalProposal institutionalProposal) {
        BudgetDataType budgetDataType = BudgetDataType.Factory.newInstance();
        budgetDataType.setAccountType(String.valueOf(institutionalProposal.getTypeOfAccount()));
        if (institutionalProposal.getRequestedStartDateInitial() != null) {
            budgetDataType.setRequestedStartDateInitial(this.dateTimeService.getCalendar((Date)institutionalProposal.getRequestedStartDateInitial()));
        }
        if (institutionalProposal.getRequestedEndDateInitial() != null) {
            budgetDataType.setRequestedEndDateInitial(this.dateTimeService.getCalendar((Date)institutionalProposal.getRequestedEndDateInitial()));
        }
        if (institutionalProposal.getRequestedStartDateTotal() != null) {
            budgetDataType.setRequestedStartDateTotal(this.dateTimeService.getCalendar((Date)institutionalProposal.getRequestedStartDateTotal()));
        }
        if (institutionalProposal.getRequestedEndDateTotal() != null) {
            budgetDataType.setRequestedEndDateTotal(this.dateTimeService.getCalendar((Date)institutionalProposal.getRequestedEndDateTotal()));
        }
        if (institutionalProposal.getTotalDirectCostInitial() != null) {
            budgetDataType.setTotalDirectCostInitial(institutionalProposal.getTotalDirectCostInitial().bigDecimalValue());
        }
        if (institutionalProposal.getTotalDirectCostTotal() != null) {
            budgetDataType.setTotalDirectCostTotal(institutionalProposal.getTotalDirectCostTotal().bigDecimalValue());
        }
        if (institutionalProposal.getTotalIndirectCostInitial() != null) {
            budgetDataType.setTotalIndirectCostInitial(institutionalProposal.getTotalIndirectCostInitial().bigDecimalValue());
        }
        if (institutionalProposal.getTotalIndirectCostTotal() != null) {
            budgetDataType.setTotalIndirectCostTotal(institutionalProposal.getTotalIndirectCostTotal().bigDecimalValue());
        }
        if (institutionalProposal.getTotalInitialCost() != null) {
            budgetDataType.setTotalCostInitial(institutionalProposal.getTotalInitialCost().bigDecimalValue());
        }
        if (institutionalProposal.getTotalCost() != null) {
            budgetDataType.setTotalCostTotal(institutionalProposal.getTotalCost().bigDecimalValue());
        }
        return budgetDataType;
    }

    private InstProposalMasterData getInstProposalMasterData(InstitutionalProposal institutionalProposal) {
        InstProposalMasterData instProposalMasterData = InstProposalMasterData.Factory.newInstance();
        instProposalMasterData.setProposalNumber(institutionalProposal.getProposalNumber());
        if (institutionalProposal.getCurrentAccountNumber() != null) {
            instProposalMasterData.setAccountNumber(institutionalProposal.getCurrentAccountNumber());
        }
        if (institutionalProposal.getCurrentAwardNumber() != null) {
            instProposalMasterData.setAwardNumber(institutionalProposal.getCurrentAwardNumber());
        }
        this.setProposalStatus(institutionalProposal, instProposalMasterData);
        this.setProposalType(institutionalProposal, instProposalMasterData);
        instProposalMasterData.setTitle(institutionalProposal.getTitle());
        this.setActivityType(institutionalProposal, instProposalMasterData);
        if (institutionalProposal.getSponsorProposalNumber() != null) {
            instProposalMasterData.setSponsorProposalNumber(institutionalProposal.getSponsorProposalNumber());
        }
        this.setNoticeOfOpportunity(institutionalProposal, instProposalMasterData);
        this.setNSFCode(institutionalProposal, instProposalMasterData);
        this.setSponsor(institutionalProposal, instProposalMasterData);
        this.setPrimeSponsor(institutionalProposal, instProposalMasterData);
        instProposalMasterData.setHasSubcontracts(institutionalProposal.getSubcontractFlag());
        if (institutionalProposal.getGradStudHeadcount() != null) {
            instProposalMasterData.setGradStudentCount(institutionalProposal.getGradStudHeadcount());
        }
        if (institutionalProposal.getGradStudPersonMonths() != null) {
            instProposalMasterData.setGradStudentmonths(institutionalProposal.getGradStudPersonMonths().doubleValue());
        }
        instProposalMasterData.setAccountType(String.valueOf(institutionalProposal.getTypeOfAccount()));
        if (institutionalProposal.getSequenceNumber() != null) {
            instProposalMasterData.setSequenceNumber(institutionalProposal.getSequenceNumber());
        }
        this.setComments(institutionalProposal, instProposalMasterData);
        this.setAnticipatedAwardType(institutionalProposal, instProposalMasterData);
        return instProposalMasterData;
    }

    private void setAnticipatedAwardType(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        AwardType awardType;
        AnticipatedAwardType anticipatedAwardType = AnticipatedAwardType.Factory.newInstance();
        if (institutionalProposal.getAwardTypeCode() != null) {
            anticipatedAwardType.setAnticipatedAwardTypeCode(institutionalProposal.getAwardTypeCode());
        }
        if ((awardType = institutionalProposal.getAwardType()) != null && awardType.getDescription() != null) {
            anticipatedAwardType.setAnticipatedAwardTypeDesc(awardType.getDescription());
        }
        instProposalMasterData.setAnticipatedAwardType(anticipatedAwardType);
    }

    private void setComments(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        InstitutionalProposalComment institutionalProposalComments;
        if (institutionalProposal.getProposalComments() != null && (institutionalProposalComments = institutionalProposal.getSummaryComment()) != null && institutionalProposalComments.getCommentTypeCode().equals(PROPOSAL_SUMMARY_COMMENT_CODE)) {
            instProposalMasterData.setComments(institutionalProposalComments.getComments());
        }
    }

    private void setPrimeSponsor(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getPrimeSponsorCode() != null) {
            IPsponsorType primeSponsorType = IPsponsorType.Factory.newInstance();
            String primeSponsorCode = institutionalProposal.getPrimeSponsorCode();
            primeSponsorType.setSponsorCode(primeSponsorCode);
            String primeSponsorName = this.getPrimeSponsorName(primeSponsorCode);
            if (primeSponsorName != null) {
                primeSponsorType.setSponsorName(primeSponsorName);
            }
            instProposalMasterData.setPrimeSponsor(primeSponsorType);
        }
    }

    private void setSponsor(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getSponsor() != null) {
            Sponsor sponsor = institutionalProposal.getSponsor();
            IPsponsorType sponsorType = IPsponsorType.Factory.newInstance();
            if (sponsor.getSponsorCode() != null) {
                sponsorType.setSponsorCode(sponsor.getSponsorCode());
            }
            if (sponsor.getSponsorName() != null) {
                sponsorType.setSponsorName(sponsor.getSponsorName());
            }
            instProposalMasterData.setSponsor(sponsorType);
        }
    }

    private void setNSFCode(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getSequenceNumber() != null && institutionalProposal.getNsfCodeBo() != null) {
            NSFcodeType nsfCodeType = NSFcodeType.Factory.newInstance();
            String nsfCode = institutionalProposal.getNsfCodeBo().getNsfCode();
            nsfCodeType.setNSFcode(nsfCode);
            String nsfDesc = institutionalProposal.getNsfCodeBo().getDescription();
            if (nsfDesc != null) {
                nsfCodeType.setNSFcodeDesc(nsfDesc);
            }
            instProposalMasterData.setNSFcode(nsfCodeType);
        }
    }

    private void setNoticeOfOpportunity(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getNoticeOfOpportunityCode() != null) {
            NoticeOfOppType noticeOfOppType = NoticeOfOppType.Factory.newInstance();
            String noticeOfOpportunityCode = institutionalProposal.getNoticeOfOpportunityCode();
            noticeOfOppType.setNoticeOfOppcode(noticeOfOpportunityCode);
            String noticeOfOpportunityDesc = this.getNoticeOfOpportunityDesc(noticeOfOpportunityCode);
            if (noticeOfOpportunityDesc != null) {
                noticeOfOppType.setNoticeOfOppDesc(noticeOfOpportunityDesc);
            }
            instProposalMasterData.setNoticeOfOpportunity(noticeOfOppType);
        }
    }

    private void setActivityType(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getActivityType() != null) {
            ActivityType activityType = institutionalProposal.getActivityType();
            org.kuali.kra.printing.schema.ActivityType activityTypeXmlObject = ActivityType.Factory.newInstance();
            if (activityType.getCode() != null) {
                activityTypeXmlObject.setActivityTypeCode(Integer.valueOf(activityType.getCode()));
            }
            if (activityType.getDescription() != null) {
                activityTypeXmlObject.setActivityTypeDesc(activityType.getDescription());
            }
            instProposalMasterData.setActivityType(activityTypeXmlObject);
        }
    }

    private void setProposalType(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getProposalTypeCode() != null) {
            ProposalType proposalType = ProposalType.Factory.newInstance();
            int proposalTypeCode = institutionalProposal.getProposalTypeCode();
            proposalType.setProposalTypeCode(proposalTypeCode);
            String proposalTypeDescription = this.getProposalTypeDescription(proposalTypeCode);
            if (proposalTypeDescription != null) {
                proposalType.setProposalTypeDesc(proposalTypeDescription);
            }
            instProposalMasterData.setProposalType(proposalType);
        }
    }

    private void setProposalStatus(InstitutionalProposal institutionalProposal, InstProposalMasterData instProposalMasterData) {
        if (institutionalProposal.getStatusCode() != null) {
            ProposalStatusType proposalStatusType = ProposalStatusType.Factory.newInstance();
            int proposalStatusCode = institutionalProposal.getStatusCode();
            proposalStatusType.setStatusCode(proposalStatusCode);
            String proposalDescription = this.getProposalDescription(proposalStatusCode);
            if (proposalDescription != null) {
                proposalStatusType.setStatusDesc(proposalDescription);
            }
            instProposalMasterData.setProposalStatus(proposalStatusType);
        }
    }

    private String getPrimeSponsorName(String primeSponsorCode) {
        String primeSponsorName = null;
        HashMap<String, String> sponsorMap = new HashMap<String, String>();
        sponsorMap.put(SPONSOR_CODE, primeSponsorCode);
        List sponsorList = (List)this.businessObjectService.findMatching(Sponsor.class, sponsorMap);
        if (sponsorList != null && !sponsorList.isEmpty()) {
            Sponsor sponsor = (Sponsor)sponsorList.get(0);
            primeSponsorName = sponsor.getSponsorName();
        }
        return primeSponsorName;
    }

    private String getNoticeOfOpportunityDesc(String noticeOfOpportunityCode) {
        String noticeOfOpportunityDesc = null;
        HashMap<String, String> noticeOfOppMap = new HashMap<String, String>();
        noticeOfOppMap.put("code", noticeOfOpportunityCode);
        List noticeOfOppList = (List)this.businessObjectService.findMatching(NoticeOfOpportunity.class, noticeOfOppMap);
        if (noticeOfOppList != null && !noticeOfOppList.isEmpty()) {
            NoticeOfOpportunity noticeOfOpportunity = (NoticeOfOpportunity)noticeOfOppList.get(0);
            noticeOfOpportunityDesc = noticeOfOpportunity.getDescription();
        }
        return noticeOfOpportunityDesc;
    }

    private String getProposalTypeDescription(int proposalTypeCode) {
        String proposalTypeDescription = null;
        HashMap<String, String> proposalTypeDescMap = new HashMap<String, String>();
        proposalTypeDescMap.put("code", String.valueOf(proposalTypeCode));
        List proposalTypeList = (List)this.businessObjectService.findMatching(org.kuali.coeus.common.framework.type.ProposalType.class, proposalTypeDescMap);
        if (proposalTypeList != null && !proposalTypeList.isEmpty()) {
            org.kuali.coeus.common.framework.type.ProposalType proposalType = (org.kuali.coeus.common.framework.type.ProposalType)proposalTypeList.get(0);
            proposalTypeDescription = proposalType.getDescription();
        }
        return proposalTypeDescription;
    }

    private String getProposalDescription(int proposalStatusCode) {
        String proposalDescription = null;
        HashMap<String, String> proposalStatusMap = new HashMap<String, String>();
        proposalStatusMap.put(PROPOSAL_STATUS_CODE, String.valueOf(proposalStatusCode));
        List proposalStatusList = (List)this.businessObjectService.findMatching(ProposalStatus.class, proposalStatusMap);
        if (proposalStatusList != null && !proposalStatusList.isEmpty()) {
            ProposalStatus proposalStatus = (ProposalStatus)proposalStatusList.get(0);
            proposalDescription = proposalStatus.getDescription();
        }
        return proposalDescription;
    }

    private String getIPParameterValue(String param) {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, param);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public CostShareService getCostShareService() {
        return this.costShareService;
    }

    public void setCostShareService(CostShareService costShareService) {
        this.costShareService = costShareService;
    }

    public CustomAttributeService getCustomAttributeService() {
        return this.customAttributeService;
    }

    public void setCustomAttributeService(CustomAttributeService customAttributeService) {
        this.customAttributeService = customAttributeService;
    }
}

