/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.usage;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.usage.NodeUsage;
import org.elasticsearch.action.admin.cluster.node.usage.NodesUsageRequest;
import org.elasticsearch.action.admin.cluster.node.usage.NodesUsageResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.usage.UsageService;

public class TransportNodesUsageAction
extends TransportNodesAction<NodesUsageRequest, NodesUsageResponse, NodeUsageRequest, NodeUsage> {
    private UsageService usageService;

    @Inject
    public TransportNodesUsageAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, UsageService usageService) {
        super("cluster:monitor/nodes/usage", threadPool, clusterService, transportService, actionFilters, NodesUsageRequest::new, NodeUsageRequest::new, "management", NodeUsage.class);
        this.usageService = usageService;
    }

    @Override
    protected NodesUsageResponse newResponse(NodesUsageRequest request, List<NodeUsage> responses, List<FailedNodeException> failures) {
        return new NodesUsageResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeUsageRequest newNodeRequest(NodesUsageRequest request) {
        return new NodeUsageRequest(request);
    }

    @Override
    protected NodeUsage newNodeResponse(StreamInput in) throws IOException {
        return new NodeUsage(in);
    }

    @Override
    protected NodeUsage nodeOperation(NodeUsageRequest nodeUsageRequest) {
        NodesUsageRequest request = nodeUsageRequest.request;
        return this.usageService.getUsageStats(this.clusterService.localNode(), request.restActions());
    }

    public static class NodeUsageRequest
    extends BaseNodeRequest {
        NodesUsageRequest request;

        public NodeUsageRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new NodesUsageRequest(in);
        }

        NodeUsageRequest(NodesUsageRequest request) {
            this.request = request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

