/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository.mock;

import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krms.api.repository.RuleManagementService;
import org.kuali.rice.krms.api.repository.language.NaturalLanguageUsage;

public class KrmsNaturalLanguageUsageLoader {
    private RuleManagementService ruleManagementService = null;

    public RuleManagementService getRuleManagementService() {
        return this.ruleManagementService;
    }

    public void setRuleManagementService(RuleManagementService ruleManagementService) {
        this.ruleManagementService = ruleManagementService;
    }

    public void loadNlUsage(String id, String name, String nameSpace, String description) {
        NaturalLanguageUsage.Builder bldr = NaturalLanguageUsage.Builder.create((String)name, (String)nameSpace);
        bldr.setId(id);
        bldr.setActive(true);
        bldr.setDescription(description);
        NaturalLanguageUsage existing = this.findExisting(bldr);
        if (existing == null) {
            this.getRuleManagementService().createNaturalLanguageUsage(bldr.build());
        } else {
            bldr.setVersionNumber(existing.getVersionNumber());
            this.getRuleManagementService().updateNaturalLanguageUsage(bldr.build());
        }
    }

    private NaturalLanguageUsage findExisting(NaturalLanguageUsage.Builder bldr) {
        if (bldr.getId() != null) {
            try {
                return this.getRuleManagementService().getNaturalLanguageUsage(bldr.getId());
            }
            catch (RiceIllegalArgumentException ex) {
                return null;
            }
        }
        return this.getRuleManagementService().getNaturalLanguageUsageByNameAndNamespace(bldr.getName(), bldr.getNamespace());
    }

    public void load() {
        this.loadNlUsage("KS-KRMS-NL-USAGE-1000", "kuali.krms.edit", "KS-SYS", "Kuali Rule Edit");
        this.loadNlUsage("KS-KRMS-NL-USAGE-1001", "kuali.krms.composition", "KS-SYS", "Kuali Rule Composition");
        this.loadNlUsage("KS-KRMS-NL-USAGE-1002", "kuali.krms.example", "KS-SYS", "Kuali Rule Example");
        this.loadNlUsage("KS-KRMS-NL-USAGE-1003", "kuali.krms.preview", "KS-SYS", "Kuali Rule Preview");
        this.loadNlUsage("KS-KRMS-NL-USAGE-1004", "kuali.krms.type.description", "KS-SYS", "Kuali Rule Type Description");
        this.loadNlUsage("KS-KRMS-NL-USAGE-1005", "kuali.krms.catalog", "KS-SYS", "Kuali Rule Catalog");
        this.loadNlUsage("KS-KRMS-NL-USAGE-1006", "kuali.krms.type.instruction", "KS-SYS", "Kuali Rule Type Instructions");
    }
}

