/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.property.source;

import com.codiform.moo.MissingSourcePropertyException;
import com.codiform.moo.property.source.ReflectionSourcePropertyFactory;
import com.codiform.moo.property.source.SourceProperty;
import com.codiform.moo.property.source.SourcePropertyFactory;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeSourcePropertyFactory
implements SourcePropertyFactory {
    private List<SourcePropertyFactory> sourcePropertyFactories = new ArrayList<SourcePropertyFactory>();
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public CompositeSourcePropertyFactory() {
        this.sourcePropertyFactories = new ArrayList<SourcePropertyFactory>();
        this.initializeDefaults();
        this.initializeExtensions();
    }

    private void initializeDefaults() {
        this.sourcePropertyFactories.add(new ReflectionSourcePropertyFactory());
    }

    private void initializeExtensions() {
        try {
            Class<?> factory = Class.forName("com.codiform.moo.property.source.MvelSourcePropertyFactory");
            this.sourcePropertyFactories.add((SourcePropertyFactory)factory.newInstance());
        }
        catch (ClassNotFoundException factory) {
        }
        catch (InstantiationException exception) {
            this.log.warn("Instantiation exception while configuring extensions.", (Throwable)exception);
        }
        catch (IllegalAccessException exception) {
            this.log.warn("Instantiation exception while configuring extensions.", (Throwable)exception);
        }
    }

    boolean containsSourcePropertyFactory(Class<? extends SourcePropertyFactory> factoryType) {
        for (SourcePropertyFactory factory : this.sourcePropertyFactories) {
            if (!factoryType.isInstance(factory)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SourceProperty getSourceProperty(String expression) {
        String prefix = this.getPrefix(expression);
        if (prefix == null) {
            return this.getUnprefixedSourceProperty(expression);
        }
        return this.getPrefixedSourceProperty(prefix, expression);
    }

    private SourceProperty getPrefixedSourceProperty(String prefix, String expression) {
        String unprefixed = expression.substring(prefix.length() + 1);
        for (SourcePropertyFactory item : this.sourcePropertyFactories) {
            SourceProperty property;
            if (!item.supportsPrefix(prefix) || (property = item.getSourceProperty(prefix, unprefixed)) == null) continue;
            return property;
        }
        throw new MissingSourcePropertyException(expression);
    }

    private SourceProperty getUnprefixedSourceProperty(String expression) {
        for (SourcePropertyFactory item : this.sourcePropertyFactories) {
            SourceProperty property = item.getSourceProperty(expression);
            if (property == null) continue;
            return property;
        }
        throw new MissingSourcePropertyException(expression);
    }

    private String getPrefix(String expression) {
        int colonIndex = expression.indexOf(58);
        if (colonIndex > 0 && colonIndex < expression.length() - 1) {
            return expression.substring(0, colonIndex);
        }
        return null;
    }

    @Override
    public SourceProperty getSourceProperty(String expressionPrefix, String unprefixedExpression) {
        return this.getPrefixedSourceProperty(expressionPrefix, unprefixedExpression);
    }

    @Override
    public boolean supportsPrefix(String prefix) {
        for (SourcePropertyFactory item : this.sourcePropertyFactories) {
            if (!item.supportsPrefix(prefix)) continue;
            return true;
        }
        return false;
    }
}

