/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.session.ser;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.impl.session.ser.SerializableUtils;

public class SerializableSessionListener
implements HttpSessionAttributeListener {
    private static final Logger LOG = LogManager.getLogger(SerializableSessionListener.class);

    public void attributeAdded(HttpSessionBindingEvent event) {
        SerializableUtils.SerInfo info;
        if (LOG.isWarnEnabled() && !(info = SerializableUtils.getSerializationInfo(event.getValue())).isSerializable()) {
            LOG.warn("Serialization failed: Attribute added to session " + this.getMessage(event, info));
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        SerializableUtils.SerInfo info;
        if (LOG.isWarnEnabled() && !(info = SerializableUtils.getSerializationInfo(event.getValue())).isSerializable()) {
            LOG.warn("Serialization failed: Attribute replaced in session " + this.getMessage(event, info));
        }
    }

    private String getMessage(HttpSessionBindingEvent event, SerializableUtils.SerInfo info) {
        return "name: " + event.getName() + ", type: " + event.getValue().getClass().getName() + ", value: " + event.getValue().toString() + ", source: " + event.getSource().getClass().getName() + ", failure path: " + info.getFailurePath() + " is not Serializable. Location of violation:\n" + SerializableSessionListener.getStackTrace();
    }

    private static String getStackTrace() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).map(elem -> "\tat " + elem + SystemUtils.LINE_SEPARATOR).collect(Collectors.joining());
    }
}

