/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.web.format;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.core.web.format.ArrayFormatter;
import org.kuali.rice.core.web.format.BigDecimalFormatter;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.core.web.format.CurrencyFormatter;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.core.web.format.DateViewTimestampObjectFormatter;
import org.kuali.rice.core.web.format.FormatException;
import org.kuali.rice.core.web.format.IntegerFormatter;
import org.kuali.rice.core.web.format.KualiIntegerCurrencyFormatter;
import org.kuali.rice.core.web.format.LittleBooleanFormatter;
import org.kuali.rice.core.web.format.LongFormatter;
import org.kuali.rice.core.web.format.PercentageFormatter;

@Deprecated
public class Formatter
implements Serializable {
    static final String CREATE_MSG = "Couldn't create an instance of class ";
    private static Map registry = Collections.synchronizedMap(new HashMap());
    protected Map settings;
    protected Class propertyType;

    public static Formatter getFormatter(Class aType) {
        return Formatter.getFormatter(aType, null);
    }

    public static Formatter getFormatter(Class aType, Map settings) {
        Class type = Formatter.formatterForType(aType);
        Formatter formatter = null;
        try {
            formatter = (Formatter)type.newInstance();
        }
        catch (InstantiationException e) {
            throw new FormatException(CREATE_MSG + type, e);
        }
        catch (IllegalAccessException e) {
            throw new FormatException(CREATE_MSG + type, e);
        }
        if (settings != null) {
            formatter.setSettings(Collections.unmodifiableMap(settings));
        }
        formatter.propertyType = aType;
        return formatter;
    }

    public static void registerFormatter(Class type, Class formatterType) {
        registry.put(type, formatterType);
    }

    public static boolean isSupportedType(Class type) {
        if (type == null) {
            return false;
        }
        if (List.class.isAssignableFrom(type)) {
            return true;
        }
        if (Set.class.isAssignableFrom(type)) {
            return true;
        }
        return Formatter.findFormatter(type) != null;
    }

    public static Class formatterForType(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("Type can not be null");
        }
        Class formatterType = Formatter.findFormatter(type);
        return formatterType == null ? Formatter.class : formatterType;
    }

    public static Class findFormatter(Class type) {
        if (type == null) {
            return null;
        }
        if (registry.containsKey(type)) {
            return (Class)registry.get(type);
        }
        HashMap<Class, Class> formatsToRegister = new HashMap<Class, Class>();
        for (Class currType : registry.keySet()) {
            if (!currType.isAssignableFrom(type)) continue;
            Class currFormatter = (Class)registry.get(currType);
            formatsToRegister.put(type, currFormatter);
            return currFormatter;
        }
        for (Map.Entry entry : formatsToRegister.entrySet()) {
            Formatter.registerFormatter((Class)entry.getKey(), (Class)entry.getValue());
        }
        return null;
    }

    public String getImplementationClass() {
        return this.getClass().getName();
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class propertyType) {
        this.propertyType = propertyType;
    }

    public Map getSettings() {
        return this.settings;
    }

    public void setSettings(Map settings) {
        this.settings = settings;
    }

    public Object formatForPresentation(Object value) {
        if (Formatter.isNullValue(value)) {
            return this.formatNull();
        }
        return this.formatObject(value);
    }

    protected Object formatNull() {
        return null;
    }

    public Object formatObject(Object value) {
        if (value == null) {
            return this.formatNull();
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            return ArrayUtils.toString(value, type.getComponentType());
        }
        if (!Formatter.isSupportedType(value.getClass())) {
            this.formatBean(value);
        }
        return this.format(value);
    }

    protected Object formatBean(Object bean) {
        Map properties = null;
        try {
            properties = PropertyUtils.describe((Object)bean);
        }
        catch (Exception e) {
            throw new FormatException("Unable to format values for bean " + bean, e);
        }
        HashMap formattedVals = new HashMap();
        for (Map.Entry entry : properties.entrySet()) {
            Object value = entry.getValue();
            if (value == null || !Formatter.isSupportedType(value.getClass())) continue;
            Formatter formatter = Formatter.getFormatter(value.getClass());
            formattedVals.put(entry.getKey(), formatter.formatForPresentation(value));
        }
        return formattedVals;
    }

    public Object format(Object value) {
        return value;
    }

    public Object formatArray(Object value) {
        Class<?> elementType = value.getClass().getComponentType();
        if (!Formatter.isSupportedType(elementType)) {
            return value;
        }
        int length = Array.getLength(value);
        String[] formattedVals = new String[length];
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(value, i);
            Object objValue = ArrayUtils.toObject(element);
            Formatter elementFormatter = Formatter.getFormatter(elementType);
            formattedVals[i] = elementFormatter.formatForPresentation(objValue);
        }
        return formattedVals;
    }

    public Object formatCollection(Collection value) {
        ArrayList<Object> stringVals = new ArrayList<Object>();
        for (Object obj : value) {
            Formatter formatter = Formatter.getFormatter(obj.getClass());
            stringVals.add(formatter.formatForPresentation(obj));
        }
        return stringVals.toArray();
    }

    public Object convertFromPresentationFormat(Object value) {
        String[] stringArray;
        boolean isCollection;
        if (Formatter.isEmptyValue(value)) {
            return this.getNullObjectValue();
        }
        Class<?> type = value.getClass();
        boolean isArray = this.propertyType != null && this.propertyType.isArray();
        boolean bl = isCollection = this.propertyType != null && Collection.class.isAssignableFrom(this.propertyType);
        if (!isArray && !isCollection) {
            value = Formatter.unwrapString(value);
            return this.convertToObject((String)value);
        }
        if (type.isArray()) {
            stringArray = (String[])value;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = (String)value;
        }
        String[] strings = stringArray;
        return isArray ? this.convertToArray(strings) : this.convertToCollection(strings);
    }

    protected Object getNullObjectValue() {
        return null;
    }

    protected Object convertToObject(String string) {
        return string == null ? null : string.replace("\r\n", "\n").trim();
    }

    protected Collection convertToCollection(String[] strings) {
        Collection collection = null;
        Class type = this.propertyType;
        if (this.propertyType.isAssignableFrom(List.class)) {
            type = ArrayList.class;
        } else if (this.propertyType.isAssignableFrom(Set.class)) {
            type = HashSet.class;
        }
        try {
            collection = (Collection)type.newInstance();
        }
        catch (Exception e) {
            throw new FormatException(CREATE_MSG + this.propertyType, e);
        }
        for (int i = 0; i < strings.length; ++i) {
            collection.add(strings[i]);
        }
        return collection;
    }

    protected Object convertToArray(String[] strings) {
        Class<?> type = this.propertyType.getComponentType();
        Formatter formatter = Formatter.getFormatter(type);
        Object array = null;
        try {
            array = Array.newInstance(type, strings.length);
        }
        catch (Exception e) {
            throw new FormatException(CREATE_MSG + type, e);
        }
        for (int i = 0; i < strings.length; ++i) {
            Object value = formatter.convertToObject(strings[i]);
            ArrayUtils.setArrayValue(array, type, value, i);
        }
        return array;
    }

    public static String unwrapString(Object target) {
        if (target.getClass().isArray()) {
            String[] wrapper = (String[])target;
            return wrapper.length > 0 ? wrapper[0] : null;
        }
        if (target == null) {
            return new String();
        }
        return target.toString();
    }

    public static boolean isNullValue(Object obj) {
        if (obj == null) {
            return true;
        }
        return obj instanceof String && StringUtils.isEmpty((String)((String)obj));
    }

    public static boolean isEmptyValue(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String && StringUtils.isBlank((String)((String)obj))) {
            return true;
        }
        Class<?> type = obj.getClass();
        if (type.isArray()) {
            Class<?> compType = type.getComponentType();
            if (compType.isPrimitive()) {
                return false;
            }
            if (((Object[])obj).length == 0) {
                return true;
            }
            if (((Object[])obj)[0] == null) {
                return true;
            }
            if (String.class.isAssignableFrom(compType)) {
                return StringUtils.isBlank((String)((String[])obj)[0]);
            }
        }
        return false;
    }

    static {
        Formatter.registerFormatter(String.class, Formatter.class);
        Formatter.registerFormatter(String[].class, Formatter.class);
        Formatter.registerFormatter(AbstractKualiDecimal.class, BigDecimalFormatter.class);
        Formatter.registerFormatter(KualiDecimal.class, CurrencyFormatter.class);
        Formatter.registerFormatter(KualiInteger.class, KualiIntegerCurrencyFormatter.class);
        Formatter.registerFormatter(KualiPercent.class, PercentageFormatter.class);
        Formatter.registerFormatter(BigDecimal.class, BigDecimalFormatter.class);
        Formatter.registerFormatter(Date.class, DateFormatter.class);
        Formatter.registerFormatter(Integer.class, IntegerFormatter.class);
        Formatter.registerFormatter(Integer.TYPE, IntegerFormatter.class);
        Formatter.registerFormatter(int[].class, IntegerFormatter.class);
        Formatter.registerFormatter(Boolean.class, BooleanFormatter.class);
        Formatter.registerFormatter(Boolean.TYPE, BooleanFormatter.class);
        Formatter.registerFormatter(boolean[].class, BooleanFormatter.class);
        Formatter.registerFormatter(Long.class, LongFormatter.class);
        Formatter.registerFormatter(Timestamp.class, DateViewTimestampObjectFormatter.class);
        Formatter.registerFormatter(Boolean.TYPE, LittleBooleanFormatter.class);
        Formatter.registerFormatter(Collection.class, ArrayFormatter.class);
    }

    protected static final class ArrayUtils {
        private ArrayUtils() {
            throw new UnsupportedOperationException("do not call");
        }

        public static void setArrayValue(Object array, Class type, Object value, int index) {
            if (!type.isPrimitive()) {
                Array.set(array, index, value);
            } else if (type.isAssignableFrom(Boolean.TYPE)) {
                Array.setBoolean(array, index, (Boolean)value);
            } else if (type.isAssignableFrom(Character.TYPE)) {
                Array.setChar(array, index, ((Character)value).charValue());
            } else if (type.isAssignableFrom(Byte.TYPE)) {
                Array.setByte(array, index, (Byte)value);
            } else if (type.isAssignableFrom(Integer.TYPE)) {
                Array.setInt(array, index, (Integer)value);
            } else if (type.isAssignableFrom(Short.TYPE)) {
                Array.setShort(array, index, (Short)value);
            } else if (type.isAssignableFrom(Long.TYPE)) {
                Array.setLong(array, index, (Long)value);
            } else if (type.isAssignableFrom(Float.TYPE)) {
                Array.setFloat(array, index, ((Float)value).floatValue());
            } else if (type.isAssignableFrom(Double.TYPE)) {
                Array.setDouble(array, index, (Double)value);
            }
        }

        public static Object toObject(Object value) {
            if (!value.getClass().isArray()) {
                return value;
            }
            Class<?> type = value.getClass().getComponentType();
            if (Array.getLength(value) == 0) {
                return null;
            }
            if (!type.isPrimitive()) {
                return Array.get(value, 0);
            }
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return Array.getBoolean(value, 0);
            }
            if (Character.TYPE.isAssignableFrom(type)) {
                return new Character(Array.getChar(value, 0));
            }
            if (Byte.TYPE.isAssignableFrom(type)) {
                return new Byte(Array.getByte(value, 0));
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                return new Integer(Array.getInt(value, 0));
            }
            if (Long.TYPE.isAssignableFrom(type)) {
                return new Long(Array.getLong(value, 0));
            }
            if (Short.TYPE.isAssignableFrom(type)) {
                return new Short(Array.getShort(value, 0));
            }
            if (Double.TYPE.isAssignableFrom(type)) {
                return new Double(Array.getDouble(value, 0));
            }
            if (Float.TYPE.isAssignableFrom(type)) {
                return new Float(Array.getFloat(value, 0));
            }
            return null;
        }

        public static Object toString(Object array, Class type) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return Boolean.toString(((boolean[])array)[0]);
            }
            if (Character.TYPE.isAssignableFrom(type)) {
                return Character.toString(((char[])array)[0]);
            }
            if (Byte.TYPE.isAssignableFrom(type)) {
                return Byte.toString(((byte[])array)[0]);
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                return Integer.toString(((int[])array)[0]);
            }
            if (Long.TYPE.isAssignableFrom(type)) {
                return Long.toString(((long[])array)[0]);
            }
            if (Short.TYPE.isAssignableFrom(type)) {
                return Short.toString(((short[])array)[0]);
            }
            if (Double.TYPE.isAssignableFrom(type)) {
                return Double.toString(((double[])array)[0]);
            }
            if (Float.TYPE.isAssignableFrom(type)) {
                return Float.toString(((float[])array)[0]);
            }
            return ((String[])array)[0];
        }
    }
}

