/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.task.util;

import co.kuali.coeus.task.util.CommandLineArgsPropertySource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class CommandLineArgsHolder {
    private static CommandLineArgsPropertySource ARGS;

    private CommandLineArgsHolder() {
        throw new UnsupportedOperationException("do not call");
    }

    public static Optional<String> getArgValue(String argName) {
        return ARGS.containsOption(argName) ? CommandLineArgsHolder.getArgValues(argName).stream().findFirst() : Optional.empty();
    }

    public static List<String> getArgValues(String argName) {
        return ARGS.containsOption(argName) ? ARGS.getOptionValues(argName) : Collections.emptyList();
    }

    public static Optional<Integer> getIntegerArg(String argName) {
        return CommandLineArgsHolder.getIntegerArgs(argName).stream().findFirst();
    }

    public static List<Integer> getIntegerArgs(String argName) {
        return CommandLineArgsHolder.getArgValues(argName).stream().map(str -> {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Argument %s must be an integer", argName), e);
            }
        }).collect(Collectors.toList());
    }

    public static boolean isNumericArgValid(String argName) {
        if (ARGS.containsProperty(argName)) {
            try {
                CommandLineArgsHolder.getIntegerArg(argName);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean isArgPresent(String argName) {
        return ARGS.containsOption(argName);
    }

    public static String printArgsExcept(String ... omitArgs) {
        return CommandLineArgsHolder.formatArgs(omitArgs);
    }

    public static String printArgs() {
        return CommandLineArgsHolder.formatArgs(new String[0]);
    }

    private static String formatArgs(String ... omitArgs) {
        return Arrays.stream(ARGS.getPropertyNames()).filter(arg -> !ArrayUtils.contains((Object[])omitArgs, (Object)arg)).map(arg -> {
            List<String> values = CommandLineArgsHolder.getArgValues(arg);
            return String.format("%s=%s", arg, values.size() == 1 ? values.get(0) : values.toString());
        }).collect(Collectors.joining(" "));
    }

    public static CommandLineArgsPropertySource getArgs() {
        return ARGS;
    }

    public static void setArgs(CommandLineArgsPropertySource ARGS) {
        CommandLineArgsHolder.ARGS = ARGS;
    }
}

