/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.maintenance;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableAttachment;
import org.kuali.rice.krad.bo.PersistableAttachmentList;
import org.kuali.rice.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.krad.document.DocumentControllerServiceImpl;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentControllerService;
import org.kuali.rice.krad.maintenance.MaintenanceUtils;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.MaintenanceDocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.web.servlet.ModelAndView;

public class MaintenanceDocumentControllerServiceImpl
extends DocumentControllerServiceImpl
implements MaintenanceDocumentControllerService {
    private MaintenanceDocumentService maintenanceDocumentService;

    @Override
    public ModelAndView start(UifFormBase form) {
        this.setupMaintenanceDocument((MaintenanceDocumentForm)form, "New");
        return super.start(form);
    }

    @Override
    protected void loadDocument(DocumentFormBase form) throws WorkflowException {
        super.loadDocument(form);
        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)form;
        maintenanceForm.setMaintenanceAction(maintenanceForm.getDocument().getNewMaintainableObject().getMaintenanceAction());
    }

    @Override
    protected void createDocument(DocumentFormBase form) throws WorkflowException {
        this.setupMaintenanceDocument((MaintenanceDocumentForm)form, "New");
    }

    @Override
    public ModelAndView setupMaintenanceEdit(MaintenanceDocumentForm form) {
        this.setupMaintenanceDocument(form, "Edit");
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView setupMaintenanceCopy(MaintenanceDocumentForm form) {
        this.setupMaintenanceDocument(form, "Copy");
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView setupMaintenanceNewWithExisting(MaintenanceDocumentForm form) {
        this.setupMaintenanceDocument(form, "newWithExisting");
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public ModelAndView setupMaintenanceDelete(MaintenanceDocumentForm form) {
        GlobalVariables.getMessageMap().putWarning("GlobalMessages", "message.delete", new String[0]);
        this.setupMaintenanceDocument(form, "Delete");
        return this.getModelAndViewService().getModelAndView(form);
    }

    @Override
    public void setupMaintenanceDocument(MaintenanceDocumentForm form, String maintenanceAction) {
        MaintenanceDocument document = form.getDocument();
        if (document == null) {
            this.createMaintenanceDocument(form, maintenanceAction);
            document = form.getDocument();
        }
        form.setMaintenanceAction(maintenanceAction);
        this.getMaintenanceDocumentService().setupMaintenanceObject(document, maintenanceAction, form.getRequest().getParameterMap());
        if ("New".equals(maintenanceAction)) {
            MaintenanceUtils.checkForLockingDocument(document, false);
        }
        MaintenanceDocumentEntry entry = KRADServiceLocatorWeb.getDocumentDictionaryService().getMaintenanceDocumentEntry(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
        document.setDisplayTopicFieldInNotes(entry.getDisplayTopicFieldInNotes());
    }

    protected void createMaintenanceDocument(MaintenanceDocumentForm form, String maintenanceAction) {
        MaintenanceDocument document = this.getMaintenanceDocumentService().setupNewMaintenanceDocument(form.getDataObjectClassName(), form.getDocTypeName(), maintenanceAction);
        form.setDocument(document);
        form.setDocTypeName(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
    }

    @Override
    public void downloadDataObjectAttachment(MaintenanceDocumentForm form, HttpServletResponse response) {
        MaintenanceDocument document = form.getDocument();
        Object dataObject = document.getDocumentDataObject();
        if (dataObject instanceof PersistableAttachment) {
            PersistableAttachment attachment = (PersistableAttachment)dataObject;
            byte[] attachmentContent = attachment.getAttachmentContent();
            if (attachmentContent != null) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(attachmentContent);
                try {
                    KRADUtils.addAttachmentToResponse(response, inputStream, attachment.getContentType(), attachment.getFileName(), attachmentContent.length);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to retrieve attachment contents", e);
                }
            }
        } else if (dataObject instanceof PersistableAttachmentList) {
            PersistableAttachmentList attachmentList = (PersistableAttachmentList)dataObject;
            PersistableAttachmentList attachmentListBo = (PersistableAttachmentList)document.getNewMaintainableObject().getDataObject();
            PersistableAttachment attachment = (PersistableAttachment)attachmentListBo.getAttachments().get(Integer.parseInt(form.getActionParamaterValue("selectedLineIndex")));
            byte[] attachmentContent = attachment.getAttachmentContent();
            if (attachmentContent != null) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(attachmentContent);
                try {
                    KRADUtils.addAttachmentToResponse(response, inputStream, attachment.getContentType(), attachment.getFileName(), attachmentContent.length);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to retrieve attachment contents", e);
                }
            }
        }
    }

    protected MaintenanceDocumentService getMaintenanceDocumentService() {
        return this.maintenanceDocumentService;
    }

    public void setMaintenanceDocumentService(MaintenanceDocumentService maintenanceDocumentService) {
        this.maintenanceDocumentService = maintenanceDocumentService;
    }
}

