/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.notes.service.impl;

import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.kew.notes.Attachment;
import org.kuali.rice.kew.notes.service.AttachmentService;
import org.kuali.rice.kew.service.KEWServiceLocator;

public class AttachmentServiceImpl
implements AttachmentService {
    protected final Logger LOG = LogManager.getLogger(AttachmentServiceImpl.class);
    private static final String ATTACHMENT_PREPEND = "wf_att_";
    private String attachmentDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistAttachedFileAndSetAttachmentBusinessObjectValue(Attachment attachment) throws Exception {
        this.createStorageDirIfNecessary();
        String uniqueId = KEWServiceLocator.getResponsibilityIdService().getNewResponsibilityId();
        String internalFileIndicator = attachment.getFileName().replace('.', '_');
        String fileName = ATTACHMENT_PREPEND + attachment.getNote().getDocumentId() + "_" + internalFileIndicator + "_" + uniqueId;
        File file = File.createTempFile(fileName, null, new File(this.attachmentDir));
        this.LOG.info("Persisting attachment at: " + file.getAbsolutePath());
        if (!file.canWrite()) {
            throw new RuntimeException("Do not have permissions to write to attachment file at: " + file.getAbsolutePath());
        }
        FileOutputStream streamOut = null;
        FilterOutputStream bufferedStreamOut = null;
        try {
            int c;
            streamOut = new FileOutputStream(file);
            bufferedStreamOut = new BufferedOutputStream(streamOut);
            while ((c = attachment.getAttachedObject().read()) != -1) {
                ((BufferedOutputStream)bufferedStreamOut).write(c);
            }
        }
        finally {
            if (bufferedStreamOut != null) {
                bufferedStreamOut.close();
            }
            if (streamOut != null) {
                streamOut.close();
            }
        }
        attachment.setFileLoc(file.getAbsolutePath());
    }

    @Override
    public byte[] findAttachedFile(Attachment attachment) throws Exception {
        return Files.toByteArray((File)new File(attachment.getFileLoc()));
    }

    @Override
    public void deleteAttachedFile(Attachment attachment) throws Exception {
        File file = new File(attachment.getFileLoc());
        if (!file.delete()) {
            this.LOG.error("failed to delete file " + attachment.getFileLoc());
        }
    }

    private void createStorageDirIfNecessary() {
        if (this.attachmentDir == null) {
            throw new RuntimeException("Attachment Directory was not set when configuring workflow");
        }
        File attachDir = new File(this.attachmentDir);
        if (!attachDir.exists()) {
            this.LOG.warn("No attachment directory found.  Attempting to create directory " + this.attachmentDir);
            boolean directoriesCreated = attachDir.mkdirs();
            if (!directoriesCreated) {
                throw new RuntimeException("Failed to create directory for attachments at: " + attachDir.getAbsolutePath());
            }
        }
        if (!attachDir.canWrite()) {
            throw new RuntimeException("Do not have permission to write to: " + attachDir.getAbsolutePath());
        }
    }

    public String getAttachmentDir() {
        return this.attachmentDir;
    }

    public void setAttachmentDir(String attachmentDir) {
        this.attachmentDir = attachmentDir;
    }
}

