/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.impl.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.api.services.LocationApiServiceLocator;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateContract;
import org.kuali.rice.location.api.state.StateQueryResults;
import org.kuali.rice.location.api.state.StateService;
import org.kuali.rice.location.impl.state.StateBo;
import org.springframework.beans.factory.annotation.Required;

public class StateServiceImpl
implements StateService {
    private CountryService countryService;
    private DataObjectService dataObjectService;

    public State getState(String countryCode, String code) {
        if (StringUtils.isBlank((String)countryCode)) {
            throw new RiceIllegalArgumentException("countryCode is null");
        }
        if (StringUtils.isBlank((String)code)) {
            throw new RiceIllegalArgumentException("code is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("countryCode", countryCode);
        map.put("code", code);
        return StateBo.to((StateBo)((Object)this.getDataObjectService().find(StateBo.class, (Object)new CompoundKey(map))));
    }

    public List<State> findAllStatesInCountry(String countryCode) {
        if (StringUtils.isBlank((String)countryCode)) {
            throw new RiceIllegalArgumentException("countryCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("countryCode", countryCode);
        map.put("active", Boolean.TRUE);
        QueryResults stateBos = this.getDataObjectService().findMatching(StateBo.class, QueryByCriteria.Builder.andAttributes(map).build());
        if (stateBos == null) {
            return Collections.emptyList();
        }
        ArrayList<State> toReturn = new ArrayList<State>();
        for (StateBo bo : stateBos.getResults()) {
            if (bo == null || !bo.isActive()) continue;
            toReturn.add(StateBo.to(bo));
        }
        return Collections.unmodifiableList(toReturn);
    }

    public List<State> findAllStatesInCountryByAltCode(String alternateCode) {
        if (StringUtils.isBlank((String)alternateCode)) {
            throw new RiceIllegalArgumentException("alternateCode is null");
        }
        Country country = this.getCountryService().getCountryByAlternateCode(alternateCode);
        if (country == null) {
            throw new RiceIllegalStateException("The alternateCode is not a valid Alternate Postal Country Code.  alternateCode: " + alternateCode);
        }
        List<State> toReturn = this.findAllStatesInCountry(country.getCode());
        return Collections.unmodifiableList(toReturn);
    }

    public StateQueryResults findStates(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.getDataObjectService().findMatching(StateBo.class, queryByCriteria);
        StateQueryResults.Builder builder = StateQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<State.Builder> ims = new ArrayList<State.Builder>();
        for (StateBo bo : results.getResults()) {
            ims.add(State.Builder.create((StateContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    public CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = LocationApiServiceLocator.getCountryService();
        }
        return this.countryService;
    }

    public void setCountryService(CountryService countryService) {
        this.countryService = countryService;
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

