/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.utils.builder.SdkBuilder;

@SdkPublicApi
public final class AwsRequestOverrideConfiguration
extends RequestOverrideConfiguration {
    private final AwsCredentialsProvider credentialsProvider;

    private AwsRequestOverrideConfiguration(Builder builder) {
        super((RequestOverrideConfiguration.Builder)builder);
        this.credentialsProvider = builder.credentialsProvider();
    }

    public Optional<AwsCredentialsProvider> credentialsProvider() {
        return Optional.ofNullable(this.credentialsProvider);
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AwsRequestOverrideConfiguration that = (AwsRequestOverrideConfiguration)((Object)o);
        return Objects.equals(this.credentialsProvider, that.credentialsProvider);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsProvider);
        return hashCode;
    }

    private static final class BuilderImpl
    extends RequestOverrideConfiguration.BuilderImpl<Builder>
    implements Builder {
        private AwsCredentialsProvider awsCredentialsProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRequestOverrideConfiguration awsRequestOverrideConfig) {
            super((RequestOverrideConfiguration)awsRequestOverrideConfig);
            this.awsCredentialsProvider = awsRequestOverrideConfig.credentialsProvider;
        }

        @Override
        public Builder credentialsProvider(AwsCredentialsProvider credentialsProvider) {
            this.awsCredentialsProvider = credentialsProvider;
            return this;
        }

        @Override
        public AwsCredentialsProvider credentialsProvider() {
            return this.awsCredentialsProvider;
        }

        @Override
        public AwsRequestOverrideConfiguration build() {
            return new AwsRequestOverrideConfiguration(this);
        }
    }

    public static interface Builder
    extends RequestOverrideConfiguration.Builder<Builder>,
    SdkBuilder<Builder, AwsRequestOverrideConfiguration> {
        public Builder credentialsProvider(AwsCredentialsProvider var1);

        public AwsCredentialsProvider credentialsProvider();

        public AwsRequestOverrideConfiguration build();
    }
}

