/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.jdbc.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.Lifecycle;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.jndi.JndiTemplate;

public class PrimaryDataSourceFactoryBean
extends AbstractFactoryBean {
    private static final String DEFAULT_DATASOURCE_PARAM = "datasource";
    private static final String DEFAULT_SERVER_DATASOURCE_PARAM = "serverDatasource";
    private static final String DEFAULT_NONTRANSACTIONAL_DATASOURCE_PARAM = "nonTransactionalDatasource";
    private static final String DEFAULT_DATASOURCE_JNDI_PARAM = "datasource.jndi.location";
    private static final String DEFAULT_SERVER_DATASOURCE_JNDI_PARAM = "serverDatasource.jndi.location";
    private static final String DEFAULT_NONTRANSACTIONAL_DATASOURCE_JNDI_PARAM = "nonTransactional.datasource.jndi.location";
    private JndiTemplate jndiTemplate;
    private boolean nonTransactionalDataSource = false;
    private String defaultDataSourceParam = "datasource";
    private String defaultNonTransactionalDataSourceParam = "nonTransactionalDatasource";
    private String defaultDataSourceJndiParam = "datasource.jndi.location";
    private String defaultNonTransactionalDataSourceJndiParam = "nonTransactional.datasource.jndi.location";
    private List<String> preferredDataSourceParams = new ArrayList<String>();
    private List<String> preferredDataSourceJndiParams = new ArrayList<String>();
    private boolean serverDataSource = false;
    private boolean nullAllowed = false;
    private boolean forceLazy = false;

    public PrimaryDataSourceFactoryBean() {
        this.setSingleton(true);
    }

    public Class<DataSource> getObjectType() {
        return DataSource.class;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.serverDataSource) {
            this.getPreferredDataSourceParams().add(DEFAULT_SERVER_DATASOURCE_PARAM);
            this.getPreferredDataSourceJndiParams().add(DEFAULT_SERVER_DATASOURCE_JNDI_PARAM);
        }
        super.afterPropertiesSet();
    }

    protected Object createInstance() throws Exception {
        DataSource dataSource = null;
        dataSource = !this.isForceLazy() ? this.createDataSourceInstance() : (DataSource)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)new LazyInvocationHandler());
        return dataSource;
    }

    private DataSource createDataSourceInstance() throws Exception {
        Config config = ConfigContext.getCurrentContextConfig();
        DataSource dataSource = this.createDataSource(config);
        if (dataSource == null && !this.isNullAllowed()) {
            throw new ConfigurationException("Failed to configure the Primary Data Source.");
        }
        return dataSource;
    }

    protected String getDefaultDataSourceParamByType() {
        return this.nonTransactionalDataSource ? this.getDefaultNonTransactionalDataSourceParam() : this.getDefaultDataSourceParam();
    }

    protected String getDefaultDataSourceJndiParamByType() {
        return this.nonTransactionalDataSource ? this.getDefaultNonTransactionalDataSourceJndiParam() : this.getDefaultDataSourceJndiParam();
    }

    protected DataSource createDataSource(Config config) throws Exception {
        DataSource dataSource = this.loadPreferredDataSourceFromConfig(config);
        if (dataSource == null) {
            Object dataSourceObject = config.getObject(this.getDefaultDataSourceParamByType());
            if (dataSourceObject != null) {
                this.validateDataSource(this.getDefaultDataSourceParamByType(), dataSourceObject);
                dataSource = (DataSource)dataSourceObject;
            } else {
                dataSource = this.getDataSourceFromJndi(config, this.getDefaultDataSourceJndiParamByType());
            }
        }
        return dataSource;
    }

    protected DataSource loadPreferredDataSourceFromConfig(Config config) {
        Object dataSource;
        for (String dataSourceParam : this.getPreferredDataSourceParams()) {
            dataSource = config.getObject(dataSourceParam);
            if (dataSource == null) continue;
            this.validateDataSource(dataSourceParam, dataSource);
            return (DataSource)dataSource;
        }
        if (this.jndiTemplate == null) {
            this.jndiTemplate = new JndiTemplate();
        }
        for (String dataSourceJndiParam : this.getPreferredDataSourceJndiParams()) {
            dataSource = this.getDataSourceFromJndi(config, dataSourceJndiParam);
            if (dataSource == null) continue;
            return dataSource;
        }
        return null;
    }

    protected void validateDataSource(String paramName, Object dataSourceObject) {
        if (!(dataSourceObject instanceof DataSource)) {
            throw new ConfigurationException("DataSource configured for parameter '" + paramName + "' was not an instance of DataSource.  Was instead " + dataSourceObject.getClass().getName());
        }
    }

    protected DataSource getDataSourceFromJndi(Config config, String dataSourceJndiParam) {
        String jndiName = config.getProperty(dataSourceJndiParam);
        if (!StringUtils.isBlank((String)jndiName)) {
            try {
                Object dataSource = this.getJndiTemplate().lookup(jndiName, DataSource.class);
                if (dataSource != null) {
                    this.validateDataSource(dataSourceJndiParam, dataSource);
                    return (DataSource)dataSource;
                }
            }
            catch (NamingException e) {
                throw new ConfigurationException("Could not locate the DataSource at the given JNDI location: '" + jndiName + "'", (Throwable)e);
            }
        }
        return null;
    }

    protected void destroyInstance(Object instance) throws Exception {
        if (instance instanceof Lifecycle) {
            ((Lifecycle)instance).stop();
        }
    }

    protected String getStringProperty(Config config, String propertyName) {
        String data = config.getProperty(propertyName);
        if (StringUtils.isEmpty((String)data)) {
            throw new ConfigurationException("Could not locate a value for the given property '" + propertyName + "'.");
        }
        return data;
    }

    protected int getIntProperty(Config config, String propertyName) {
        String data = this.getStringProperty(config, propertyName);
        try {
            int intData = Integer.parseInt(data);
            return intData;
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("The given property '" + propertyName + "' was not a valid integer.  Value was '" + data + "'", (Throwable)e);
        }
    }

    public JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        this.jndiTemplate = jndiTemplate;
    }

    public String getDefaultDataSourceJndiParam() {
        return this.defaultDataSourceJndiParam;
    }

    public void setDefaultDataSourceJndiParam(String defaultDataSourceJndiParam) {
        this.defaultDataSourceJndiParam = defaultDataSourceJndiParam;
    }

    public String getDefaultNonTransactionalDataSourceJndiParam() {
        return this.defaultNonTransactionalDataSourceJndiParam;
    }

    public void setDefaultNonTransactionalDataSourceJndiParam(String defaultNonTransactionalDataSourceJndiParam) {
        this.defaultNonTransactionalDataSourceJndiParam = defaultNonTransactionalDataSourceJndiParam;
    }

    public String getDefaultDataSourceParam() {
        return this.defaultDataSourceParam;
    }

    public void setDefaultDataSourceParam(String defaultDataSourceParam) {
        this.defaultDataSourceParam = defaultDataSourceParam;
    }

    public String getDefaultNonTransactionalDataSourceParam() {
        return this.defaultNonTransactionalDataSourceParam;
    }

    public void setDefaultNonTransactionalDataSourceParam(String defaultNonTransactionalDataSourceParam) {
        this.defaultNonTransactionalDataSourceParam = defaultNonTransactionalDataSourceParam;
    }

    public List<String> getPreferredDataSourceJndiParams() {
        return this.preferredDataSourceJndiParams;
    }

    public void setPreferredDataSourceJndiParams(List<String> preferredDataSourceJndiParams) {
        this.preferredDataSourceJndiParams = preferredDataSourceJndiParams;
    }

    public List<String> getPreferredDataSourceParams() {
        return this.preferredDataSourceParams;
    }

    public void setPreferredDataSourceParams(List<String> preferredDataSourceParams) {
        this.preferredDataSourceParams = preferredDataSourceParams;
    }

    public void setNonTransactionalDataSource(boolean nonTransactionalDataSource) {
        this.nonTransactionalDataSource = nonTransactionalDataSource;
    }

    public boolean isServerDataSource() {
        return this.serverDataSource;
    }

    public void setServerDataSource(boolean serverDataSource) {
        this.serverDataSource = serverDataSource;
    }

    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public void setNullAllowed(boolean nullAllowed) {
        this.nullAllowed = nullAllowed;
    }

    public boolean isForceLazy() {
        return this.forceLazy;
    }

    public void setForceLazy(boolean forceLazy) {
        this.forceLazy = forceLazy;
    }

    private class LazyInvocationHandler
    implements InvocationHandler {
        private volatile DataSource dataSource = null;

        private LazyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (this.dataSource == null) {
                    this.dataSource = PrimaryDataSourceFactoryBean.this.createDataSourceInstance();
                }
                return method.invoke((Object)this.dataSource, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

