/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.service.impl;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.mail.EmailBody;
import org.kuali.rice.core.api.mail.EmailFrom;
import org.kuali.rice.core.api.mail.EmailSubject;
import org.kuali.rice.core.api.mail.EmailTo;
import org.kuali.rice.core.api.mail.Mailer;
import org.kuali.rice.kcb.bo.Message;
import org.kuali.rice.kcb.bo.MessageDelivery;
import org.kuali.rice.kcb.service.EmailService;
import org.springframework.beans.factory.annotation.Required;

public class EmailServiceImpl
implements EmailService {
    private static Logger LOG = LogManager.getLogger(EmailServiceImpl.class);
    private static final String FORMAT_TEXT_HTML = "text/html";
    private static final String FORMAT_TEXT_PLAIN = "text/plain";
    private String weburl;
    private String defaultSender = "kcb@localhost";
    private final String DETAILACTION = "DetailView.form";
    private Mailer mailer;

    public void setMailer(Mailer mailer) {
        this.mailer = mailer;
    }

    @Required
    public void setWeburl(String weburl) {
        this.weburl = weburl;
    }

    public void setDefaultSender(String defaultSender) {
        this.defaultSender = defaultSender;
    }

    @Override
    public Long sendEmail(MessageDelivery messageDelivery, String recipientEmailAddress, String emailFormat) throws Exception {
        Message message = messageDelivery.getMessage();
        String channelName = message.getChannel();
        String producer = message.getProducer();
        String sender = this.defaultSender;
        if (producer != null) {
            try {
                InternetAddress[] addresses = InternetAddress.parse((String)producer, (boolean)false);
                if (addresses.length > 0) {
                    sender = addresses[0].toString();
                }
            }
            catch (AddressException addresses) {
                // empty catch block
            }
        }
        String title = messageDelivery.getMessage().getTitle();
        String subject = (String)(channelName == null ? "" : channelName + " ") + (String)(!StringUtils.isBlank((String)title) ? " - " + title : "");
        String format = FORMAT_TEXT_PLAIN;
        String linebreak = "\n\n";
        String link = this.weburl + "/DetailView.form?messageDeliveryId=" + messageDelivery.getId();
        if (emailFormat != null && !emailFormat.equals("text")) {
            format = FORMAT_TEXT_HTML;
            link = "<a href='" + link + "'>Notification Detail</a>";
            linebreak = "<br /><br />";
        }
        LOG.debug("link: " + link);
        StringBuffer sb = new StringBuffer();
        sb.append("You have a new notification. Click the link below to review its details.");
        sb.append(linebreak);
        sb.append(linebreak);
        sb.append(link);
        String content = sb.toString();
        LOG.debug("subject: " + subject);
        LOG.debug("sender: " + sender);
        LOG.debug("recipient: " + recipientEmailAddress);
        LOG.debug("content: " + content);
        this.mailer.sendEmail(new EmailFrom(sender), new EmailTo(recipientEmailAddress), new EmailSubject(subject), new EmailBody(content), !FORMAT_TEXT_PLAIN.equals(format));
        return null;
    }
}

