/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.model;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeDocument;
import org.kuali.coeus.common.framework.custom.attr.CustomAttributeService;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.model.KcDataObject;
import org.kuali.coeus.sys.framework.model.KcDataObjectService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.LastActionService;
import org.kuali.coeus.sys.framework.workflow.SimpleBooleanSplitNodeAware;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.kra.bo.RolePersons;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObjectExtension;
import org.kuali.rice.krad.data.jpa.DisableVersioning;
import org.kuali.rice.krad.document.TransactionalDocumentBase;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.LegacyDataFramework;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@DisableVersioning
@MappedSuperclass
@AttributeOverride(name="documentNumber", column=@Column(name="DOCUMENT_NUMBER", length=14))
public abstract class KcTransactionalDocumentBase
extends TransactionalDocumentBase
implements SimpleBooleanSplitNodeAware,
KcDataObject,
PersistableBusinessObject,
PersistenceBrokerAware {
    private static final long serialVersionUID = -1879382692835231633L;
    private static final Logger LOG = LogManager.getLogger(KcTransactionalDocumentBase.class);
    @Column(name="UPDATE_USER")
    private String updateUser;
    @Column(name="UPDATE_TIMESTAMP")
    private Timestamp updateTimestamp;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="DOCUMENT_NUMBER", referencedColumnName="DOCUMENT_NUMBER")
    private List<DocumentNextvalue> documentNextvalues = new ArrayList<DocumentNextvalue>();
    @Transient
    private Map<String, CustomAttributeDocument> customAttributeDocuments;
    @Transient
    private boolean viewOnly = false;
    @Transient
    private boolean updateUserSet;
    @Transient
    private transient KcDataObjectService kcDataObjectService;
    @Transient
    private transient CustomAttributeService customAttributeService;
    @Transient
    private transient GlobalVariableService globalVariableService;
    @Transient
    private transient LastActionService lastActionService;
    @Transient
    private transient IdentityService identityService;
    @Transient
    private transient ConfigurationService configurationService;
    @Transient
    private transient ElasticsearchIndexService elasticsearchIndexService;

    public void initialize() {
    }

    @LegacyDataFramework
    public final void beforeInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.setObjectId(null);
        this.prePersist();
    }

    @PrePersist
    protected void prePersist() {
        this.getKcDataObjectService().initVersionNumberForPersist(this);
        this.getKcDataObjectService().initUpdateFieldsForPersist(this);
        this.getKcDataObjectService().initObjectIdForPersist(this);
    }

    @LegacyDataFramework
    public final void afterInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.postPersist();
    }

    @PostPersist
    protected void postPersist() {
    }

    public void postProcessSave(DocumentEvent event) {
        super.postProcessSave(event);
    }

    @LegacyDataFramework
    public final void beforeUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.preUpdate();
    }

    @PreUpdate
    protected void preUpdate() {
        this.getKcDataObjectService().initObjectIdForUpdate(this);
        this.getKcDataObjectService().initVersionNumberForUpdate(this);
        this.getKcDataObjectService().initUpdateFieldsForUpdate(this);
        super.preUpdate();
    }

    public void validateBusinessRules(DocumentEvent event) {
        try {
            super.validateBusinessRules(event);
        }
        catch (ValidationException e) {
            Object errors = "";
            for (Map.Entry entry : GlobalVariables.getMessageMap().getErrorMessages().entrySet()) {
                for (ErrorMessage msg : (List)entry.getValue()) {
                    errors = (String)errors + (String)entry.getKey() + "=" + msg.getErrorKey() + (msg.getMessageParameters() != null ? Arrays.asList(msg.getMessageParameters()) : Collections.emptyList());
                }
            }
            LOG.info(String.format("ValidationException when validating event: %s. Check log entries preceding this error for details. Errors: %s", event.getName(), errors));
            throw e;
        }
    }

    public Map<String, CustomAttributeDocument> getCustomAttributeDocuments() {
        if (this.customAttributeDocuments == null) {
            this.customAttributeDocuments = this.getCustomAttributeService().getDefaultCustomAttributeDocuments(this.getDocumentTypeCode(), this.getDocumentCustomData());
        }
        return this.customAttributeDocuments;
    }

    public abstract List<? extends DocumentCustomData> getDocumentCustomData();

    @Override
    public Timestamp getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    public String getUpdateUser() {
        return this.updateUser;
    }

    @Override
    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    @Override
    public boolean isUpdateUserSet() {
        return this.updateUserSet;
    }

    @Override
    public void setUpdateUserSet(boolean updateUserSet) {
        this.updateUserSet = updateUserSet;
    }

    public void setDocumentNextvalues(List<DocumentNextvalue> documentNextvalues) {
        this.documentNextvalues = documentNextvalues;
    }

    public List<DocumentNextvalue> getDocumentNextvalues() {
        return this.documentNextvalues;
    }

    public Integer getDocumentNextValue(String propertyName) {
        Integer propNextValue = 1;
        for (DocumentNextvalue documentNextvalue : this.documentNextvalues) {
            if (!documentNextvalue.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            propNextValue = documentNextvalue.getNextValue();
            documentNextvalue.setNextValue(propNextValue + 1);
        }
        if (propNextValue == 1) {
            DocumentNextvalue documentNextvalue = new DocumentNextvalue();
            documentNextvalue.setNextValue(propNextValue + 1);
            documentNextvalue.setPropertyName(propertyName);
            documentNextvalue.setDocumentKey(this.documentNumber);
            this.documentNextvalues.add(documentNextvalue);
        }
        this.setDocumentNextvalues(this.documentNextvalues);
        return propNextValue;
    }

    public DocumentNextvalue getDocumentNextvalueBo(String propertyName) {
        for (DocumentNextvalue documentNextvalue : this.documentNextvalues) {
            if (!documentNextvalue.getPropertyName().equalsIgnoreCase(propertyName)) continue;
            return documentNextvalue;
        }
        DocumentNextvalue documentNextvalue = new DocumentNextvalue();
        documentNextvalue.setNextValue(1);
        documentNextvalue.setPropertyName(propertyName);
        return documentNextvalue;
    }

    public void setCustomAttributeDocuments(Map<String, CustomAttributeDocument> customAttributeDocuments) {
        this.customAttributeDocuments = customAttributeDocuments;
    }

    public CustomAttributeDocument getCustomAttributeDocument(String key) {
        return this.customAttributeDocuments.get(key);
    }

    public String getCustomLockDescriptor(Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        if (StringUtils.isNotEmpty((CharSequence)activeLockRegion)) {
            return this.getDocumentBoNumber() + "-" + activeLockRegion;
        }
        return null;
    }

    public boolean useCustomLockDescriptors() {
        return true;
    }

    public abstract String getDocumentBoNumber();

    protected List<RolePersons> getAllRolePersons() {
        return new ArrayList<RolePersons>();
    }

    public abstract String getDocumentTypeCode();

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    public void setViewOnly(boolean viewOnly) {
        this.viewOnly = viewOnly;
    }

    @Override
    public boolean answerSplitNodeQuestion(String routeNodeName) {
        throw new UnsupportedOperationException("Document does not support answerSplitNodeQuestion for routeNodeName:" + routeNodeName);
    }

    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
    }

    public void toCopy() throws WorkflowException, IllegalStateException {
        super.toCopy();
        for (Note note : this.getNotes()) {
            note.setNoteIdentifier(null);
            note.setObjectId(null);
        }
    }

    public abstract boolean isProcessComplete();

    KcDataObjectService getKcDataObjectService() {
        if (this.kcDataObjectService == null) {
            this.kcDataObjectService = KcServiceLocator.getService(KcDataObjectService.class);
        }
        return this.kcDataObjectService;
    }

    void setKcDataObjectService(KcDataObjectService kcDataObjectService) {
        this.kcDataObjectService = kcDataObjectService;
    }

    CustomAttributeService getCustomAttributeService() {
        if (this.customAttributeService == null) {
            this.customAttributeService = KcServiceLocator.getService(CustomAttributeService.class);
        }
        return this.customAttributeService;
    }

    void setCustomAttributeService(CustomAttributeService customAttributeService) {
        this.customAttributeService = customAttributeService;
    }

    public PersistableBusinessObjectExtension getExtension() {
        return (PersistableBusinessObjectExtension)super.getExtension();
    }

    public void setExtension(PersistableBusinessObjectExtension extension) {
        super.setExtension((Object)extension);
    }

    public void afterDelete(PersistenceBroker arg0) throws PersistenceBrokerException {
    }

    public void afterLookup(PersistenceBroker arg0) throws PersistenceBrokerException {
        this.postLoad();
    }

    @PostUpdate
    public void postUpdate() {
    }

    public void afterUpdate(PersistenceBroker arg0) throws PersistenceBrokerException {
        this.postUpdate();
    }

    @PreRemove
    public void preRemove() {
    }

    public void beforeDelete(PersistenceBroker arg0) throws PersistenceBrokerException {
        this.preRemove();
    }

    protected <T> T executeAsLastActionUser(Callable<T> callable) {
        try {
            Principal principal;
            String lastPrincipalId = this.getLastActionService().findLastUserActionTakenPrincipalId(this.getDocumentNumber());
            if (StringUtils.isNotBlank((CharSequence)lastPrincipalId) && !lastPrincipalId.equals(this.getGlobalVariableService().getUserSession().getPrincipalId()) && (principal = this.getIdentityService().getPrincipal(lastPrincipalId)) != null && StringUtils.isNotBlank((CharSequence)principal.getPrincipalName())) {
                UserSession session = new UserSession(principal.getPrincipalName());
                session.setKualiSessionId(this.getGlobalVariableService().getUserSession().getKualiSessionId());
                return (T)GlobalVariables.doInNewGlobalVariables((UserSession)session, callable);
            }
            return callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void afterWorkflowEngineProcess(boolean success) {
        super.afterWorkflowEngineProcess(success);
        if (this.getConfigurationService().getPropertyValueAsBoolean("elasticsearch.enabled") && this.getDocumentHeader() != null && !this.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            final String documentNumber = this.getDocumentNumber();
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    KcTransactionalDocumentBase.this.getElasticsearchIndexService().index(documentNumber);
                }
            });
        }
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        String newStatus;
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getConfigurationService().getPropertyValueAsBoolean("elasticsearch.enabled") && (newStatus = statusChangeEvent.getNewRouteStatus()).equalsIgnoreCase("X")) {
            this.getElasticsearchIndexService().delete(this.getDocumentNumber());
        }
    }

    protected GlobalVariableService getGlobalVariableService() {
        if (this.globalVariableService == null) {
            this.globalVariableService = KcServiceLocator.getService(GlobalVariableService.class);
        }
        return this.globalVariableService;
    }

    protected void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    LastActionService getLastActionService() {
        if (this.lastActionService == null) {
            this.lastActionService = KcServiceLocator.getService(LastActionService.class);
        }
        return this.lastActionService;
    }

    void setLastActionService(LastActionService lastActionService) {
        this.lastActionService = lastActionService;
    }

    IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = KcServiceLocator.getService(IdentityService.class);
        }
        return this.identityService;
    }

    void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = KcServiceLocator.getService(ConfigurationService.class);
        }
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ElasticsearchIndexService getElasticsearchIndexService() {
        if (this.elasticsearchIndexService == null) {
            this.elasticsearchIndexService = KcServiceLocator.getService(ElasticsearchIndexService.class);
        }
        return this.elasticsearchIndexService;
    }

    public void setElasticsearchIndexService(ElasticsearchIndexService elasticsearchIndexService) {
        this.elasticsearchIndexService = elasticsearchIndexService;
    }

    public Map<String, String> getKrmsRoleQualifiers() {
        HashMap<String, String> qualifiers = new HashMap<String, String>();
        return qualifiers;
    }
}

