/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.resourceloader;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.config.property.SimpleConfig;
import org.kuali.rice.core.framework.resourceloader.BaseResourceLoader;

public final class GlobalResourceLoaderTestUtils {
    private static Map<String, Object> mockServiceMap;
    private volatile boolean initialized = false;

    private GlobalResourceLoaderTestUtils() {
        throw new UnsupportedOperationException("Don't construct me, I'm all about the static methods.");
    }

    public static void addMockService(String serviceName, Object mockService) {
        GlobalResourceLoaderTestUtils.getMockServiceMap().put(serviceName, mockService);
    }

    private static synchronized Map<String, Object> getMockServiceMap() {
        if (mockServiceMap == null) {
            mockServiceMap = new ConcurrentHashMap<String, Object>();
            SimpleConfig config = new SimpleConfig();
            config.putProperty("application.id", "TEST");
            ConfigContext.init((Config)config);
            try {
                GlobalResourceLoader.stop();
            }
            catch (Exception e) {
                throw new RiceRuntimeException((Throwable)e);
            }
            GlobalResourceLoader.addResourceLoaderFirst((ResourceLoader)new BaseResourceLoader(new QName("TEST", "TEST")){

                @Override
                public Object getService(QName serviceQName) {
                    String localPart = serviceQName.getLocalPart();
                    return mockServiceMap.get(localPart);
                }
            });
        }
        return mockServiceMap;
    }
}

