/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.api.state;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.location.api.state.StateContract;
import org.w3c.dom.Element;

@XmlRootElement(name="state")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="StateType", propOrder={"code", "name", "nameV3", "countryCode", "active", "versionNumber", "_futureElements"})
public final class State
extends AbstractDataTransferObject
implements StateContract {
    private static final long serialVersionUID = 6097498602725305353L;
    @XmlElement(name="code", required=true)
    private final String code;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="nameV3", required=false)
    private final String nameV3;
    @XmlElement(name="countryCode", required=true)
    private final String countryCode;
    @XmlElement(name="active", required=true)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private State() {
        this.code = null;
        this.name = null;
        this.nameV3 = null;
        this.countryCode = null;
        this.active = false;
        this.versionNumber = null;
    }

    private State(Builder builder) {
        this.code = builder.getCode();
        this.name = builder.getName();
        this.nameV3 = builder.getNameV3();
        this.countryCode = builder.getCountryCode();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameV3() {
        return this.nameV3;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/location/v2_0/StateType";
    }

    static class Elements {
        static final String CODE = "code";
        static final String NAME = "name";
        static final String NAME_V3 = "nameV3";
        static final String COUNTRY_CODE = "countryCode";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "state";
        static final String TYPE_NAME = "StateType";

        Constants() {
        }
    }

    public static class Builder
    implements StateContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 7077484401017765844L;
        private String code;
        private String name;
        private String nameV3;
        private String countryCode;
        private boolean active;
        private Long versionNumber;

        private Builder(String code, String name, String nameV3, String countryCode) {
            this.setCode(code);
            this.setName(name);
            this.setNameV3(nameV3);
            this.setCountryCode(countryCode);
        }

        public static Builder create(String code, String name, String countryCode) {
            Builder builder = new Builder(code, name, null, countryCode);
            builder.setActive(true);
            return builder;
        }

        public static Builder create(String code, String name, String nameV3, String countryCode) {
            Builder builder = new Builder(code, name, nameV3, countryCode);
            builder.setActive(true);
            return builder;
        }

        public static Builder create(StateContract contract) {
            Builder builder = new Builder(contract.getCode(), contract.getName(), contract.getNameV3(), contract.getCountryCode());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            if (StringUtils.isBlank((String)code)) {
                throw new IllegalArgumentException("code is blank");
            }
            this.code = code;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getNameV3() {
            return this.nameV3;
        }

        public void setNameV3(String nameV3) {
            this.nameV3 = nameV3;
        }

        @Override
        public String getCountryCode() {
            return this.countryCode;
        }

        public void setCountryCode(String countryCode) {
            if (StringUtils.isBlank((String)countryCode)) {
                throw new IllegalArgumentException("countryCode is blank");
            }
            this.countryCode = countryCode;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public State build() {
            return new State(this);
        }
    }
}

