/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.rolodex.NonOrganizationalRolodex;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class AwardContactsBean
implements Serializable {
    private static final long serialVersionUID = -4831783382366094280L;
    private static final String PERSON_IDENTIFIER_FIELD = "personId";
    private static final String ROLODEX_IDENTIFIER_FIELD = "rolodexId";
    protected List<? extends ContactRole> contactRoles;
    protected AwardContact newAwardContact;
    protected AwardForm awardForm;
    protected AwardDocument awardDocument;
    private transient BusinessObjectService businessObjectService;
    private transient KcPersonService kcPersonService;
    private String personId;
    private Integer rolodexId;

    public AwardContactsBean() {
    }

    public AwardContactsBean(AwardDocument awardDocument) {
        this.awardDocument = awardDocument;
        this.init();
    }

    public AwardContactsBean(AwardForm awardForm) {
        this.awardForm = awardForm;
        this.init();
    }

    protected abstract Class<? extends ContactRole> getContactRoleType();

    public String getContactRoleCode() {
        return this.newAwardContact.getContactRole() != null ? this.newAwardContact.getContactRole().getRoleCode() : null;
    }

    public AwardContact getNewAwardContact() {
        return this.newAwardContact;
    }

    public String getPersonId() {
        return this.personId;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setContactRoleCode(String contactRoleCode) {
        this.newAwardContact.setAward(this.getAward());
        this.newAwardContact.setContactRoleCode(contactRoleCode);
    }

    public void setPersonId(String personId) {
        this.personId = personId;
        KcPerson person = personId != null ? (KcPerson)this.findContact(PERSON_IDENTIFIER_FIELD, KcPerson.class, personId) : null;
        this.newAwardContact.setPerson(person);
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
        NonOrganizationalRolodex rolodex = rolodexId != null ? (NonOrganizationalRolodex)this.findContact(ROLODEX_IDENTIFIER_FIELD, NonOrganizationalRolodex.class, rolodexId) : null;
        this.newAwardContact.setRolodex(rolodex);
    }

    protected Object findContact(String identifierField, Class contactClass, Object contactIdentifier) {
        if (KcPerson.class.isAssignableFrom(contactClass)) {
            return this.getKcPersonService().getKcPersonByPersonId((String)contactIdentifier);
        }
        HashMap<String, Object> identifierMap = new HashMap<String, Object>();
        identifierMap.put(identifierField, contactIdentifier);
        return this.getBusinessObjectService().findByPrimaryKey(contactClass, identifierMap);
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    protected void init() {
        this.newAwardContact = this.createNewContact();
        this.personId = null;
        this.rolodexId = null;
    }

    protected abstract AwardContact createNewContact();

    protected Award getAward() {
        return this.getDocument().getAward();
    }

    public AwardDocument getDocument() {
        if (this.awardForm != null) {
            return this.awardForm.getAwardDocument();
        }
        return this.awardDocument;
    }

    void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }
}

