/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.common.framework.auth.perm.DocumentLevelPermissionable;
import org.kuali.coeus.common.framework.custom.DocumentCustomData;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.framework.version.history.VersionHistoryService;
import org.kuali.coeus.common.impl.krms.KcKrmsFactBuilderServiceHelper;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardComment;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krms.api.engine.Facts;

public class SubAwardDocument
extends KcTransactionalDocumentBase
implements Copyable,
SessionDocument,
KrmsRulesContext,
DocumentLevelPermissionable {
    private static final long serialVersionUID = 5454534590787613256L;
    public static final String DOCUMENT_TYPE_CODE = "SAWD";
    private static final String NAMESPACE_CODE = "namespaceCode";
    private static final String NAME = "name";
    private List<SubAward> subAwardList;
    private transient VersionHistoryService versionHistoryService;
    private transient SubAwardService subAwardService;
    private transient KcKrmsFactBuilderServiceHelper subawardFactBuilderService;

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public SubAwardDocument() {
        this.init();
    }

    public SubAward getSubAward() {
        return this.getSubAwardList().size() > 0 ? this.getSubAwardList().get(0) : new SubAward();
    }

    public void setSubAward(SubAward subAward) {
        this.subAwardList.set(0, subAward);
    }

    public void setSubAwardList(List<SubAward> subAwardList) {
        this.subAwardList = subAwardList;
    }

    public List<SubAward> getSubAwardList() {
        return this.subAwardList;
    }

    @Override
    public void afterWorkflowEngineProcess(boolean success) {
        if (CollectionUtils.isNotEmpty(this.getSubAwardList())) {
            this.getSubAwardList().get(0);
        }
        super.afterWorkflowEngineProcess(success);
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        this.executeAsLastActionUser(() -> {
            super.doRouteStatusChange(statusChangeEvent);
            String newStatus = statusChangeEvent.getNewRouteStatus();
            if ("F".equalsIgnoreCase(newStatus)) {
                this.getVersionHistoryService().updateVersionHistory(this.getSubAward(), VersionStatus.ACTIVE, GlobalVariables.getUserSession().getPrincipalName());
                this.getSubAwardService().updateSubAwardSequenceStatus(this.getSubAward(), VersionStatus.ACTIVE);
            } else if (newStatus.equalsIgnoreCase("X") || newStatus.equalsIgnoreCase("D")) {
                this.disableSubAwardComments();
                this.getVersionHistoryService().updateVersionHistory(this.getSubAward(), VersionStatus.CANCELED, GlobalVariables.getUserSession().getPrincipalName());
                this.getSubAwardService().updateSubAwardSequenceStatus(this.getSubAward(), VersionStatus.CANCELED);
            }
            for (SubAward subAward : this.subAwardList) {
                subAward.setSubAwardDocument(this);
            }
            return null;
        });
    }

    public boolean isEditable() {
        WorkflowDocument workflowDoc = this.getDocumentHeader().getWorkflowDocument();
        return workflowDoc.isInitiated() || workflowDoc.isSaved();
    }

    protected void init() {
        this.subAwardList = new ArrayList<SubAward>();
        this.subAwardList.add(new SubAward());
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = false;
        if (this.getDocumentHeader().hasWorkflowDocument() && (this.getDocumentHeader().getWorkflowDocument().isFinal() || this.getDocumentHeader().getWorkflowDocument().isProcessed() || KcServiceLocator.getService(KcWorkflowService.class).hasPendingApprovalRequests(this.getDocumentHeader().getWorkflowDocument()))) {
            isComplete = true;
        }
        return isComplete;
    }

    @Override
    public List<? extends DocumentCustomData> getDocumentCustomData() {
        return this.getSubAward().getSubAwardCustomDataList();
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        SubAward subAward = this.getSubAward();
        managedLists.add(subAward.getSubAwardFundingSourceList());
        managedLists.add(subAward.getSubAwardContactsList());
        managedLists.add(subAward.getSubAwardCloseoutList());
        managedLists.add(subAward.getSubAwardTemplateAttachments());
        managedLists.add(subAward.getSubAwardAttachments());
        managedLists.add(subAward.getSubAwardReportList());
        managedLists.add(subAward.getSubAwardFfataReporting());
        return managedLists;
    }

    @Override
    public String getDocumentBoNumber() {
        return this.getSubAward().getSubAwardCode();
    }

    @Override
    public void populateContextQualifiers(Map<String, String> qualifiers) {
        qualifiers.put(NAMESPACE_CODE, "KC-SUBAWARD");
        qualifiers.put(NAME, "KC Subaward Context");
    }

    @Override
    public void addFacts(Facts.Builder factsBuilder) {
        this.getSubawardFactBuilderService().addFacts(factsBuilder, this);
    }

    @Override
    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getLeadUnitNumber());
    }

    @Override
    public String getDocumentNumberForPermission() {
        return this.getSubAward().getDocumentNumberForPermission();
    }

    @Override
    public String getDocumentKey() {
        return this.getSubAward().getDocumentKey();
    }

    @Override
    public List<String> getRoleNames() {
        return this.getSubAward().getRoleNames();
    }

    @Override
    public String getNamespace() {
        return this.getSubAward().getNamespace();
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getSubAward().getLeadUnitNumber();
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return this.getSubAward().getDocumentRoleTypeCode();
    }

    public VersionHistoryService getVersionHistoryService() {
        if (this.versionHistoryService == null) {
            this.versionHistoryService = KcServiceLocator.getService(VersionHistoryService.class);
        }
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public SubAwardService getSubAwardService() {
        if (this.subAwardService == null) {
            this.subAwardService = KcServiceLocator.getService(SubAwardService.class);
        }
        return this.subAwardService;
    }

    public void setSubAwardService(SubAwardService subAwardService) {
        this.subAwardService = subAwardService;
    }

    public KcKrmsFactBuilderServiceHelper getSubawardFactBuilderService() {
        if (this.subawardFactBuilderService == null) {
            this.subawardFactBuilderService = (KcKrmsFactBuilderServiceHelper)KcServiceLocator.getService("subAwardFactBuilderService");
        }
        return this.subawardFactBuilderService;
    }

    public void setSubawardFactBuilderService(KcKrmsFactBuilderServiceHelper subawardFactBuilderService) {
        this.subawardFactBuilderService = subawardFactBuilderService;
    }

    @Override
    public Map<String, String> getKrmsRoleQualifiers() {
        HashMap<String, String> qualifiers = new HashMap<String, String>();
        qualifiers.put("subAward", this.getSubAward().getSubAwardId().toString());
        return qualifiers;
    }

    private void disableSubAwardComments() {
        for (SubAwardComment awardComment : this.getSubAward().getSubAwardComments()) {
            awardComment.disableComment();
        }
    }
}

