/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.security;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.kuali.rice.ksb.security.DigitalSigner;

public class SignatureSigningOutputStream
extends ServletOutputStream {
    private final boolean delayWrite;
    private final DigitalSigner signer;
    private BufferedOutputStream bufferedDataHoldingStream;
    private ByteArrayOutputStream dataHoldingStream;
    private final OutputStream wrappedOutputStream;

    public SignatureSigningOutputStream(DigitalSigner signer, OutputStream wrappedOutputStream, boolean delayWrite) {
        this.delayWrite = delayWrite;
        if (delayWrite) {
            this.dataHoldingStream = new ByteArrayOutputStream();
            this.bufferedDataHoldingStream = new BufferedOutputStream(this.dataHoldingStream);
        }
        this.wrappedOutputStream = wrappedOutputStream;
        this.signer = signer;
    }

    public void write(int data) throws IOException {
        if (this.delayWrite) {
            this.bufferedDataHoldingStream.write(data);
        } else {
            this.wrappedOutputStream.write(data);
        }
        try {
            this.signer.getSignature().update((byte)data);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error updating signature.", e);
        }
    }

    public void close() throws IOException {
        try {
            this.signer.sign();
            if (this.delayWrite) {
                byte[] data;
                this.bufferedDataHoldingStream.close();
                for (byte datum : data = this.dataHoldingStream.toByteArray()) {
                    this.wrappedOutputStream.write(datum);
                }
            }
            this.wrappedOutputStream.close();
        }
        catch (Exception e) {
            throw new IOException("Error attaching digital signature to outbound response.", e);
        }
        finally {
            super.close();
        }
    }

    public boolean isReady() {
        return true;
    }

    public void setWriteListener(WriteListener writeListener) {
        throw new UnsupportedOperationException();
    }
}

