/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.budget.AwardBudgetLineItemExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodSummaryCalculatedAmount;

public class AwardBudgetPeriodExt
extends BudgetPeriod {
    private static final long serialVersionUID = -4306012301567173292L;
    private ScaleTwoDecimal obligatedAmount;
    private ScaleTwoDecimal totalFringeAmount;
    private ScaleTwoDecimal prevTotalFringeAmount;
    private List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFringeAmounts = new ArrayList<AwardBudgetPeriodSummaryCalculatedAmount>();
    private List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFnAAmounts = new ArrayList<AwardBudgetPeriodSummaryCalculatedAmount>();
    private Map<String, ScaleTwoDecimal> fringeForCostElements = new HashMap<String, ScaleTwoDecimal>();
    private boolean rateOverrideFlag;
    private boolean fringeOverridden;
    private boolean fAndAOverridden;

    public ScaleTwoDecimal getObligatedAmount() {
        return this.obligatedAmount == null ? ScaleTwoDecimal.ZERO : this.obligatedAmount;
    }

    public void setObligatedAmount(ScaleTwoDecimal obligatedAmount) {
        this.obligatedAmount = obligatedAmount;
    }

    @Override
    public AwardBudgetLineItemExt getNewBudgetLineItem() {
        return new AwardBudgetLineItemExt();
    }

    private QueryList<AwardBudgetPeriodSummaryCalculatedAmount> filterEBRates() {
        QueryList<AwardBudgetPeriodSummaryCalculatedAmount> qlAwardBudgetPeriodSummaryCalculatedAmounts = new QueryList<AwardBudgetPeriodSummaryCalculatedAmount>(this.awardBudgetPeriodFringeAmounts);
        Equals ebClassType = new Equals("rateClassType", (Comparable)((Object)RateClassType.EMPLOYEE_BENEFITS.getRateClassType()));
        return qlAwardBudgetPeriodSummaryCalculatedAmounts.filter(ebClassType);
    }

    public Map<String, ScaleTwoDecimal> getFringeForCostElements() {
        QueryList<AwardBudgetPeriodSummaryCalculatedAmount> ebCalculatedAmounts = this.filterEBRates();
        for (AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount : ebCalculatedAmounts) {
            this.fringeForCostElements.put(awardBudgetPeriodSummaryCalculatedAmount.getCostElement(), awardBudgetPeriodSummaryCalculatedAmount.getCalculatedCost());
        }
        return this.fringeForCostElements;
    }

    public ScaleTwoDecimal getPrevTotalFringeAmount() {
        if (this.prevTotalFringeAmount == null) {
            this.prevTotalFringeAmount = this.getTotalFringeAmount();
        }
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.prevTotalFringeAmount);
    }

    public void setPrevTotalFringeAmount(ScaleTwoDecimal prevTotalFringeAmount) {
        this.prevTotalFringeAmount = prevTotalFringeAmount;
    }

    public ScaleTwoDecimal getTotalFringeAmount() {
        return this.totalFringeAmount == null ? ScaleTwoDecimal.ZERO : this.totalFringeAmount;
    }

    public void setTotalFringeAmount(ScaleTwoDecimal totalFringeAmount) {
        this.totalFringeAmount = totalFringeAmount;
    }

    public List<AwardBudgetPeriodSummaryCalculatedAmount> getAwardBudgetPeriodFringeAmounts() {
        return this.awardBudgetPeriodFringeAmounts;
    }

    public void setAwardBudgetPeriodFringeAmounts(List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFringeAmounts) {
        this.awardBudgetPeriodFringeAmounts = awardBudgetPeriodFringeAmounts;
    }

    public List<AwardBudgetPeriodSummaryCalculatedAmount> getAwardBudgetPeriodFnAAmounts() {
        return this.awardBudgetPeriodFnAAmounts;
    }

    public void setAwardBudgetPeriodFnAAmounts(List<AwardBudgetPeriodSummaryCalculatedAmount> awardBudgetPeriodFnAAmounts) {
        this.awardBudgetPeriodFnAAmounts = awardBudgetPeriodFnAAmounts;
    }

    public void setRateOverrideFlag(boolean rateOverrideFlag) {
        this.rateOverrideFlag = rateOverrideFlag;
    }

    public boolean getRateOverrideFlag() {
        return this.fringeOverridden || this.fAndAOverridden;
    }

    public boolean isRateOverrideFlag() {
        return this.fringeOverridden || this.fAndAOverridden;
    }

    public boolean isFringeOverridden() {
        return this.fringeOverridden;
    }

    public boolean setFringeOverridden(boolean fringeOverridden) {
        this.fringeOverridden = fringeOverridden;
        return this.fringeOverridden;
    }

    public boolean isfAndAOverridden() {
        return this.fAndAOverridden;
    }

    public void setfAndAOverridden(boolean fAndAOverridden) {
        this.fAndAOverridden = fAndAOverridden;
    }

    @Override
    public List<BudgetLineItem> getBudgetLineItems() {
        List<BudgetLineItem> budgetLineItems = super.getBudgetLineItems();
        this.calculateLineItemTotals(budgetLineItems);
        return budgetLineItems;
    }

    protected void calculateLineItemTotals(List<BudgetLineItem> budgetLineItems) {
        ScaleTwoDecimal runningTotal = ScaleTwoDecimal.ZERO;
        int i = 0;
        for (BudgetLineItem item : budgetLineItems) {
            AwardBudgetLineItemExt ext = (AwardBudgetLineItemExt)item;
            runningTotal = (ScaleTwoDecimal)runningTotal.add((AbstractDecimal)ext.getLineItemCost());
            runningTotal = (ScaleTwoDecimal)runningTotal.add((AbstractDecimal)ext.getObligatedAmount());
            ext.setObjectTotal(runningTotal);
            if (i + 1 < budgetLineItems.size()) {
                AwardBudgetLineItemExt nextExt = (AwardBudgetLineItemExt)budgetLineItems.get(i + 1);
                if (!StringUtils.equals((CharSequence)ext.getCostElementName(), (CharSequence)nextExt.getCostElementName())) {
                    ext.setDisplayTotalDetail(true);
                    runningTotal = ScaleTwoDecimal.ZERO;
                } else {
                    ext.setDisplayTotalDetail(false);
                }
            } else {
                ext.setDisplayTotalDetail(true);
            }
            ++i;
        }
    }
}

