/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.proposal.impl.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.framework.print.PendingReportBean;
import org.kuali.coeus.common.proposal.impl.report.CurrentAndPendingBaseStream;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.kra.institutionalproposal.customdata.InstitutionalProposalCustomData;
import org.kuali.kra.printing.schema.CurrentAndPendingSupportDocument;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="pendingProposalXmlStream")
@Scope(value="prototype")
public class PendingProposalXmlStream
extends CurrentAndPendingBaseStream {
    @Override
    public Map<String, CurrentAndPendingSupportDocument> generateXmlStream(KcPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, CurrentAndPendingSupportDocument> xmlObjectList = new LinkedHashMap<String, CurrentAndPendingSupportDocument>();
        CurrentAndPendingSupportDocument currentAndPendingSupportDocument = CurrentAndPendingSupportDocument.Factory.newInstance();
        CurrentAndPendingSupportDocument.CurrentAndPendingSupport currentAndPendingSupport = CurrentAndPendingSupportDocument.CurrentAndPendingSupport.Factory.newInstance();
        List pendingReportBeans = (List)reportParameters.get("Pending Report Beans");
        List<String> columnsList = this.getColumnList(pendingReportBeans);
        CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingReportCEColumnNames pendingReportCEColumnNames = this.getPendingSupportCustomColumnName(columnsList);
        CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport[] pendingSupports = this.getPendingSupportInformation(pendingReportBeans, columnsList);
        currentAndPendingSupport.setPersonName((String)reportParameters.get("reportPersonName"));
        currentAndPendingSupport.setPendingSupportArray(pendingSupports);
        currentAndPendingSupport.setPendingReportCEColumnNames(pendingReportCEColumnNames);
        currentAndPendingSupportDocument.setCurrentAndPendingSupport(currentAndPendingSupport);
        xmlObjectList.put("Pending Report", currentAndPendingSupportDocument);
        return xmlObjectList;
    }

    private List<String> getColumnList(List<PendingReportBean> pendingReportBeans) {
        ArrayList<String> columsList = new ArrayList<String>();
        String columnName = "";
        for (PendingReportBean bean : pendingReportBeans) {
            if (bean.getInstitutionalProposalCustomDataList() == null) continue;
            for (InstitutionalProposalCustomData institutionalProposalCustomData : bean.getInstitutionalProposalCustomDataList()) {
                if (institutionalProposalCustomData.getCustomAttribute() != null) {
                    columnName = institutionalProposalCustomData.getCustomAttribute().getLabel();
                }
                if (columsList.contains(columnName)) continue;
                columsList.add(columnName);
            }
        }
        return columsList;
    }

    private CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingReportCEColumnNames getPendingSupportCustomColumnName(List<String> columnsList) {
        CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingReportCEColumnNames pendingReportCEColumnNames = CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingReportCEColumnNames.Factory.newInstance();
        for (int columnLabelIndex = 0; columnLabelIndex < columnsList.size(); ++columnLabelIndex) {
            if (columnLabelIndex == 0) {
                pendingReportCEColumnNames.setCEColumnName1(columnsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 1) {
                pendingReportCEColumnNames.setCEColumnName2(columnsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 2) {
                pendingReportCEColumnNames.setCEColumnName3(columnsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 3) {
                pendingReportCEColumnNames.setCEColumnName4(columnsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 4) {
                pendingReportCEColumnNames.setCEColumnName5(columnsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 5) {
                pendingReportCEColumnNames.setCEColumnName6(columnsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 6) {
                pendingReportCEColumnNames.setCEColumnName7(columnsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 7) {
                pendingReportCEColumnNames.setCEColumnName8(columnsList.get(columnLabelIndex));
            }
            if (columnLabelIndex == 8) {
                pendingReportCEColumnNames.setCEColumnName9(columnsList.get(columnLabelIndex));
            }
            if (columnLabelIndex != 9) continue;
            pendingReportCEColumnNames.setCEColumnName10(columnsList.get(columnLabelIndex));
        }
        return pendingReportCEColumnNames;
    }

    private CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport[] getPendingSupportInformation(List<PendingReportBean> pendingReportBeans, List<String> columnsList) {
        ArrayList<CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport> pendingSupports = new ArrayList<CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport>();
        for (PendingReportBean bean : pendingReportBeans) {
            HashMap<String, String> customDataValueMap = new HashMap<String, String>();
            CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport pendingSupport = CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport.Factory.newInstance();
            pendingSupports.add(pendingSupport);
            if (bean.getProposalTitle() != null) {
                pendingSupport.setTitle(bean.getProposalTitle());
            }
            if (bean.getTotalDirectCostTotal() != null) {
                pendingSupport.setTotalDirectCost(bean.getTotalDirectCostTotal().bigDecimalValue());
            }
            if (bean.getTotalIndirectCostTotal() != null) {
                pendingSupport.setTotalIndirectCost(bean.getTotalIndirectCostTotal().bigDecimalValue());
            }
            if (bean.getTotalRequestedCost() != null) {
                pendingSupport.setTotalRequested(bean.getTotalRequestedCost().bigDecimalValue());
            }
            if (bean.getProposalNumber() != null) {
                pendingSupport.setProposalNumber(bean.getProposalNumber());
            }
            if (bean.getRequestedEndDateTotal() != null) {
                pendingSupport.setEndDate(this.dateTimeService.getCalendar((Date)bean.getRequestedEndDateTotal()));
            }
            if (bean.getRequestedStartDateInitial() != null) {
                pendingSupport.setEffectiveDate(this.dateTimeService.getCalendar((Date)bean.getRequestedStartDateInitial()));
            }
            if (bean.getSponsorName() != null) {
                pendingSupport.setAgency(bean.getSponsorName());
            }
            if (bean.getRoleCode() != null) {
                pendingSupport.setPI(bean.getRoleCode());
            }
            if (bean.getTotalEffort() != null) {
                pendingSupport.setPercentageEffort(bean.getTotalEffort().bigDecimalValue());
            }
            if (bean.getAcademicYearEffort() != null) {
                pendingSupport.setAcademicYearEffort(bean.getAcademicYearEffort().bigDecimalValue());
            }
            if (bean.getCalendarYearEffort() != null) {
                pendingSupport.setCalendarYearEffort(bean.getCalendarYearEffort().bigDecimalValue());
            }
            if (bean.getSummerEffort() != null) {
                pendingSupport.setSummerYearEffort(bean.getSummerEffort().bigDecimalValue());
            }
            if (bean.getInstitutionalProposalCustomDataList() == null) continue;
            ArrayList<CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport.PendingReportCEColomnValues> pendingReportCEColomnValues = new ArrayList<CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport.PendingReportCEColomnValues>();
            for (InstitutionalProposalCustomData institutionalProposalCustomData : bean.getInstitutionalProposalCustomDataList()) {
                if (institutionalProposalCustomData.getCustomAttribute() == null || institutionalProposalCustomData.getValue() == null || institutionalProposalCustomData.getCustomAttribute().getLabel() == null) continue;
                customDataValueMap.put(institutionalProposalCustomData.getCustomAttribute().getLabel(), institutionalProposalCustomData.getValue());
            }
            for (String s : columnsList) {
                CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport.PendingReportCEColomnValues pendingReportCEColomnValue = CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport.PendingReportCEColomnValues.Factory.newInstance();
                if (customDataValueMap.get(s) != null) {
                    pendingReportCEColomnValue.setPendingReportCEColumnValue((String)customDataValueMap.get(s));
                } else {
                    pendingReportCEColomnValue.setPendingReportCEColumnValue("");
                }
                pendingReportCEColomnValues.add(pendingReportCEColomnValue);
            }
            pendingSupport.setPendingReportCEColomnValuesArray(pendingReportCEColomnValues.toArray(new CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport.PendingReportCEColomnValues[0]));
        }
        return pendingSupports.toArray(new CurrentAndPendingSupportDocument.CurrentAndPendingSupport.PendingSupport[0]);
    }
}

