/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.attachment;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeType;
import org.kuali.coeus.propdev.impl.attachment.ValidNarrForms;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.s2s.S2sOppForms;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ProposalNarrativeTypeValuesFinder
extends UifKeyValuesFinderBase {
    private static final Logger LOG = LogManager.getLogger(ProposalNarrativeTypeValuesFinder.class);
    public static final String NARRATIVE_TYPE_GROUP = "narrativeTypeGroup";
    public static final String PROPOSAL_NUMBER = "proposalNumber";
    public static final String FORM_NAME = "formName";
    public static final String ALL = "ALL";
    public static final String SELECT = "select";
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;

    public List<KeyValue> getKeyValues(ViewModel model, InputField field) {
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocumentForm)model).getDevelopmentProposal();
        ArrayList<NarrativeType> allNarrativeTypes = new ArrayList<NarrativeType>(this.loadAllNarrativeTypes(developmentProposal));
        String narrativeTypeCode = "";
        try {
            NarrativeType currentNarrativeType;
            narrativeTypeCode = this.getNarrativeTypeCodeFromModelValue(model, field);
            if (StringUtils.isNotEmpty((CharSequence)narrativeTypeCode) && (currentNarrativeType = this.getNarrativeType(narrativeTypeCode)) != null && !allNarrativeTypes.contains(currentNarrativeType)) {
                allNarrativeTypes.add(currentNarrativeType);
            }
        }
        catch (Exception e) {
            throw new RiceRuntimeException("could not retrieve narrative type from the input field", (Throwable)e);
        }
        if (this.shouldAlphabetizeNarrativeTypes().booleanValue()) {
            allNarrativeTypes.sort(Comparator.comparing(NarrativeType::getDescription, Comparator.nullsFirst(Comparator.naturalOrder())));
        }
        return this.getFilteredKeyValues(allNarrativeTypes, developmentProposal, narrativeTypeCode);
    }

    protected NarrativeType getNarrativeType(String narrativeTypeCode) {
        return (NarrativeType)this.getDataObjectService().find(NarrativeType.class, (Object)narrativeTypeCode);
    }

    protected String getNarrativeTypeCodeFromModelValue(ViewModel model, InputField field) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (String)PropertyUtils.getProperty((Object)model, (String)field.getBindingInfo().getBindingPath());
    }

    protected Boolean shouldAlphabetizeNarrativeTypes() {
        return this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "alphabetizeAttachmentTypes");
    }

    public List<KeyValue> getKeyValues(ViewModel model) {
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocumentForm)model).getDevelopmentProposal();
        ArrayList<NarrativeType> allNarrativeTypes = new ArrayList<NarrativeType>(this.loadAllNarrativeTypes(developmentProposal));
        if (this.shouldAlphabetizeNarrativeTypes().booleanValue()) {
            allNarrativeTypes.sort(Comparator.comparing(NarrativeType::getDescription, Comparator.nullsFirst(Comparator.naturalOrder())));
        }
        return this.getFilteredKeyValues(allNarrativeTypes, developmentProposal, "");
    }

    public List<KeyValue> getFilteredKeyValues(Collection<NarrativeType> allNarrativeTypes, DevelopmentProposal developmentProposal, String narrativeTypeCode) {
        Collection<NarrativeType> filteredCollection = this.filterCollection(allNarrativeTypes, developmentProposal, narrativeTypeCode);
        return this.buildKeyValuesCollection(filteredCollection);
    }

    protected Collection<NarrativeType> filterCollection(Collection<NarrativeType> narrativeTypes, DevelopmentProposal developmentProposal, String narrativeTypeCode) {
        ArrayList<NarrativeType> forRemoval = new ArrayList<NarrativeType>();
        for (NarrativeType narrativeType : narrativeTypes) {
            for (Narrative narrative : developmentProposal.getNarratives()) {
                if (narrative.getNarrativeType() != null && this.filterCondition(narrative.getNarrativeType(), narrativeType) && !narrative.getNarrativeTypeCode().equals(narrativeTypeCode)) {
                    forRemoval.add(narrativeType);
                    continue;
                }
                LOG.debug("Not removing narrative type " + narrativeType.getDescription());
            }
        }
        narrativeTypes.removeAll(forRemoval);
        return narrativeTypes;
    }

    private List<KeyValue> buildKeyValuesCollection(Collection<NarrativeType> narrativeTypes) {
        ArrayList<KeyValue> KeyValues = new ArrayList<KeyValue>();
        KeyValues.add((KeyValue)new ConcreteKeyValue("", SELECT));
        for (NarrativeType narrativeType : narrativeTypes) {
            String key = narrativeType.getCode();
            String label = narrativeType.getDescription();
            KeyValues.add((KeyValue)new ConcreteKeyValue(key, label));
        }
        return KeyValues;
    }

    protected Collection<NarrativeType> loadAllNarrativeTypes(DevelopmentProposal developmentProposal) {
        ArrayList<NarrativeType> narrativeTypes = new ArrayList<NarrativeType>();
        if (this.isS2sCandidate(developmentProposal)) {
            narrativeTypes.addAll(this.populateNarrativeTypesFrom(developmentProposal));
        } else if (developmentProposal.isChild()) {
            narrativeTypes.addAll(this.populateNarrativeTypesFromParent(developmentProposal.getHierarchyParentProposalNumber()));
        }
        narrativeTypes.addAll(this.populateDefaultNarrativeForms());
        return narrativeTypes;
    }

    private Collection<NarrativeType> populateNarrativeTypesFromParent(String hierarchyProposalNumber) {
        ArrayList<NarrativeType> validS2SFormNarratives = new ArrayList<NarrativeType>();
        DevelopmentProposal parentProposal = this.getDevelopmentProposal(hierarchyProposalNumber);
        if (this.isS2sCandidate(parentProposal)) {
            validS2SFormNarratives.addAll(this.populateNarrativeTypesFrom(parentProposal));
        }
        return validS2SFormNarratives;
    }

    public DevelopmentProposal getDevelopmentProposal(String proposalNumber) {
        return (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)proposalNumber);
    }

    private boolean isS2sCandidate(DevelopmentProposal developmentProposal) {
        return !developmentProposal.getS2sOppForms().isEmpty();
    }

    private List<NarrativeType> populateNarrativeTypesFrom(DevelopmentProposal developmentProposal) {
        ArrayList<NarrativeType> validNarrativeTypes = new ArrayList<NarrativeType>();
        validNarrativeTypes.addAll(this.populateValidFormNarratives(developmentProposal));
        return validNarrativeTypes;
    }

    private List<NarrativeType> populateDefaultNarrativeForms() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(NARRATIVE_TYPE_GROUP, this.getProposalNarrativeTypeGroup());
        List validNarrativeForms = this.getDataObjectService().findAll(ValidNarrForms.class).getResults();
        List narrativeTypes = this.getDataObjectService().findMatching(NarrativeType.class, QueryByCriteria.Builder.andAttributes(queryMap).build()).getResults();
        List<NarrativeType> filteredNarrativeTypes = this.populateGenericValidNarrativeTypes();
        for (NarrativeType narrativeType : narrativeTypes) {
            if (this.validNarrFormAlreadyExists(validNarrativeForms, narrativeType)) continue;
            filteredNarrativeTypes.add(narrativeType);
        }
        return filteredNarrativeTypes;
    }

    private boolean validNarrFormAlreadyExists(List<ValidNarrForms> validNarrativeForms, NarrativeType narrativeType) {
        for (ValidNarrForms validNarrForm : validNarrativeForms) {
            if (!validNarrForm.getNarrativeTypeCode().equals(narrativeType.getCode())) continue;
            return true;
        }
        return false;
    }

    private List<NarrativeType> populateValidFormNarratives(DevelopmentProposal developmentProposal) {
        ArrayList<NarrativeType> validNarrativeTypes = new ArrayList<NarrativeType>();
        List<S2sOppForms> s2sOpportunityForms = developmentProposal.getS2sOppForms();
        for (S2sOppForms oppForms : s2sOpportunityForms) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put(FORM_NAME, oppForms.getFormName());
            List validNarrativeForms = this.getDataObjectService().findMatching(ValidNarrForms.class, QueryByCriteria.Builder.andAttributes(queryMap).build()).getResults();
            for (ValidNarrForms validNarrForms : validNarrativeForms) {
                if (!this.isProposalGroup(validNarrForms.getNarrativeType().getNarrativeTypeGroup()) || this.isNarrativeAlreadyAdded(validNarrativeTypes, validNarrForms.getNarrativeType()) || validNarrForms.getNarrativeType().isSystemGenerated()) continue;
                validNarrativeTypes.add(validNarrForms.getNarrativeType());
            }
        }
        return validNarrativeTypes;
    }

    private boolean isNarrativeAlreadyAdded(List<NarrativeType> validaNarrativeTypes, NarrativeType validNarrativeType) {
        for (NarrativeType narrativeType : validaNarrativeTypes) {
            if (!narrativeType.getCode().equals(validNarrativeType.getCode())) continue;
            return true;
        }
        return false;
    }

    private boolean isProposalGroup(String narrativeTypeCode) {
        return StringUtils.equals((CharSequence)narrativeTypeCode, (CharSequence)this.getProposalNarrativeTypeGroup());
    }

    private String getProposalNarrativeTypeGroup() {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "proposalNarrativeTypeGroup");
    }

    private List<NarrativeType> populateGenericValidNarrativeTypes() {
        ArrayList<NarrativeType> validNarrativeTypes = new ArrayList<NarrativeType>();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(FORM_NAME, ALL);
        List validNarrativeForms = this.getDataObjectService().findMatching(ValidNarrForms.class, QueryByCriteria.Builder.andAttributes(queryMap).build()).getResults();
        for (ValidNarrForms validNarrForms : validNarrativeForms) {
            if (!this.isProposalGroup(validNarrForms.getNarrativeType().getNarrativeTypeGroup())) continue;
            validNarrativeTypes.add(validNarrForms.getNarrativeType());
        }
        return validNarrativeTypes;
    }

    protected boolean filterCondition(NarrativeType documentNarrativeType, NarrativeType narrativeType) {
        return documentNarrativeType.getCode().equals(narrativeType.getCode()) && this.multiplesNotAllowed(narrativeType);
    }

    private boolean multiplesNotAllowed(NarrativeType narrativeType) {
        return !narrativeType.isAllowMultiple();
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

