/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.api.sponsor.SponsorService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.framework.custom.SaveCustomDataEvent;
import org.kuali.coeus.common.framework.ynq.YnqGroupName;
import org.kuali.coeus.common.impl.custom.CustomDataRule;
import org.kuali.coeus.propdev.api.core.SubmissionInfoService;
import org.kuali.coeus.propdev.impl.abstrct.AbstractsRule;
import org.kuali.coeus.propdev.impl.abstrct.ProposalAbstract;
import org.kuali.coeus.propdev.impl.abstrct.ProposalDevelopmentAbstractsRule;
import org.kuali.coeus.propdev.impl.attachment.AddNarrativeEvent;
import org.kuali.coeus.propdev.impl.attachment.AddNarrativeRule;
import org.kuali.coeus.propdev.impl.attachment.Narrative;
import org.kuali.coeus.propdev.impl.attachment.NarrativeUserRights;
import org.kuali.coeus.propdev.impl.attachment.NewNarrativeUserRightsRule;
import org.kuali.coeus.propdev.impl.attachment.ProposalDevelopmentNarrativeRule;
import org.kuali.coeus.propdev.impl.attachment.ProposalDevelopmentProposalAttachmentsAuditRule;
import org.kuali.coeus.propdev.impl.attachment.ReplaceNarrativeEvent;
import org.kuali.coeus.propdev.impl.attachment.ReplaceNarrativeRule;
import org.kuali.coeus.propdev.impl.attachment.SaveNarrativesEvent;
import org.kuali.coeus.propdev.impl.attachment.SaveNarrativesRule;
import org.kuali.coeus.propdev.impl.attachment.institute.AddInstituteAttachmentEvent;
import org.kuali.coeus.propdev.impl.attachment.institute.AddInstituteAttachmentRule;
import org.kuali.coeus.propdev.impl.attachment.institute.ProposalDevelopmentInstituteAttachmentRule;
import org.kuali.coeus.propdev.impl.attachment.institute.ReplaceInstituteAttachmentEvent;
import org.kuali.coeus.propdev.impl.attachment.institute.ReplaceInstituteAttachmentRule;
import org.kuali.coeus.propdev.impl.basic.ProposalDevelopmentProposalRequiredFieldsAuditRule;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetDataOverrideEvent;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetDataOverrideRule;
import org.kuali.coeus.propdev.impl.budget.editable.ProposalBudgetDataOverrideRule;
import org.kuali.coeus.propdev.impl.budget.subaward.BudgetSubAwards;
import org.kuali.coeus.propdev.impl.budget.subaward.PropDevBudgetSubAwardService;
import org.kuali.coeus.propdev.impl.copy.CopyProposalRule;
import org.kuali.coeus.propdev.impl.copy.ProposalCopyCriteria;
import org.kuali.coeus.propdev.impl.copy.ProposalDevelopmentCopyRule;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.custom.AuditProposalCustomDataEvent;
import org.kuali.coeus.propdev.impl.docperm.PermissionsRule;
import org.kuali.coeus.propdev.impl.docperm.ProposalDevelopmentPermissionsRule;
import org.kuali.coeus.propdev.impl.docperm.ProposalUserRoles;
import org.kuali.coeus.propdev.impl.editable.ProposalDataOverrideEvent;
import org.kuali.coeus.propdev.impl.editable.ProposalDataOverrideRule;
import org.kuali.coeus.propdev.impl.editable.ProposalDevelopmentDataOverrideRule;
import org.kuali.coeus.propdev.impl.hierarchy.ProposalHierarchyException;
import org.kuali.coeus.propdev.impl.keyword.PropScienceKeyword;
import org.kuali.coeus.propdev.impl.krms.ProposalDevelopmentKRMSAuditRule;
import org.kuali.coeus.propdev.impl.location.AddCongressionalDistrictRule;
import org.kuali.coeus.propdev.impl.location.AddProposalCongressionalDistrictEvent;
import org.kuali.coeus.propdev.impl.location.AddProposalSiteEvent;
import org.kuali.coeus.propdev.impl.location.AddProposalSiteRule;
import org.kuali.coeus.propdev.impl.location.DeleteCongressionalDistrictRule;
import org.kuali.coeus.propdev.impl.location.DeleteProposalCongressionalDistrictEvent;
import org.kuali.coeus.propdev.impl.location.ProposalDevelopmentCongressionalDistrictRule;
import org.kuali.coeus.propdev.impl.location.ProposalDevelopmentProposalLocationRule;
import org.kuali.coeus.propdev.impl.location.SaveProposalSitesEvent;
import org.kuali.coeus.propdev.impl.location.SaveProposalSitesRule;
import org.kuali.coeus.propdev.impl.person.AddKeyPersonRule;
import org.kuali.coeus.propdev.impl.person.ChangeKeyPersonRule;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelAuditRule;
import org.kuali.coeus.propdev.impl.person.KeyPersonnelCertificationRule;
import org.kuali.coeus.propdev.impl.person.ProposalDevelopmentKeyPersonsRule;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.person.SaveKeyPersonRule;
import org.kuali.coeus.propdev.impl.person.attachment.AddPersonnelAttachmentEvent;
import org.kuali.coeus.propdev.impl.person.attachment.AddPersonnelAttachmentRule;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalDevelopmentPersonnelAttachmentRule;
import org.kuali.coeus.propdev.impl.person.attachment.ProposalPersonBiography;
import org.kuali.coeus.propdev.impl.person.attachment.ReplacePersonnelAttachmentEvent;
import org.kuali.coeus.propdev.impl.person.attachment.ReplacePersonnelAttachmentRule;
import org.kuali.coeus.propdev.impl.person.attachment.SavePersonnelAttachmentEvent;
import org.kuali.coeus.propdev.impl.person.creditsplit.CalculateCreditSplitRule;
import org.kuali.coeus.propdev.impl.questionnaire.ProposalDevelopmentQuestionnaireAuditRule;
import org.kuali.coeus.propdev.impl.resubmit.ProposalDevelopmentResubmissionPromptRule;
import org.kuali.coeus.propdev.impl.resubmit.ResubmissionPromptRule;
import org.kuali.coeus.propdev.impl.resubmit.ResubmissionRuleEvent;
import org.kuali.coeus.propdev.impl.s2s.ProposalDevelopmentGrantsGovAuditRule;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sQuestionnaireAuditRule;
import org.kuali.coeus.propdev.impl.sponsor.AddProposalSponsorAndProgramInformationRule;
import org.kuali.coeus.propdev.impl.sponsor.AddProposalSponsorAndProgramInformationRuleImpl;
import org.kuali.coeus.propdev.impl.sponsor.ProposalDevelopmentSponsorAuditRule;
import org.kuali.coeus.propdev.impl.sponsor.ProposalDevelopmentSponsorProgramInformationAuditRule;
import org.kuali.coeus.propdev.impl.ynq.ProposalDevelopmentYnqAuditRule;
import org.kuali.coeus.propdev.impl.ynq.ProposalYnq;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBaseExtension;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.DateUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.rules.rule.event.ApproveDocumentEvent;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ProposalDevelopmentDocumentRule
extends KcTransactionalDocumentRuleBase
implements AddCongressionalDistrictRule,
AddKeyPersonRule,
AddNarrativeRule,
ReplaceNarrativeRule,
SaveNarrativesRule,
AddInstituteAttachmentRule,
ReplaceInstituteAttachmentRule,
AddPersonnelAttachmentRule,
ReplacePersonnelAttachmentRule,
AddProposalSiteRule,
KcBusinessRule,
SaveProposalSitesRule,
AbstractsRule,
CopyProposalRule,
ChangeKeyPersonRule,
DeleteCongressionalDistrictRule,
PermissionsRule,
NewNarrativeUserRightsRule,
SaveKeyPersonRule,
CalculateCreditSplitRule,
ProposalDataOverrideRule,
ResubmissionPromptRule,
BudgetDataOverrideRule,
AddProposalSponsorAndProgramInformationRule,
DocumentAuditRule {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentDocumentRule.class);
    private static final String PROPOSAL_QUESTIONS_KEY = "proposalYnq[%d].%s";
    private static final String PROPOSAL_QUESTIONS_KEY_PROPERTY_ANSWER = "answer";
    private static final String PROPOSAL_QUESTIONS_KEY_PROPERTY_REVIEW_DATE = "reviewDate";
    private static final String PROPOSAL_QUESTIONS_KEY_PROPERTY_EXPLANATION = "explanation";
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String PROPOSAL_CURRENT_AWARD_NUMBER = "currentAwardNumber";
    private SponsorService sponsorService;
    private DataDictionaryService dataDictionaryService;
    private SubmissionInfoService submissionInfoService;
    private ParameterService parameterService;
    private PropDevBudgetSubAwardService propDevBudgetSubAwardService;

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    protected SponsorService getSponsorService() {
        if (this.sponsorService == null) {
            this.sponsorService = KcServiceLocator.getService(SponsorService.class);
        }
        return this.sponsorService;
    }

    protected SubmissionInfoService getSubmissionInfoService() {
        if (this.submissionInfoService == null) {
            this.submissionInfoService = KcServiceLocator.getService(SubmissionInfoService.class);
        }
        return this.submissionInfoService;
    }

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        boolean retval = true;
        retval &= super.processCustomRouteDocumentBusinessRules(document);
        retval &= new KeyPersonnelAuditRule().processRunAuditBusinessRules(document);
        return retval &= new KeyPersonnelCertificationRule().processRouteDocument(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        if (!(document instanceof ProposalDevelopmentDocument)) {
            return false;
        }
        boolean valid = true;
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        if (!proposalDevelopmentDocument.isProposalDeleted()) {
            GlobalVariables.getMessageMap().addToErrorPath("document.developmentProposal");
            valid &= this.processProposalRequiredFieldsBusinessRule(proposalDevelopmentDocument);
            valid &= this.processProposalYNQBusinessRule(proposalDevelopmentDocument, false);
            valid &= this.processProposalGrantsGovBusinessRule(proposalDevelopmentDocument);
            valid &= this.processSponsorProgramBusinessRule(proposalDevelopmentDocument);
            valid &= this.processKeywordBusinessRule(proposalDevelopmentDocument);
            valid &= this.processCustomDataRule(proposalDevelopmentDocument);
            valid &= this.processAttachmentRules(proposalDevelopmentDocument);
            valid &= this.processCertificationRules(proposalDevelopmentDocument);
            GlobalVariables.getMessageMap().removeFromErrorPath("document.developmentProposal");
        }
        return valid;
    }

    protected boolean processCertificationRules(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        Boolean validationEnabled = this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", "ENABLE_KEY_PERSON_VALIDATION_FOR_NON_EMPLOYEE_PERSONNEL");
        if (validationEnabled.booleanValue()) {
            int personIndex = 0;
            KeyPersonnelCertificationRule certificationRule = new KeyPersonnelCertificationRule();
            for (ProposalPerson person : proposalDevelopmentDocument.getDevelopmentProposal().getProposalPersons()) {
                String errorStarter = "document.developmentProposal.proposalPersons[";
                String errorFinish = "].questionnaireHelper.answerHeaders[0].questions";
                String errorKey = "document.developmentProposal.proposalPersons[" + personIndex + "].questionnaireHelper.answerHeaders[0].questions";
                if (certificationRule.doesNonEmployeeHaveCertification(person)) {
                    GlobalVariables.getMessageMap().putWarning(errorKey, "error.nonemployee.certification.required", new String[]{person.getFullName()});
                }
                ++personIndex;
            }
        }
        return true;
    }

    protected boolean processCustomApproveDocumentBusinessRules(ApproveDocumentEvent approveEvent) {
        boolean retval = super.processCustomApproveDocumentBusinessRules(approveEvent);
        return retval &= new KeyPersonnelCertificationRule().processApproveDocument(approveEvent);
    }

    @Override
    public boolean processAddCongressionalDistrictRules(AddProposalCongressionalDistrictEvent addCongressionalDistrictEvent) {
        return new ProposalDevelopmentCongressionalDistrictRule().processAddCongressionalDistrictRules(addCongressionalDistrictEvent);
    }

    @Override
    public boolean processDeleteCongressionalDistrictRules(DeleteProposalCongressionalDistrictEvent deleteCongressionalDistrictEvent) {
        return new ProposalDevelopmentCongressionalDistrictRule().processDeleteCongressionalDistrictRules(deleteCongressionalDistrictEvent);
    }

    public boolean processProposalYNQBusinessRule(ProposalDevelopmentDocument proposalDevelopmentDocument, boolean docRouting) {
        boolean valid = true;
        for (int j = 0; j < proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs().size(); ++j) {
            String explanationRequiredFor;
            String dateRequiredFor;
            ProposalYnq proposalYnq = proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs().get(j);
            String groupName = proposalYnq.getYnq().getGroupName();
            HashMap<String, Integer> questionSerial = ProposalDevelopmentDocumentRule.getQuestionSerialNumberBasedOnGroup(proposalDevelopmentDocument);
            String ynqAnswer = proposalYnq.getAnswer();
            if (docRouting && StringUtils.isBlank((CharSequence)proposalYnq.getAnswer())) {
                LOG.info("no answer");
                valid = false;
                this.reportError(String.format(PROPOSAL_QUESTIONS_KEY, j, PROPOSAL_QUESTIONS_KEY_PROPERTY_ANSWER), "error.required.answer", questionSerial.get(proposalYnq.getQuestionId()).toString(), groupName);
            }
            if ((dateRequiredFor = proposalYnq.getYnq().getDateRequiredFor()) != null && StringUtils.isNotBlank((CharSequence)ynqAnswer) && dateRequiredFor.contains(ynqAnswer) && proposalYnq.getReviewDate() == null) {
                LOG.info("No review date");
                valid = false;
                this.reportError(String.format(PROPOSAL_QUESTIONS_KEY, j, PROPOSAL_QUESTIONS_KEY_PROPERTY_REVIEW_DATE), "error.required.for.reviewDate", questionSerial.get(proposalYnq.getQuestionId()).toString(), groupName);
            }
            if ((explanationRequiredFor = proposalYnq.getYnq().getExplanationRequiredFor()) == null || !StringUtils.isNotBlank((CharSequence)ynqAnswer) || !explanationRequiredFor.contains(ynqAnswer) || !StringUtils.isBlank((CharSequence)proposalYnq.getExplanation())) continue;
            LOG.info("No explanation date");
            valid = false;
            this.reportError(String.format(PROPOSAL_QUESTIONS_KEY, j, PROPOSAL_QUESTIONS_KEY_PROPERTY_EXPLANATION), "error.required.for.explanation", questionSerial.get(proposalYnq.getQuestionId()).toString(), groupName);
        }
        return valid;
    }

    public static HashMap<String, Integer> getQuestionSerialNumberBasedOnGroup(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        HashMap<String, Integer> ynqGroupSerial = new HashMap<String, Integer>();
        for (YnqGroupName ynqGroupName : proposalDevelopmentDocument.getDevelopmentProposal().getYnqGroupNames()) {
            Integer serialNumber = 1;
            for (ProposalYnq proposalYnq : proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs()) {
                if (!ynqGroupName.getGroupName().equalsIgnoreCase(proposalYnq.getYnq().getGroupName())) continue;
                ynqGroupSerial.put(proposalYnq.getQuestionId(), serialNumber);
                Integer n = serialNumber;
                Integer n2 = serialNumber = Integer.valueOf(serialNumber + 1);
            }
        }
        return ynqGroupSerial;
    }

    private boolean processProposalRequiredFieldsBusinessRule(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        DataDictionaryService dataDictionaryService = this.getDataDictionaryService();
        if (proposalDevelopmentDocument.getDevelopmentProposal().getRequestedStartDateInitial() != null && proposalDevelopmentDocument.getDevelopmentProposal().getRequestedEndDateInitial() != null && proposalDevelopmentDocument.getDevelopmentProposal().getRequestedStartDateInitial().after(proposalDevelopmentDocument.getDevelopmentProposal().getRequestedEndDateInitial())) {
            valid = false;
            errorMap.putError("requestedStartDateInitial", "error.start.date.after.end.date", new String[]{dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "requestedStartDateInitial"), dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "requestedEndDateInitial")});
        }
        if (StringUtils.isNotBlank((CharSequence)proposalDevelopmentDocument.getDevelopmentProposal().getCurrentAwardNumber())) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put(AWARD_NUMBER, proposalDevelopmentDocument.getDevelopmentProposal().getCurrentAwardNumber());
            if (this.getBusinessObjectService().countMatching(Award.class, criteria) < 1) {
                valid = false;
                errorMap.putError(PROPOSAL_CURRENT_AWARD_NUMBER, "error.missing", new String[]{dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, PROPOSAL_CURRENT_AWARD_NUMBER)});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)proposalDevelopmentDocument.getDevelopmentProposal().getContinuedFrom()) && this.getSubmissionInfoService().getProposalContinuedFromVersionProposalId(proposalDevelopmentDocument.getDevelopmentProposal().getContinuedFrom()) == null) {
            valid = false;
            errorMap.putError("continuedFrom", "error.missing", new String[]{dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "continuedFrom")});
        }
        return valid;
    }

    private boolean processProposalGrantsGovBusinessRule(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        boolean valid = true;
        if (proposalDevelopmentDocument.getDevelopmentProposal().hasS2sOpportunity() && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId() != null && StringUtils.equalsIgnoreCase((CharSequence)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionCode(), (CharSequence)this.getS2sRevisionTypeOther()) && (proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionOtherDescription() == null || StringUtils.equals((CharSequence)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionOtherDescription().trim(), (CharSequence)""))) {
            this.reportError("s2sOpportunity.revisionOtherDescription", "error.s2sopportunity.revisionTypeOther", new String[0]);
            valid &= false;
        }
        if (proposalDevelopmentDocument.getDevelopmentProposal().hasS2sOpportunity() && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunityId() != null && !StringUtils.equalsIgnoreCase((CharSequence)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionCode(), (CharSequence)this.getS2sRevisionTypeOther()) && proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionOtherDescription() != null && !StringUtils.equals((CharSequence)proposalDevelopmentDocument.getDevelopmentProposal().getS2sOpportunity().getRevisionOtherDescription().trim(), (CharSequence)"")) {
            this.reportError("s2sOpportunity.revisionOtherDescription", "error.s2sopportunity.revisionTypeNotOtherSpecifyNotBlank", new String[0]);
            valid &= false;
        }
        return valid;
    }

    private String getS2sRevisionTypeOther() {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2s.revisiontype.other");
    }

    @Override
    public boolean processAddKeyPersonBusinessRules(ProposalDevelopmentDocument document, ProposalPerson person) {
        return new ProposalDevelopmentKeyPersonsRule().processAddKeyPersonBusinessRules(document, person);
    }

    private boolean processSponsorProgramBusinessRule(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        boolean valid = this.isValidSponsor(proposalDevelopmentDocument.getDevelopmentProposal().getPrimeSponsorCode(), "primeSponsorCode");
        valid &= this.isValidSponsor(proposalDevelopmentDocument.getDevelopmentProposal().getSponsorCode(), "sponsorCode");
        if (proposalDevelopmentDocument.getDevelopmentProposal().getDeadlineTime() != null) {
            String deadLineTime = DateUtils.formatFrom12Or24Str(proposalDevelopmentDocument.getDevelopmentProposal().getDeadlineTime());
            if (!deadLineTime.equalsIgnoreCase("Invalid Time")) {
                proposalDevelopmentDocument.getDevelopmentProposal().setDeadlineTime(deadLineTime);
            } else {
                GlobalVariables.getMessageMap().putError("deadlineTime", "error.invalid.deadLineTime", new String[]{this.dataDictionaryService.getAttributeErrorLabel(DevelopmentProposal.class, "deadlineTime")});
                valid = false;
            }
        }
        return valid;
    }

    private boolean isValidSponsor(String sponsorCode, String propertyName) {
        String sponsorName;
        if (sponsorCode != null && (sponsorName = this.getSponsorService().getSponsorName(sponsorCode)) == null) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.existence", new String[]{this.getDataDictionaryService().getAttributeLabel(DevelopmentProposal.class, propertyName)});
            return false;
        }
        return true;
    }

    private boolean processKeywordBusinessRule(ProposalDevelopmentDocument document) {
        List<PropScienceKeyword> keywords = document.getDevelopmentProposal().getPropScienceKeywords();
        for (PropScienceKeyword keyword : keywords) {
            for (PropScienceKeyword keyword2 : keywords) {
                if (keyword == keyword2 || !StringUtils.equalsIgnoreCase((CharSequence)keyword.getScienceKeyword().getCode(), (CharSequence)keyword2.getScienceKeyword().getCode())) continue;
                GlobalVariables.getMessageMap().putError("propScienceKeyword", "error.proposalKeywords.duplicate", new String[0]);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean processAddNarrativeBusinessRules(AddNarrativeEvent addNarrativeEvent) {
        return new ProposalDevelopmentNarrativeRule().processAddNarrativeBusinessRules(addNarrativeEvent);
    }

    public boolean processRunAuditBusinessRules(Document document) {
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)document).getDevelopmentProposal();
        if (developmentProposal.isChild() && !developmentProposal.isMultiProjectChild()) {
            throw new RuntimeException(new ProposalHierarchyException("Cannot run validation on a Proposal Hierarchy Child."));
        }
        boolean retval = this.processAttachmentAuditRules((ProposalDevelopmentDocument)document);
        retval &= new CustomDataRule().processRules(new AuditProposalCustomDataEvent((KcTransactionalDocumentBase)document));
        retval &= new ProposalDevelopmentProposalRequiredFieldsAuditRule().processRunAuditBusinessRules(document);
        retval &= new ProposalDevelopmentSponsorProgramInformationAuditRule().processRunAuditBusinessRules(document);
        retval &= new KeyPersonnelAuditRule().processRunAuditBusinessRules(document);
        if (!developmentProposal.isMultiProjectChild()) {
            retval &= new KeyPersonnelCertificationRule().processRunAuditBusinessRules(document);
        }
        retval &= new ProposalDevelopmentProposalAttachmentsAuditRule().processRunAuditBusinessRules(document);
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)document;
        proposalDevelopmentDocument.getDevelopmentProposal().getYnqService().populateProposalQuestions(proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs(), proposalDevelopmentDocument.getDevelopmentProposal().getYnqGroupNames(), proposalDevelopmentDocument);
        retval &= new ProposalDevelopmentYnqAuditRule().processRunAuditBusinessRules(document);
        retval &= new ProposalDevelopmentGrantsGovAuditRule().processRunAuditBusinessRules(document);
        retval &= new ProposalDevelopmentS2sQuestionnaireAuditRule().processRunAuditBusinessRules((Document)proposalDevelopmentDocument);
        retval &= new ProposalDevelopmentQuestionnaireAuditRule().processRunAuditBusinessRules((Document)proposalDevelopmentDocument);
        retval &= this.processRunAuditBudgetVersionRule(proposalDevelopmentDocument.getDevelopmentProposal());
        retval &= new ProposalDevelopmentKRMSAuditRule().processRunAuditBusinessRules((Document)proposalDevelopmentDocument);
        return retval &= new ProposalDevelopmentSponsorAuditRule().processRunAuditBusinessRules(document);
    }

    public boolean processRunAuditBudgetVersionRule(DevelopmentProposal proposal) {
        boolean budgetVersionsExists;
        boolean retval = true;
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        ArrayList<AuditError> auditWarnings = new ArrayList<AuditError>();
        String budgetStatusCompleteCode = this.getParameterService().getParameterValueAsString(Budget.class, "budgetStatusCompleteCode");
        boolean bl = budgetVersionsExists = !proposal.getBudgets().isEmpty();
        if (!budgetVersionsExists) {
            AuditError noBudgetWarning = new AuditError("PropDev-BudgetPage", "warning.proposal.withno.budget", "PropDev-BudgetPage", new String[]{proposal.getProposalNumber()});
            auditWarnings.add(noBudgetWarning);
            retval = false;
        } else if (proposal.getFinalBudget() == null && budgetVersionsExists) {
            auditErrors.add(new AuditError("document.developmentProposal.budgets", "error.no.budgetVersion.noFinalBudget", "PropDev-BudgetPage"));
            retval = false;
        } else if (proposal.getFinalBudget() != null && !StringUtils.equals((CharSequence)budgetStatusCompleteCode, (CharSequence)proposal.getFinalBudget().getBudgetStatus())) {
            auditErrors.add(new AuditError("document.developmentProposal.budgets", "error.no.budgetVersion.completeAndFinal", "PropDev-BudgetPage"));
            retval = false;
        } else if (proposal.getFinalBudget() != null && (proposal.getFinalBudget().getStartDate().before(proposal.getRequestedStartDateInitial()) || proposal.getFinalBudget().getEndDate().after(proposal.getRequestedEndDateInitial()) || proposal.getFinalBudget().getSummaryPeriodStartDate().before(proposal.getRequestedStartDateInitial()) || proposal.getFinalBudget().getSummaryPeriodEndDate().after(proposal.getRequestedEndDateInitial()))) {
            auditErrors.add(new AuditError("document.developmentProposal.budgets", "error.budget.dates.not.match.proposal.dates", "PropDev-BudgetPage"));
            retval = false;
        }
        if (proposal.getFinalBudget() != null) {
            ProposalDevelopmentBudgetExt proposalDevelopmentBudgetExt = proposal.getFinalBudget();
            List budgetSubAwards = proposalDevelopmentBudgetExt.getBudgetSubAwards().stream().filter(budgetSubAward -> budgetSubAward.getSubAwardXfdFileData() != null).collect(Collectors.toList());
            for (BudgetSubAwards budgetSubAward2 : budgetSubAwards) {
                if (this.getPropDevBudgetSubAwardService().validateSubAwardFileVersion(proposalDevelopmentBudgetExt, budgetSubAward2.getSubAwardXfdFileData())) continue;
                auditWarnings.add(new AuditError("document.developmentProposal.budgets", "subAwardFile.s2sVersionMismatch", "PropDev-BudgetPage", new String[]{budgetSubAward2.getSubAwardXfdFileName()}));
            }
        }
        if (auditErrors.size() > 0) {
            GlobalVariables.getAuditErrorMap().put("budgetVersionErrors", new AuditCluster("Budget", auditErrors, "Error"));
        }
        if (auditWarnings.size() > 0) {
            GlobalVariables.getAuditErrorMap().put("budgetVersionWarnings", new AuditCluster("Budget", auditWarnings, "Warnings"));
        }
        return retval;
    }

    public boolean processAttachmentRules(ProposalDevelopmentDocument document) {
        boolean retVal = true;
        int index = 0;
        for (Narrative narrative : document.getDevelopmentProposal().getNarratives()) {
            retVal &= this.processSaveNarrativesBusinessRules(new SaveNarrativesEvent("document.developmentProposal.narratives[" + index + "]", document, narrative, document.getDevelopmentProposal().getNarratives()));
            ++index;
        }
        return retVal;
    }

    public boolean processAttachmentAuditRules(ProposalDevelopmentDocument document) {
        boolean retVal = true;
        int index = 0;
        for (ProposalPersonBiography biography : document.getDevelopmentProposal().getPropPersonBios()) {
            retVal &= this.processSavePersonnelAttachmentBusinessRules(new SavePersonnelAttachmentEvent(String.valueOf(index), document, biography));
            ++index;
        }
        return retVal;
    }

    @Override
    public boolean processAddAbstractBusinessRules(ProposalDevelopmentDocument document, ProposalAbstract proposalAbstract) {
        return new ProposalDevelopmentAbstractsRule().processAddAbstractBusinessRules(document, proposalAbstract);
    }

    @Override
    public boolean processSaveNarrativesBusinessRules(SaveNarrativesEvent saveNarrativesEvent) {
        return new ProposalDevelopmentNarrativeRule().processSaveNarrativesBusinessRules(saveNarrativesEvent);
    }

    @Override
    public boolean processReplaceNarrativeBusinessRules(ReplaceNarrativeEvent replaceNarrativeEvent) {
        return new ProposalDevelopmentNarrativeRule().processReplaceNarrativeBusinessRules(replaceNarrativeEvent);
    }

    @Override
    public boolean processCopyProposalBusinessRules(ProposalDevelopmentDocument document, ProposalCopyCriteria criteria) {
        return new ProposalDevelopmentCopyRule().processCopyProposalBusinessRules(document, criteria);
    }

    @Override
    public boolean processAddInstituteAttachmentBusinessRules(AddInstituteAttachmentEvent addInstituteAttachmentEvent) {
        return new ProposalDevelopmentInstituteAttachmentRule().processAddInstituteAttachmentBusinessRules(addInstituteAttachmentEvent);
    }

    @Override
    public boolean processReplaceInstituteAttachmentBusinessRules(ReplaceInstituteAttachmentEvent event) {
        return new ProposalDevelopmentInstituteAttachmentRule().processReplaceInstituteAttachmentBusinessRules(event);
    }

    @Override
    public boolean processAddPersonnelAttachmentBusinessRules(AddPersonnelAttachmentEvent addPersonnelAttachmentEvent) {
        return new ProposalDevelopmentPersonnelAttachmentRule().processAddPersonnelAttachmentBusinessRules(addPersonnelAttachmentEvent);
    }

    public boolean processSavePersonnelAttachmentBusinessRules(SavePersonnelAttachmentEvent savePersonnelAttachmentEvent) {
        return new ProposalDevelopmentPersonnelAttachmentRule().processSavePersonnelAttachmentBusinessRules(savePersonnelAttachmentEvent);
    }

    @Override
    public boolean processReplacePersonnelAttachmentBusinessRules(ReplacePersonnelAttachmentEvent event) {
        return new ProposalDevelopmentPersonnelAttachmentRule().processReplacePersonnelAttachmentBusinessRules(event);
    }

    @Override
    public boolean processChangeKeyPersonBusinessRules(ProposalPerson proposalPerson, BusinessObject source, int index) {
        return new ProposalDevelopmentKeyPersonsRule().processChangeKeyPersonBusinessRules(proposalPerson, source, index);
    }

    @Override
    public boolean processAddProposalSiteBusinessRules(AddProposalSiteEvent addProposalLocationEvent) {
        return new ProposalDevelopmentProposalLocationRule().processAddProposalSiteBusinessRules(addProposalLocationEvent);
    }

    @Override
    public boolean processSaveProposalSiteBusinessRules(SaveProposalSitesEvent saveProposalSitesEvent) {
        return new ProposalDevelopmentProposalLocationRule().processSaveProposalSiteBusinessRules(saveProposalSitesEvent);
    }

    @Override
    public boolean processAddProposalUserBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> list, ProposalUserRoles proposalUser) {
        return new ProposalDevelopmentPermissionsRule().processAddProposalUserBusinessRules(document, list, proposalUser);
    }

    @Override
    public boolean processDeleteProposalUserBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> list, int index) {
        return new ProposalDevelopmentPermissionsRule().processDeleteProposalUserBusinessRules(document, list, index);
    }

    @Override
    public boolean processEditProposalUserRolesBusinessRules(ProposalDevelopmentDocument document, List<ProposalUserRoles> list, ProposalUserRoles editRoles) {
        return new ProposalDevelopmentPermissionsRule().processEditProposalUserRolesBusinessRules(document, list, editRoles);
    }

    @Override
    public boolean processSaveKeyPersonBusinessRules(ProposalDevelopmentDocument document) {
        LOG.info("In processSaveKeyPersonBusinessRules()");
        return new ProposalDevelopmentKeyPersonsRule().processCustomSaveDocumentBusinessRules((Document)document);
    }

    @Override
    public boolean processNewNarrativeUserRightsBusinessRules(ProposalDevelopmentDocument document, List<NarrativeUserRights> newNarrativeUserRights, int narrativeIndex) {
        return new ProposalDevelopmentNarrativeRule().processNewNarrativeUserRightsBusinessRules(document, newNarrativeUserRights, narrativeIndex);
    }

    @Override
    public boolean processCalculateCreditSplitBusinessRules(ProposalDevelopmentDocument document) {
        return new ProposalDevelopmentKeyPersonsRule().processCalculateCreditSplitBusinessRules(document);
    }

    @Override
    public boolean processProposalDataOverrideRules(ProposalDataOverrideEvent proposalDataOverrideEvent) {
        return new ProposalDevelopmentDataOverrideRule().processProposalDataOverrideRules(proposalDataOverrideEvent);
    }

    @Override
    public boolean processBudgetDataOverrideRules(BudgetDataOverrideEvent budgetDataOverrideEvent) {
        return new ProposalBudgetDataOverrideRule().processBudgetDataOverrideRules(budgetDataOverrideEvent);
    }

    @Override
    public boolean processResubmissionPromptBusinessRules(ResubmissionRuleEvent resubmissionRuleEvent) {
        return new ProposalDevelopmentResubmissionPromptRule().processResubmissionPromptBusinessRules(resubmissionRuleEvent);
    }

    public boolean processCustomDataRule(ProposalDevelopmentDocument document) {
        return new CustomDataRule().processRules(new SaveCustomDataEvent(document));
    }

    public boolean processRules(KcDocumentEventBaseExtension event) {
        return event.getRule().processRules(event);
    }

    public ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Override
    public boolean processAddProposalSponsorAndProgramInformationRules(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return new AddProposalSponsorAndProgramInformationRuleImpl().processAddProposalSponsorAndProgramInformationRules(proposalDevelopmentDocument);
    }

    public PropDevBudgetSubAwardService getPropDevBudgetSubAwardService() {
        if (this.propDevBudgetSubAwardService == null) {
            this.propDevBudgetSubAwardService = KcServiceLocator.getService(PropDevBudgetSubAwardService.class);
        }
        return this.propDevBudgetSubAwardService;
    }
}

