/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.ValidClassReportFrequency;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public class FrequencyCodeValuesFinder
extends UifKeyValuesFinderBase {
    private static final Comparator<KeyValue> COMPARATOR = new FrequenceComparator();
    private String reportClassCode;
    private String reportCode;
    private KeyValuesService keyValuesService;

    public FrequencyCodeValuesFinder() {
    }

    public FrequencyCodeValuesFinder(String reportClassCode, String reportCode) {
        this.reportClassCode = reportClassCode;
        this.reportCode = reportCode;
    }

    public List<KeyValue> getKeyValues() {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        keyValues.add(ValuesFinderUtils.getSelectOption());
        if (this.getReportClassCode() != null && this.getReportCode() != null) {
            keyValues.addAll(this.getKeyValues(this.getValidFrequencyCodes()));
        }
        return keyValues;
    }

    protected List<String> getValidFrequencyCodes() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("reportClassCode", this.getReportClassCode());
        criteria.put("reportCode", this.getReportCode());
        return this.getKeyValuesService().findMatching(ValidClassReportFrequency.class, criteria).stream().map(ValidClassReportFrequency::getFrequencyCode).collect(Collectors.toList());
    }

    protected List<KeyValue> getKeyValues(List<String> validFrequencyCodes) {
        return CollectionUtils.isEmpty(validFrequencyCodes) ? Collections.emptyList() : this.getKeyValuesService().findMatching(Frequency.class, Collections.singletonMap("frequencyCode", validFrequencyCodes)).stream().map(frequency -> new ConcreteKeyValue(frequency.getFrequencyCode(), frequency.getDescription())).sorted(COMPARATOR).collect(Collectors.toList());
    }

    public String getReportClassCode() {
        return this.reportClassCode;
    }

    public void setReportClassCode(String reportClassCode) {
        this.reportClassCode = reportClassCode;
    }

    public String getReportCode() {
        return this.reportCode;
    }

    public void setReportCode(String reportCode) {
        this.reportCode = reportCode;
    }

    protected KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = KcServiceLocator.getService(KeyValuesService.class);
        }
        return this.keyValuesService;
    }

    static class FrequenceComparator
    implements Comparator<KeyValue> {
        FrequenceComparator() {
        }

        @Override
        public int compare(KeyValue kv1, KeyValue kv2) {
            try {
                String desc1 = kv1.getValue();
                String desc2 = kv2.getValue();
                if (desc1 == null) {
                    desc1 = "";
                }
                if (desc2 == null) {
                    desc2 = "";
                }
                return desc1.compareTo(desc2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

