/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.lookup;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.sys.framework.util.CollectionUtils;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.lookup.SubAwardDocumentStatusConstants;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.UrlFactory;

public class SubAwardLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final String REQUISITIONER_USER_NAME = "requisitionerUserName";
    public static final String VIEW_DOCUMENT = "viewDocument";
    public static final String DOC_OPENED_FROM_AWARD_SEARCH = "docOpenedFromAwardSearch";
    public static final String DOC_ID = "docId";
    public static final String PLACE_HOLDER_AWARD_ID = "placeHolderAwardId";
    public static final String START_DATE = "startDate";
    public static final String END_DATE = "endDate";
    public static final String CLOSEOUT_DATE = "closeoutDate";
    public static final String SUB_AWARD_HOME_DO = "subAwardHome.do";
    public static final String SUB_AWARD_DOCUMENT = "SubAwardDocument";
    public static final String SUB_AWARD_ID = "SubAwardId";
    public static final String MEDUSA = "medusa";
    public static final String REGEX_PATTERN = "(?i)%s";
    private static final String SUB_AWARD_DOCUMENT_STATUS = "subAwardSequenceStatus";

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        super.setBackLocationDocFormKey(fieldValues);
        String requisitionerUserName = fieldValues.get(REQUISITIONER_USER_NAME);
        fieldValues.remove(REQUISITIONER_USER_NAME);
        if (StringUtils.equals((CharSequence)fieldValues.get(SUB_AWARD_DOCUMENT_STATUS), (CharSequence)SubAwardDocumentStatusConstants.Active.getCode())) {
            fieldValues.put(SUB_AWARD_DOCUMENT_STATUS, VersionStatus.ACTIVE.name());
        } else if (StringUtils.equals((CharSequence)fieldValues.get(SUB_AWARD_DOCUMENT_STATUS), (CharSequence)SubAwardDocumentStatusConstants.Pending.getCode())) {
            fieldValues.put(SUB_AWARD_DOCUMENT_STATUS, VersionStatus.PENDING.name());
        } else {
            fieldValues.put(SUB_AWARD_DOCUMENT_STATUS, String.format("%s|%s", VersionStatus.ACTIVE.name(), VersionStatus.PENDING.name()));
        }
        return this.filterForLatestVersionNumber(this.filterForRequisitionerUserName(super.getSearchResultsUnbounded(fieldValues), requisitionerUserName));
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List<HtmlData> htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        htmlDataList.add((HtmlData)this.getOpenLink((SubAward)businessObject, false));
        htmlDataList.add((HtmlData)this.getMedusaLink((SubAward)businessObject, (Boolean)false));
        return htmlDataList;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(SubAward subAward, Boolean viewOnly) {
        SubAwardDocument subAwardDocument = subAward.getSubAwardDocument();
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("open");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put(VIEW_DOCUMENT, viewOnly.toString());
        parameters.put(DOC_OPENED_FROM_AWARD_SEARCH, "true");
        parameters.put(DOC_ID, subAwardDocument.getDocumentNumber());
        parameters.put(PLACE_HOLDER_AWARD_ID, subAward.getSubAwardId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getMedusaLink(SubAward subAward, Boolean readOnly) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(MEDUSA);
        Properties parameters = new Properties();
        parameters.put("methodToCall", MEDUSA);
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put(VIEW_DOCUMENT, readOnly.toString());
        parameters.put(DOC_ID, subAward.getSubAwardDocument().getDocumentNumber());
        parameters.put(DOC_OPENED_FROM_AWARD_SEARCH, "true");
        parameters.put(PLACE_HOLDER_AWARD_ID, subAward.getSubAwardId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName().equals(START_DATE) || field.getPropertyName().equals(END_DATE) || field.getPropertyName().equals(CLOSEOUT_DATE)) {
                    field.setDatePicker(true);
                }
                if (!field.getPropertyName().equals(REQUISITIONER_USER_NAME)) continue;
                field.setFieldConversions("principalName:requisitionerUserName,principalId:requisitionerId");
            }
        }
        return rows;
    }

    @Override
    protected void addEditHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
    }

    protected List<SubAward> filterForLatestVersionNumber(List<SubAward> subAwards) {
        List<SubAward> filteredSubAwards = CollectionUtils.createCorrectImplementationForCollection(subAwards);
        TreeMap<String, SubAward> latestVersionSubAwards = new TreeMap<String, SubAward>();
        for (SubAward subAward : subAwards) {
            SubAward latestVersion = (SubAward)latestVersionSubAwards.get(subAward.getSubAwardCode());
            if (latestVersion != null && latestVersion.getSequenceNumber() >= subAward.getSequenceNumber()) continue;
            latestVersionSubAwards.put(subAward.getSubAwardCode(), subAward);
        }
        filteredSubAwards.addAll(latestVersionSubAwards.values());
        return filteredSubAwards;
    }

    protected List<SubAward> filterForRequisitionerUserName(List<SubAward> subAwards, String requisitionerUserName) {
        List<SubAward> filteredSubAwards = CollectionUtils.createCorrectImplementationForCollection(subAwards);
        if (requisitionerUserName != null && !requisitionerUserName.equalsIgnoreCase("")) {
            filteredSubAwards.addAll(subAwards.stream().filter(subAward -> subAward.getRequisitionerUserName().matches(this.createSearchRegexFromString(requisitionerUserName))).collect(Collectors.toList()));
        } else {
            filteredSubAwards.addAll(subAwards);
        }
        return filteredSubAwards;
    }

    protected String createSearchRegexFromString(String string) {
        return String.format(REGEX_PATTERN, string.replaceAll("\\*", ".*").replaceAll("%", ".*").replaceAll("\\?", "."));
    }

    @Override
    protected String getHtmlAction() {
        return SUB_AWARD_HOME_DO;
    }

    @Override
    protected String getDocumentTypeName() {
        return SUB_AWARD_DOCUMENT;
    }

    @Override
    protected String getKeyFieldName() {
        return SUB_AWARD_ID;
    }
}

