/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.service;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.validation.ErrorHandlingUtilService;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncLog;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncStatus;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncUtilityService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardSyncUtilityServiceImpl
implements AwardSyncUtilityService {
    private WorkflowDocumentActionsService workflowUtility;
    private ConfigurationService kualiConfigurationService;
    private ErrorHandlingUtilService errorHandlingUtilService;

    @Override
    public List<AwardSyncLog> getLogsFromSaveErrors(AwardSyncStatus awardStatus) {
        ArrayList<AwardSyncLog> result = new ArrayList<AwardSyncLog>();
        Map errors = GlobalVariables.getMessageMap().getErrorMessages();
        for (Map.Entry entry : errors.entrySet()) {
            for (ErrorMessage curMessage : (List)entry.getValue()) {
                awardStatus.addValidationLog(this.expandErrorString(curMessage.getErrorKey(), curMessage.getMessageParameters()), false, curMessage.getErrorKey());
            }
        }
        errors.clear();
        return result;
    }

    @Override
    public List<AwardSyncLog> getLogsFromAuditErrors(AwardSyncStatus awardStatus) {
        ArrayList<AwardSyncLog> result = new ArrayList<AwardSyncLog>();
        for (Object object : GlobalVariables.getAuditErrorMap().values()) {
            AuditCluster cluster = (AuditCluster)object;
            boolean logSuccess = StringUtils.equals((CharSequence)cluster.getCategory(), (CharSequence)"Warnings");
            for (AuditError error : cluster.getAuditErrorList()) {
                awardStatus.addValidationLog(this.expandErrorString(error.getMessageKey(), error.getParams()), logSuccess, error.getMessageKey());
            }
        }
        GlobalVariables.getAuditErrorMap().clear();
        return result;
    }

    protected String expandErrorString(String errorKey, String[] params) {
        return this.errorHandlingUtilService.resolveErrorKey(errorKey, params);
    }

    @Override
    public List<String> buildListForFYI(AwardDocument awardDocument) throws WorkflowException {
        WorkflowDocument document = awardDocument.getDocumentHeader().getWorkflowDocument();
        RoutingReportCriteria reportCriteria = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId()).build();
        DocumentRouteHeaderValue routeHeader = KEWServiceLocator.getRouteHeaderService().getRouteHeader(document.getDocumentId());
        Set<String> preexistingActionRequestIds = this.getActionRequestIds(routeHeader);
        DocumentDetail documentDetail = this.workflowUtility.executeSimulation(reportCriteria);
        List<ActionRequestValue> actionRequests = this.reconstituteActionRequestValues(documentDetail, preexistingActionRequestIds);
        ArrayList<String> actionIds = new ArrayList<String>();
        for (ActionRequestValue request : actionRequests) {
            if (request.isGroupRequest()) {
                actionIds.addAll(KimApiServiceLocator.getGroupService().getMemberPrincipalIds(request.getGroupId()));
            }
            if (!request.isUserRequest()) continue;
            actionIds.add(request.getPrincipalId());
        }
        return actionIds;
    }

    @Override
    public boolean doKeyValuesMatch(PersistableBusinessObject object, Map<String, Object> keyValues) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        boolean matchesAll = true;
        Class<?> clazz = object.getClass();
        for (Map.Entry<String, Object> entry : keyValues.entrySet()) {
            boolean matches = false;
            for (PropertyDescriptor propDescriptor : PropertyUtils.getPropertyDescriptors(clazz)) {
                Method getter;
                Object value;
                if (!StringUtils.equals((CharSequence)propDescriptor.getName(), (CharSequence)entry.getKey()) || !Objects.equals(value = (getter = propDescriptor.getReadMethod()).invoke((Object)object, new Object[0]), entry.getValue())) continue;
                matches = true;
            }
            matchesAll &= matches;
        }
        return matchesAll;
    }

    @Override
    public PersistableBusinessObject findMatchingBo(Collection<? extends PersistableBusinessObject> items, Map<String, Object> keyValues) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        PersistableBusinessObject matchedBo = null;
        for (PersistableBusinessObject persistableBusinessObject : items) {
            if (!this.doKeyValuesMatch(persistableBusinessObject, keyValues)) continue;
            matchedBo = persistableBusinessObject;
            break;
        }
        return matchedBo;
    }

    private Set<String> getActionRequestIds(DocumentRouteHeaderValue document) {
        HashSet<String> actionRequestIds = new HashSet<String>();
        List actionRequests = KEWServiceLocator.getActionRequestService().findAllActionRequestsByDocumentId(document.getDocumentId());
        if (actionRequests != null) {
            for (ActionRequestValue actionRequest : actionRequests) {
                if (actionRequest.getActionRequestId() == null) continue;
                actionRequestIds.add(actionRequest.getActionRequestId());
            }
        }
        return actionRequestIds;
    }

    protected List<ActionRequestValue> reconstituteActionRequestValues(DocumentDetail documentDetail, Set<String> preexistingActionRequestIds) {
        List actionRequestVOs = documentDetail.getActionRequests();
        ArrayList<ActionRequestValue> futureActionRequests = new ArrayList<ActionRequestValue>();
        if (actionRequestVOs != null) {
            for (ActionRequest actionRequestVO : actionRequestVOs) {
                if (actionRequestVO == null) continue;
                ActionRequestValue converted = ActionRequestValue.from((ActionRequest)actionRequestVO);
                futureActionRequests.add(converted);
            }
        }
        return futureActionRequests;
    }

    public void setWorkflowUtility(WorkflowDocumentActionsService workflowUtility) {
        this.workflowUtility = workflowUtility;
    }

    protected ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public ErrorHandlingUtilService getErrorHandlingUtilService() {
        return this.errorHandlingUtilService;
    }

    public void setErrorHandlingUtilService(ErrorHandlingUtilService errorHandlingUtilService) {
        this.errorHandlingUtilService = errorHandlingUtilService;
    }
}

