/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.provider.repository;

import java.util.HashMap;
import java.util.Map;
import org.kuali.rice.krms.api.engine.ExecutionOptions;
import org.kuali.rice.krms.api.engine.SelectionCriteria;
import org.kuali.rice.krms.api.engine.Term;
import org.kuali.rice.krms.api.repository.RuleRepositoryService;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.context.ContextSelectionCriteria;
import org.kuali.rice.krms.framework.engine.Context;
import org.kuali.rice.krms.framework.engine.ContextProvider;
import org.kuali.rice.krms.impl.provider.repository.RepositoryToEngineTranslator;

public class RuleRepositoryContextProvider
implements ContextProvider {
    private static final String NAME_CONTEXT_QUALIFIER = "name";
    private static final String NAMESPACE_CODE_CONTEXT_QUALIFIER = "namespaceCode";
    private RuleRepositoryService ruleRepositoryService;
    private RepositoryToEngineTranslator repositoryToEngineTranslator;

    public Context loadContext(SelectionCriteria selectionCriteria, Map<Term, Object> facts, ExecutionOptions executionOptions) {
        ContextSelectionCriteria contextSelectionCriteria = this.constructContextSelectionCriteria(selectionCriteria);
        ContextDefinition contextDefinition = this.ruleRepositoryService.selectContext(contextSelectionCriteria);
        if (contextDefinition != null) {
            return this.loadContextFromDefinition(contextDefinition);
        }
        return null;
    }

    protected Context loadContextFromDefinition(ContextDefinition contextDefinition) {
        return this.repositoryToEngineTranslator.translateContextDefinition(contextDefinition);
    }

    public void setRuleRepositoryService(RuleRepositoryService ruleRepositoryService) {
        this.ruleRepositoryService = ruleRepositoryService;
    }

    public void setRepositoryToEngineTranslator(RepositoryToEngineTranslator repositoryToEngineTranslator) {
        this.repositoryToEngineTranslator = repositoryToEngineTranslator;
    }

    protected ContextSelectionCriteria constructContextSelectionCriteria(SelectionCriteria selectionCriteria) {
        Map givenContextQualifiers = selectionCriteria.getContextQualifiers();
        if (givenContextQualifiers == null || givenContextQualifiers.isEmpty()) {
            throw new IllegalArgumentException("Context qualifiers in the selection criteria were null or empty.  At least one context qualifier must be passed in selection criteria.");
        }
        String namespaceCode = null;
        String name = null;
        HashMap<String, String> contextQualifiers = new HashMap<String, String>();
        for (String key : givenContextQualifiers.keySet()) {
            String value = (String)givenContextQualifiers.get(key);
            if (key.equals(NAME_CONTEXT_QUALIFIER)) {
                name = value;
                continue;
            }
            if (key.equals(NAMESPACE_CODE_CONTEXT_QUALIFIER)) {
                namespaceCode = value;
                continue;
            }
            contextQualifiers.put(key, value);
        }
        return ContextSelectionCriteria.newCriteria(namespaceCode, name, contextQualifiers);
    }
}

