/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.coi.framework;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.coi.framework.Project;
import org.kuali.coeus.coi.framework.ProjectPerson;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.coi.framework.ProjectSponsor;
import org.kuali.coeus.coi.framework.Versionedproject;
import org.kuali.coeus.common.framework.medusa.MedusaNode;
import org.kuali.coeus.common.framework.medusa.MedusaService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcOperations;

public abstract class AbstractProjectRetrievalService
implements ProjectRetrievalService {
    protected static final String SOURCE_UNIQUE_IDENTIFIER_METADATA = "sourceUniqueIdentifier";
    @Autowired
    @Qualifier(value="jdbcOperations")
    private JdbcOperations jdbcOperations;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    private MedusaService medusaService;

    @Override
    public Collection<Project> retrieveProjects() {
        Map<String, Project> projects = this.getProjectsMap();
        if (!projects.isEmpty()) {
            Map<String, List<ProjectPerson>> persons = this.getPersonsMap();
            persons.forEach((k, v) -> ((Project)projects.get(k)).setPersons((List<ProjectPerson>)v));
        }
        return projects.values();
    }

    @Override
    public abstract Project convertObjectToProject(Versionedproject var1) throws SQLException;

    protected Map<String, Project> getProjectsMap() {
        return this.getProjectEntries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a2));
    }

    protected List<Map.Entry<String, Project>> getProjectEntries() {
        return this.getJdbcOperations().query(c -> c.prepareStatement(this.allProjectQuery()), (rs, rowNum) -> {
            Project project = this.toProject(rs);
            return org.kuali.coeus.sys.framework.util.CollectionUtils.entry(project.getSourceIdentifier(), project);
        });
    }

    protected Map<String, List<ProjectPerson>> getPersonsMap() {
        return this.jdbcOperations.query(c -> c.prepareStatement(this.allProjectPersonQuery()), (rs, rowNum) -> this.toProjectPerson(rs)).stream().collect(Collectors.groupingBy(ProjectPerson::getSourceIdentifier));
    }

    @Override
    public Project retrieveProject(String sourceIdentifier) {
        if (StringUtils.isBlank((CharSequence)sourceIdentifier)) {
            throw new IllegalArgumentException("sourceIdentifier is blank");
        }
        Project project = (Project)this.jdbcOperations.query(c -> {
            PreparedStatement statement = c.prepareStatement(this.projectQuery());
            statement.setString(1, sourceIdentifier);
            return statement;
        }, rs -> rs.next() ? this.toProject(rs) : null);
        if (project != null) {
            List persons = this.jdbcOperations.query(c -> {
                PreparedStatement statement = c.prepareStatement(this.projectPersonQuery());
                statement.setString(1, sourceIdentifier);
                return statement;
            }, (rs, rowNum) -> this.toProjectPerson(rs));
            project.setPersons(persons);
        }
        return project;
    }

    public String getBaseShortUrl() {
        return this.getConfigurationService().getPropertyValueAsString("application.url");
    }

    protected void setSponsorFields(List<ProjectSponsor> sponsors, Project project) {
        sponsors.stream().findFirst().ifPresent(sponsor -> {
            project.setSponsorCode(sponsor.getSponsorCode());
            project.setSponsorName(sponsor.getSponsorName());
            project.setSponsorTypeCode(sponsor.getSponsorTypeCode());
            project.setSponsorTypeDescription(sponsor.getSponsorTypeDescription());
        });
        project.setSponsors(sponsors);
    }

    protected List<Project> getLinkedProjects(MedusaNode medusaNode) {
        return (List)CollectionUtils.emptyIfNull((Collection)this.getNodes(medusaNode, new ArrayList<MedusaNode>()).stream().map(medusaNode1 -> this.createLinkedProject((MedusaNode)medusaNode1)).collect(Collectors.toList()));
    }

    private List<MedusaNode> getNodes(MedusaNode medusaNode, List<MedusaNode> nodes) {
        CollectionUtils.addAll(nodes, medusaNode.getChildNodes());
        for (MedusaNode medusaNode2 : medusaNode.getChildNodes()) {
            if (!medusaNode2.getNodeType().equals("award") && !medusaNode2.getNodeType().equals("IP") && !medusaNode2.getNodeType().equals("DP")) continue;
            this.getNodes(medusaNode2, nodes);
        }
        return nodes;
    }

    protected Date getCreatedDate(String identifier) {
        return (Date)this.jdbcOperations.query(c -> {
            PreparedStatement statement = c.prepareStatement(this.getCreatedDateQuery());
            statement.setString(1, identifier);
            return statement;
        }, rs -> rs.next() ? this.getDate(rs) : null);
    }

    protected Date getDate(ResultSet rs) throws SQLException {
        return rs.getDate(1);
    }

    public abstract String getCreatedDateQuery();

    protected Project createLinkedProject(MedusaNode medusaNode) {
        Project project = new Project();
        if (medusaNode.getNodeType().equals("award")) {
            Award award = (Award)medusaNode.getData();
            project.setSourceIdentifier(award.getAwardNumber());
            project.setSourceSystem("KC-AWARD");
            project.setTitle(award.getTitle());
            project.setShortUrl(this.getBaseShortUrl() + "/kc-common/awards/" + project.getSourceIdentifier());
        } else if (medusaNode.getNodeType().equals("IP")) {
            InstitutionalProposal institutionalProposal = (InstitutionalProposal)medusaNode.getData();
            project.setSourceIdentifier(institutionalProposal.getProposalNumber());
            project.setSourceSystem("KC-IP");
            project.setTitle(institutionalProposal.getTitle());
            project.setShortUrl(this.getBaseShortUrl() + "/kc-common/proposals/" + project.getSourceIdentifier());
        } else if (medusaNode.getNodeType().equals("DP")) {
            DevelopmentProposal developmentProposal = (DevelopmentProposal)medusaNode.getData();
            project.setSourceIdentifier(developmentProposal.getProposalNumber());
            project.setSourceSystem("KC-PD");
            project.setTitle(developmentProposal.getTitle());
            project.setShortUrl(this.getBaseShortUrl() + "/kc-common/development-proposals/" + project.getSourceIdentifier());
        } else {
            return null;
        }
        return project;
    }

    protected abstract Project toProject(ResultSet var1) throws SQLException;

    protected abstract ProjectPerson toProjectPerson(ResultSet var1) throws SQLException;

    protected abstract String allProjectQuery();

    protected abstract String allProjectPersonQuery();

    protected abstract String projectQuery();

    protected abstract String projectPersonQuery();

    public JdbcOperations getJdbcOperations() {
        return this.jdbcOperations;
    }

    public void setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public MedusaService getMedusaService() {
        if (this.medusaService == null) {
            this.medusaService = KcServiceLocator.getService(MedusaService.class);
        }
        return this.medusaService;
    }

    public void setMedusaService(MedusaService medusaService) {
        this.medusaService = medusaService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

