/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.rate;

import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/proposalBudget"})
public class ProposalBudgetRatesController
extends ProposalBudgetControllerBase {
    @Autowired
    @Qualifier(value="budgetRatesService")
    private BudgetRatesService budgetRatesService;

    @Transactional
    @RequestMapping(params={"methodToCall=syncAllRates"})
    public ModelAndView syncAllRates(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        budget.setRateClassTypesReloaded(true);
        this.getBudgetRatesService().syncAllBudgetRates(budget);
        budget.setRateSynced(true);
        if (!budget.getActivityTypeCode().equals(budget.getDevelopmentProposal().getActivityTypeCode())) {
            budget.setActivityTypeCode(budget.getDevelopmentProposal().getActivityTypeCode());
        }
        return super.save(form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=refreshAllRates"})
    public ModelAndView refreshAllRates(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        this.getBudgetRatesService().resetAllBudgetRates(budget);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=syncRates"})
    public ModelAndView syncRates(@RequestParam(value="rateClassTypeCode") String rateClassTypeCode, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        this.getBudgetRatesService().syncBudgetRatesForRateClassType(rateClassTypeCode, budget);
        budget.setRateClassTypesReloaded(false);
        if (rateClassTypeCode.equals(RateClassType.OVERHEAD.getRateClassType())) {
            budget.setRateSynced(true);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(params={"methodToCall=resetRates"})
    public ModelAndView resetRates(@RequestParam(value="rateClassTypeCode") String rateClassTypeCode, @ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        this.getBudgetRatesService().resetBudgetRatesForRateClassType(rateClassTypeCode, budget);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Override
    public BudgetRatesService getBudgetRatesService() {
        return this.budgetRatesService;
    }

    @Override
    public void setBudgetRatesService(BudgetRatesService budgetRatesService) {
        this.budgetRatesService = budgetRatesService;
    }
}

