/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.task.tasks;

import co.kuali.coeus.task.tasks.AsyncTask;
import co.kuali.coeus.task.util.CommandLineArgsHolder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="elasticsearchTask")
public class ElasticsearchTask
extends AsyncTask
implements InitializingBean {
    private static final Logger LOG = LogManager.getLogger(ElasticsearchTask.class);
    private static final String ARG_DOC_ID = "docId";
    private static final String ARG_LIMIT = "limit";
    private static final String ARG_SKIP = "skip";
    private static final String INTEGER_ARGUMENT_ERROR = "%s argument must be an integer";
    @Autowired
    private ElasticsearchIndexService elasticsearchIndexService;
    @Autowired
    private KewDocHeaderDao kewDocHeaderDao;

    public void afterPropertiesSet() throws Exception {
        LOG.info("Elasticsearch Task initialized");
    }

    @Override
    public List<String> validateArguments() {
        return Stream.of(ARG_LIMIT, ARG_SKIP).map(arg -> !CommandLineArgsHolder.isNumericArgValid(arg) ? Optional.of(String.format(INTEGER_ARGUMENT_ERROR, arg)) : Optional.empty()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    protected List<String> getDocIds() {
        if (CommandLineArgsHolder.isArgPresent(ARG_DOC_ID)) {
            return CommandLineArgsHolder.getArgValues(ARG_DOC_ID);
        }
        Integer limit = CommandLineArgsHolder.getIntegerArg(ARG_LIMIT).orElse(null);
        Integer skip = CommandLineArgsHolder.getIntegerArg(ARG_SKIP).orElse(null);
        return this.kewDocHeaderDao.getAllDocumentIds(limit, skip);
    }

    protected boolean isBulkIndex() {
        return !CommandLineArgsHolder.isArgPresent(ARG_DOC_ID);
    }

    @Override
    @Transactional
    protected void startAsyncTask() throws ExecutionException, InterruptedException {
        List<String> docIds = this.getDocIds();
        if (!this.isBulkIndex()) {
            if (CollectionUtils.isNotEmpty(docIds)) {
                for (String docId : docIds) {
                    if (this.elasticsearchIndexService.index(docId).get().booleanValue()) {
                        LOG.info(String.format("Indexed document %s into Elasticsearch", docId));
                        continue;
                    }
                    LOG.error(String.format("Failed to index document %s", docId));
                }
            }
        } else {
            this.elasticsearchIndexService.bulkIndex(docIds);
            LOG.info(String.format("Started indexing %s documents", docIds.size()));
        }
    }

    @Override
    protected boolean isComplete() {
        return this.elasticsearchIndexService.isIdle();
    }

    @Override
    public Logger getLog() {
        return LOG;
    }

    @Override
    public void dryRun() {
        super.dryRun();
        List<String> docIds = this.getDocIds();
        LOG.info(String.format("Would %sindex %d documents into Elasticsearch:", this.isBulkIndex() ? "bulk " : "", docIds.size()));
        docIds.forEach(arg_0 -> ((Logger)LOG).info(arg_0));
    }
}

