/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.notification.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class NotificationRendererBase
implements NotificationRenderer,
Serializable {
    private static final long serialVersionUID = 7355369114077509177L;
    public static final String USER_FULLNAME = "{USER_FULLNAME}";
    public static final String DOCHANDLER_PREFIX = "{DOCUMENT_PREFIX}";
    public static final String RICE_SERVER_URL = "rice.server.url";
    public static final String APP_LINK_PREFIX = "{APP_LINK_PREFIX}";
    public static final String APPLICATION_URL_PARM = "application.url";
    private transient KcPersonService kcPersonService;
    private transient ConfigurationService kualiConfigurationService;

    @Override
    public String render(String text) {
        return this.render(text, this.getDefaultReplacementParameters());
    }

    protected String render(String text, Map<String, String> replacementParameters) {
        for (String key : replacementParameters.keySet()) {
            text = StringUtils.replace((String)text, (String)key, (String)replacementParameters.get(key));
        }
        return text;
    }

    @Override
    public Map<String, String> getDefaultReplacementParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        if (GlobalVariables.getUserSession() != null) {
            params.put(USER_FULLNAME, this.getKcPersonService().getKcPersonByPersonId(GlobalVariables.getUserSession().getPrincipalId()).getFullName());
        } else {
            params.put(USER_FULLNAME, "");
        }
        params.put(DOCHANDLER_PREFIX, this.getDocumentLocation());
        params.put(APP_LINK_PREFIX, this.getApplicationLinkPrefix());
        return params;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    private String getDocumentLocation() {
        return this.getKualiConfigurationService().getPropertyValueAsString(RICE_SERVER_URL);
    }

    private String getApplicationLinkPrefix() {
        String retVal = this.getKualiConfigurationService().getPropertyValueAsString(APPLICATION_URL_PARM);
        if (retVal == null) {
            retVal = "..";
        }
        return retVal;
    }

    protected ConfigurationService getKualiConfigurationService() {
        if (this.kualiConfigurationService == null) {
            this.kualiConfigurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.kualiConfigurationService;
    }
}

