/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.ComponentTree;
import org.apache.lucene.geo.EdgeTree;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.index.PointValues;

public final class Line2D
implements Component2D {
    private final double minY;
    private final double maxY;
    private final double minX;
    private final double maxX;
    private final EdgeTree tree;

    private Line2D(Line line) {
        this.minY = line.minLat;
        this.maxY = line.maxLat;
        this.minX = line.minLon;
        this.maxX = line.maxLon;
        this.tree = EdgeTree.createTree((double[])line.getLons(), (double[])line.getLats());
    }

    private Line2D(XYLine line) {
        this.minY = line.minY;
        this.maxY = line.maxY;
        this.minX = line.minX;
        this.maxX = line.maxX;
        this.tree = EdgeTree.createTree((double[])line.getX(), (double[])line.getY());
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public boolean contains(double x, double y) {
        if (Component2D.containsPoint((double)x, (double)y, (double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY)) {
            return this.tree.isPointOnLine(x, y);
        }
        return false;
    }

    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.disjoint((double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY, (double)minX, (double)maxX, (double)minY, (double)maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.within((double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY, (double)minX, (double)maxX, (double)minY, (double)maxY)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (this.tree.crossesBox(minX, maxX, minY, maxY, true)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    public PointValues.Relation relateTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy) {
        if (Component2D.disjoint((double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY, (double)minX, (double)maxX, (double)minY, (double)maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (ax == bx && bx == cx && ay == by && by == cy) {
            if (this.tree.isPointOnLine(ax, ay)) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
        } else {
            if (ax == cx && ay == cy) {
                if (this.tree.crossesLine(minX, maxX, minY, maxY, ax, ay, bx, by)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (ax == bx && ay == by) {
                if (this.tree.crossesLine(minX, maxX, minY, maxY, bx, by, cx, cy)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (bx == cx && by == cy) {
                if (this.tree.crossesLine(minX, maxX, minY, maxY, cx, cy, ax, ay)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (Component2D.pointInTriangle((double)minX, (double)maxX, (double)minY, (double)maxY, (double)this.tree.x1, (double)this.tree.y1, (double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy) || this.tree.crossesTriangle(minX, maxX, minY, maxY, ax, ay, bx, by, cx, cy, true)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, boolean ab, double bx, double by, boolean bc, double cx, double cy, boolean ca) {
        if (ax == bx && ay == by || ax == cx && ay == cy || bx == cx && by == cy) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (Component2D.disjoint((double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY, (double)minX, (double)maxX, (double)minY, (double)maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.tree.crossesLine(minX, maxX, minY, maxY, ax, ay, bx, by)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, bx, by, cx, cy)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.tree.crossesLine(minX, maxX, minY, maxY, cx, cy, ax, ay)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.pointInTriangle((double)minX, (double)maxX, (double)minY, (double)maxY, (double)this.tree.x1, (double)this.tree.y1, (double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    public static Component2D create(Line ... lines) {
        Component2D[] components = new Component2D[lines.length];
        for (int i = 0; i < components.length; ++i) {
            components[i] = new Line2D(lines[i]);
        }
        return ComponentTree.create((Component2D[])components);
    }

    public static Component2D create(XYLine ... lines) {
        Component2D[] components = new Line2D[lines.length];
        for (int i = 0; i < components.length; ++i) {
            components[i] = new Line2D(lines[i]);
        }
        return ComponentTree.create((Component2D[])components);
    }
}

