/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.node;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.xml.SafeXmlUtils;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.engine.node.ProcessDefinitionBo;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class RouteNodeUtils {
    private RouteNodeUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    public static String getValueOfCustomProperty(RouteNode routeNode, String propertyName) {
        String contentFragment = routeNode.getContentFragment();
        String elementValue = null;
        if (!StringUtils.isBlank((String)contentFragment)) {
            try {
                DocumentBuilder db = SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder();
                Document document = db.parse(new InputSource(new StringReader(contentFragment)));
                elementValue = XPathHelper.newXPath().evaluate("//" + propertyName, document);
            }
            catch (Exception e) {
                throw new RiceRuntimeException("Error when attempting to parse Route Node content fragment for property name: " + propertyName, (Throwable)e);
            }
        }
        return elementValue;
    }

    public static List<Element> getCustomRouteNodeElements(RouteNode routeNode, String elementName) {
        String contentFragment = routeNode.getContentFragment();
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodeList = null;
        if (!StringUtils.isBlank((String)contentFragment)) {
            try {
                DocumentBuilder db = SafeXmlUtils.safeDocumentBuilderFactory().newDocumentBuilder();
                Document document = db.parse(new InputSource(new StringReader(contentFragment)));
                nodeList = (NodeList)XPathHelper.newXPath().evaluate("//" + elementName, document, XPathConstants.NODESET);
            }
            catch (Exception e) {
                throw new RiceRuntimeException("Error when attempting to parse Route Node content fragment for element name: " + elementName, (Throwable)e);
            }
        }
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element element = (Element)nodeList.item(index);
            elements.add(element);
        }
        return elements;
    }

    public static Element getCustomRouteNodeElement(RouteNode routeNode, String elementName) {
        List<Element> elements = RouteNodeUtils.getCustomRouteNodeElements(routeNode, elementName);
        if (CollectionUtils.isEmpty(elements)) {
            return null;
        }
        if (elements.size() > 1) {
            throw new RiceRuntimeException("More than one element found with the given name: " + elementName);
        }
        return elements.get(0);
    }

    public static List<RouteNodeInstance> getFlattenedNodeInstances(DocumentRouteHeaderValue document, boolean includeProcesses) {
        ArrayList<RouteNodeInstance> nodeInstances = new ArrayList<RouteNodeInstance>();
        HashSet<String> visitedNodeInstanceIds = new HashSet<String>();
        for (RouteNodeInstance initialNodeInstance : document.getInitialRouteNodeInstances()) {
            RouteNodeUtils.flattenNodeInstanceGraph(nodeInstances, visitedNodeInstanceIds, initialNodeInstance, includeProcesses);
        }
        return nodeInstances;
    }

    private static void flattenNodeInstanceGraph(List<RouteNodeInstance> nodeInstances, Set<String> visitedNodeInstanceIds, RouteNodeInstance nodeInstance, boolean includeProcesses) {
        if (visitedNodeInstanceIds.contains(nodeInstance.getRouteNodeInstanceId())) {
            return;
        }
        if (includeProcesses && nodeInstance.getProcess() != null) {
            RouteNodeUtils.flattenNodeInstanceGraph(nodeInstances, visitedNodeInstanceIds, nodeInstance.getProcess(), includeProcesses);
        }
        visitedNodeInstanceIds.add(nodeInstance.getRouteNodeInstanceId());
        nodeInstances.add(nodeInstance);
        for (RouteNodeInstance nextNodeInstance : nodeInstance.getNextNodeInstances()) {
            RouteNodeUtils.flattenNodeInstanceGraph(nodeInstances, visitedNodeInstanceIds, nextNodeInstance, includeProcesses);
        }
    }

    public static List<RouteNode> getFlattenedNodes(DocumentType documentType, boolean climbHierarchy) {
        ArrayList<RouteNode> nodes = new ArrayList<RouteNode>();
        if (!documentType.isRouteInherited() || climbHierarchy) {
            for (Object o : documentType.getProcesses()) {
                ProcessDefinitionBo process = (ProcessDefinitionBo)o;
                nodes.addAll(RouteNodeUtils.getFlattenedNodes(process));
            }
        }
        Collections.sort(nodes, new RouteNodeSorter());
        return nodes;
    }

    public static List<RouteNode> getFlattenedNodes(ProcessDefinitionBo process) {
        HashMap<String, RouteNode> nodesMap = new HashMap<String, RouteNode>();
        if (process.getInitialRouteNode() != null) {
            RouteNodeUtils.flattenNodeGraph(nodesMap, process.getInitialRouteNode());
            ArrayList<RouteNode> nodes = new ArrayList<RouteNode>(nodesMap.values());
            Collections.sort(nodes, new RouteNodeSorter());
            return nodes;
        }
        ArrayList<RouteNode> nodes = new ArrayList<RouteNode>();
        nodes.add(new RouteNode());
        return nodes;
    }

    private static void flattenNodeGraph(Map<String, RouteNode> nodes, RouteNode node) {
        if (node != null) {
            if (nodes.containsKey(node.getRouteNodeName())) {
                return;
            }
            nodes.put(node.getRouteNodeName(), node);
            for (RouteNode nextNode : node.getNextNodes()) {
                RouteNodeUtils.flattenNodeGraph(nodes, nextNode);
            }
        } else {
            return;
        }
    }

    public static List<RouteNodeInstance> getActiveNodeInstances(DocumentRouteHeaderValue document) {
        List<RouteNodeInstance> flattenedNodeInstances = RouteNodeUtils.getFlattenedNodeInstances(document, true);
        ArrayList<RouteNodeInstance> activeNodeInstances = new ArrayList<RouteNodeInstance>();
        for (RouteNodeInstance nodeInstance : flattenedNodeInstances) {
            if (!nodeInstance.isActive()) continue;
            activeNodeInstances.add(nodeInstance);
        }
        return activeNodeInstances;
    }

    private static class RouteNodeSorter
    implements Comparator {
        private RouteNodeSorter() {
        }

        public int compare(Object arg0, Object arg1) {
            RouteNode rn1 = (RouteNode)arg0;
            RouteNode rn2 = (RouteNode)arg1;
            return rn1.getRouteNodeId().compareTo(rn2.getRouteNodeId());
        }
    }
}

