--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--

UPDATE SPONSOR_FORMS SET SPONSOR_FORM_ID = SEQ_SPONSOR_FORMS.NEXTVAL;
UPDATE SPONSOR_FORM_TEMPLATES set SPONSOR_FORM_TEMPLATE_ID = SEQ_SPONSOR_FORM_TEMPLATES.NEXTVAL;

ALTER TABLE SPONSOR_FORM_TEMPLATES DROP CONSTRAINT FK_SPONSOR_FORM_TEMPLATES;

ALTER TABLE SPONSOR_FORM_TEMPLATES DROP CONSTRAINT SPONSOR_FORM_TEMPLATESP1;
ALTER TABLE SPONSOR_FORM_TEMPLATES ADD CONSTRAINT SPONSOR_FORM_TEMPLATESP1 PRIMARY KEY (SPONSOR_FORM_TEMPLATE_ID);

ALTER TABLE SPONSOR_FORMS DROP CONSTRAINT SPONSOR_FORMSP1;
ALTER TABLE SPONSOR_FORMS ADD CONSTRAINT SPONSOR_FORMSP1 PRIMARY KEY (SPONSOR_FORM_ID);
ALTER TABLE SPONSOR_FORMS ADD CONSTRAINT SPONSOR_FORMSU1 UNIQUE (SPONSOR_CODE, SPONSOR_HIERARCHY_NAME, PACKAGE_NUMBER);

UPDATE SPONSOR_FORM_TEMPLATES sft SET SPONSOR_FORM_ID = (SELECT SPONSOR_FORM_ID FROM SPONSOR_FORMS WHERE SPONSOR_CODE = sft.SPONSOR_CODE AND PACKAGE_NUMBER = sft.PACKAGE_NUMBER);

ALTER TABLE SPONSOR_FORM_TEMPLATES ADD CONSTRAINT FK_SPONSOR_FORM_TEMPLATES FOREIGN KEY (SPONSOR_FORM_ID) REFERENCES SPONSOR_FORMS(SPONSOR_FORM_ID);
ALTER TABLE SPONSOR_FORM_TEMPLATES ADD CONSTRAINT SPONSOR_FORM_TEMPLATESU1 UNIQUE (SPONSOR_FORM_ID, PAGE_NUMBER);

ALTER TABLE SPONSOR_FORM_TEMPLATES DROP (SPONSOR_CODE, PACKAGE_NUMBER);
