/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer.conversions;

import java.util.Vector;
import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.apache.ojb.broker.accesslayer.conversions.FieldConversion;

public class StringVector2VarcharFieldConversion
implements FieldConversion {
    private static final String NULLVALUE = "#NULL#";
    private static final String EMPTYCOLLEC = "#EMTPY#";
    private static final String SEPARATOR = "#";

    @Override
    public Object javaToSql(Object object) throws ConversionException {
        if (object == null) {
            return NULLVALUE;
        }
        if (!(object instanceof Vector)) {
            throw new ConversionException("Object is not a vector it is a" + object.getClass().getName());
        }
        Vector vector = (Vector)object;
        if (vector.size() == 0) {
            return EMPTYCOLLEC;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.get(i).toString();
            if (string.indexOf(SEPARATOR) >= 0) {
                throw new ConversionException("An entry in the Vector contains the forbidden # character used to separate the strings on the DB");
            }
            stringBuffer.append(string);
            stringBuffer.append(SEPARATOR);
        }
        return stringBuffer.toString();
    }

    @Override
    public Object sqlToJava(Object object) throws ConversionException {
        if (object == null) {
            return null;
        }
        if (object.toString().equals(NULLVALUE)) {
            return null;
        }
        if (object.toString().equals(EMPTYCOLLEC)) {
            return new Vector();
        }
        Vector<String> vector = new Vector<String>();
        String string = object.toString();
        int n = string.indexOf(SEPARATOR);
        while (n >= 0) {
            if (n == 0) {
                vector.add("");
            } else {
                vector.add(string.substring(0, n));
            }
            if (n + 1 > string.length()) break;
            string = string.substring(n + 1, string.length());
            n = string.indexOf(SEPARATOR);
        }
        return vector;
    }
}

