/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.type.OrganizationTypeContract;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.propdev.api.abstrct.ProposalAbstractContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.s2s.map.ApplicantOrganization;
import org.kuali.coeus.propdev.impl.s2s.map.AttachmentMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.BudgetMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.Compliance;
import org.kuali.coeus.propdev.impl.s2s.map.FundingOpportunity;
import org.kuali.coeus.propdev.impl.s2s.map.MappingConstants;
import org.kuali.coeus.propdev.impl.s2s.map.PersonMappingService;
import org.kuali.coeus.propdev.impl.s2s.map.Project;
import org.kuali.coeus.propdev.impl.s2s.map.RenewalInformation;
import org.kuali.coeus.propdev.impl.s2s.map.S2sMappingService;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sModuleQuestionnaireBean;
import org.kuali.coeus.sys.api.model.Cfda;
import org.kuali.coeus.sys.api.model.CodedNumeric;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="s2sMappingService")
public class S2sMappingServiceImpl
implements S2sMappingService {
    @Autowired
    @Qualifier(value="personMappingService")
    private PersonMappingService personMappingService;
    @Autowired
    @Qualifier(value="questionnaireAnswerService")
    private QuestionnaireAnswerService questionnaireAnswerService;
    @Autowired
    @Qualifier(value="attachmentMappingService")
    private AttachmentMappingService attachmentMappingService;
    @Autowired
    @Qualifier(value="budgetMappingService")
    private BudgetMappingService budgetMappingService;

    @Override
    public Project toProject(ProposalDevelopmentDocumentContract pdDoc) {
        DevelopmentProposal proposal = (DevelopmentProposal)pdDoc.getDevelopmentProposal();
        ProposalDevelopmentS2sModuleQuestionnaireBean moduleBean = new ProposalDevelopmentS2sModuleQuestionnaireBean(proposal);
        moduleBean.setFinalDoc(true);
        List<AnswerHeader> questionnaireAnswers = this.questionnaireAnswerService.getQuestionnaireAnswer(moduleBean);
        Project project = new Project();
        project.setTitle(proposal.getTitle());
        this.getAbstract(proposal, "1").ifPresent(project::setProjectDescription);
        this.getAbstract(proposal, "16").ifPresent(project::setAreasAffected);
        this.getAbstract(proposal, "15").ifPresent(project::setDeviationAuthorization);
        this.getAbstract(proposal, "12").ifPresent(project::setSuggestedReviewers);
        this.getAbstract(proposal, "14").ifPresent(project::setReviewersNotToInclude);
        project.setStartDate(proposal.getRequestedStartDateInitial());
        project.setEndDate(proposal.getRequestedEndDateInitial());
        project.setAwardNumber(proposal.getCurrentAwardNumber());
        this.getAgencyName(proposal).ifPresent(project::setAgencyName);
        project.setCfdaNumbers(this.getCfdaNumbers(proposal));
        project.setCfdaProgramTitle(proposal.getProgramAnnouncementTitle());
        this.getFundingOpportunity(proposal).ifPresent(project::setFundingOpportunity);
        project.setApplicantOrganization(this.getApplicantOrganization(proposal));
        this.personMappingService.getProjectDirector(proposal).ifPresent(project::setProjectDirector);
        this.personMappingService.getContactPerson(proposal).ifPresent(project::setContactPerson);
        project.setCompliance(this.getCompliance(questionnaireAnswers));
        project.setRenewalInformation(this.getRenewalInformation(questionnaireAnswers));
        project.setAttachments(this.attachmentMappingService.getAttachments(proposal));
        project.setBudgetSummary(this.budgetMappingService.getBudgetSummary(proposal));
        return project;
    }

    private ApplicantOrganization getApplicantOrganization(DevelopmentProposalContract proposal) {
        ApplicantOrganization applicantOrganization = new ApplicantOrganization();
        ProposalSiteContract proposalSite = proposal.getApplicantOrganization();
        applicantOrganization.setName(proposalSite.getLocationName());
        applicantOrganization.setHumanSubjectsAssuranceNumber(proposalSite.getOrganization().getHumanSubAssurance());
        applicantOrganization.setAuthorizedRepresentative(this.getPersonMappingService().getAor(proposal));
        this.getEmployerTaxpayerId(proposal).ifPresent(applicantOrganization::setEmployerTaxpayerId);
        applicantOrganization.setDunsNumber(proposalSite.getOrganization().getDunsNumber());
        applicantOrganization.setCongressionalDistrict(proposalSite.getOrganization().getCongressionalDistrict());
        applicantOrganization.setApplicantTypes(this.getApplicantTypes(proposalSite.getOrganization()));
        applicantOrganization.setApplicantTypeOtherDescriptions(this.getApplicantTypeOtherDescriptions(proposalSite.getOrganization()));
        return applicantOrganization;
    }

    private List<String> getApplicantTypes(OrganizationContract organization) {
        return this.getOrganizationTypeCodes(organization).map(MappingConstants.APPLICANT_TYPES::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<String> getApplicantTypeOtherDescriptions(OrganizationContract organization) {
        return this.getOrganizationTypeCodes(organization).map(MappingConstants.APPLICANT_OTHER_TYPE_DESCRIPTIONS::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Stream<Integer> getOrganizationTypeCodes(OrganizationContract organization) {
        return organization.getOrganizationTypes().stream().map(OrganizationTypeContract::getOrganizationTypeList).map(CodedNumeric::getCode);
    }

    private Optional<String> getAgencyName(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getSponsor()).map(SponsorContract::getSponsorName).or(() -> Optional.ofNullable(proposal.getPrimeSponsor()).map(SponsorContract::getSponsorName));
    }

    private List<String> getCfdaNumbers(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getProposalCfdas()).orElse(List.of()).stream().map(Cfda::getCfdaNumber).collect(Collectors.toList());
    }

    private Optional<FundingOpportunity> getFundingOpportunity(DevelopmentProposalContract proposal) {
        return Optional.ofNullable(proposal.getS2sOpportunity()).map(opportunity -> {
            FundingOpportunity fundingOpportunity = new FundingOpportunity();
            fundingOpportunity.setNumber(opportunity.getOpportunityId());
            fundingOpportunity.setTitle(opportunity.getOpportunityTitle());
            return fundingOpportunity;
        });
    }

    private Optional<String> getEmployerTaxpayerId(DevelopmentProposalContract proposal) {
        boolean isNIH = ((DevelopmentProposal)proposal).isNIHSponsor();
        return Optional.ofNullable(proposal.getApplicantOrganization()).map(ProposalSiteContract::getOrganization).map(org -> isNIH && StringUtils.isNotBlank((CharSequence)org.getPhsAccount()) ? org.getPhsAccount() : org.getFederalEmployerId());
    }

    private Compliance getCompliance(List<AnswerHeader> questionnaireAnswers) {
        Compliance compliance = new Compliance();
        this.getAnswerAsBoolean(questionnaireAnswers, 145).ifPresent(compliance::setVertebrateAnimals);
        this.getAnswerAsBoolean(questionnaireAnswers, 146).ifPresent(compliance::setAnimalEuthanasiaIndicator);
        this.getAnswerAsBoolean(questionnaireAnswers, 147).ifPresent(compliance::setAVMAConsistentIndicator);
        this.getQuestionAnswer(questionnaireAnswers, 148).ifPresent(compliance::setEuthanasiaMethodDescription);
        this.getAnswerAsBoolean(questionnaireAnswers, 5).ifPresent(compliance::setIsHumanStemCellsInvolved);
        this.getAnswerAsBoolean(questionnaireAnswers, 6).ifPresent(compliance::setStemCellsIndicator);
        this.getQuestionAnswers(questionnaireAnswers, 149).ifPresent(compliance::setCellLines);
        this.getAnswerAsBoolean(questionnaireAnswers, -10145).ifPresent(compliance::setIsHumanFetalTissueInvolved);
        return compliance;
    }

    private RenewalInformation getRenewalInformation(List<AnswerHeader> questionnaireAnswers) {
        RenewalInformation renewal = new RenewalInformation();
        this.getAnswerAsBoolean(questionnaireAnswers, 118).ifPresent(renewal::setIsRenewalApplication);
        this.getAnswerAsBoolean(questionnaireAnswers, 120).ifPresent(renewal::setIsPreviouslyReported);
        this.getAnswerAsBoolean(questionnaireAnswers, 119).ifPresent(renewal::setIsInventionsAndPatents);
        this.getAnswerAsBoolean(questionnaireAnswers, 114).ifPresent(renewal::setIsChangeOfPDPI);
        this.getAnswerAsBoolean(questionnaireAnswers, 116).ifPresent(renewal::setIsChangeOfInstitution);
        this.getQuestionAnswer(questionnaireAnswers, 117).ifPresent(renewal::setFormerInstitutionName);
        this.getQuestionAnswer(questionnaireAnswers, 115).map(Integer::parseInt).flatMap(this.personMappingService::fromRolodex).ifPresent(renewal::setFormerPD);
        return renewal;
    }

    private Optional<Boolean> getAnswerAsBoolean(Collection<AnswerHeader> answerHeaders, int questionId) {
        return this.getQuestionAnswer(answerHeaders, questionId).map("Y"::equals);
    }

    private Optional<String> getQuestionAnswer(Collection<AnswerHeader> answerHeaders, int questionId) {
        return answerHeaders.stream().flatMap(header -> header.getAnswers().stream()).filter(answer -> answer.getQuestionSeqId().equals(questionId)).filter(answer -> "Y".equals(answer.getMatchedChild())).findFirst().map(Answer::getAnswer);
    }

    private Optional<List<String>> getQuestionAnswers(Collection<AnswerHeader> answerHeaders, int questionId) {
        List answers = answerHeaders.stream().flatMap(header -> header.getAnswers().stream()).filter(answer -> answer.getQuestionSeqId().equals(questionId)).filter(answer -> "Y".equals(answer.getMatchedChild())).map(Answer::getAnswer).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        return answers.isEmpty() ? Optional.empty() : Optional.of(answers);
    }

    private Optional<String> getAbstract(DevelopmentProposalContract proposal, String abstractTypeCode) {
        return proposal.getProposalAbstracts().stream().filter(proposalAbstract -> proposalAbstract.getAbstractType().getCode().equals(abstractTypeCode)).findFirst().map(ProposalAbstractContract::getAbstractDetails);
    }

    public PersonMappingService getPersonMappingService() {
        return this.personMappingService;
    }

    public void setPersonMappingService(PersonMappingService personMappingService) {
        this.personMappingService = personMappingService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public AttachmentMappingService getAttachmentMappingService() {
        return this.attachmentMappingService;
    }

    public void setAttachmentMappingService(AttachmentMappingService attachmentMappingService) {
        this.attachmentMappingService = attachmentMappingService;
    }

    public BudgetMappingService getBudgetMappingService() {
        return this.budgetMappingService;
    }

    public void setBudgetMappingService(BudgetMappingService budgetMappingService) {
        this.budgetMappingService = budgetMappingService;
    }
}

