/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.List;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.PropositionParameterBo;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.ui.RuleTreeNode;

public class SimplePropositionNode
extends RuleTreeNode {
    private static final long serialVersionUID = -629088492909384804L;
    public static final String NODE_TYPE = "ruleTreeNode simplePropositionNode";
    protected String parameterDisplayString;

    public SimplePropositionNode() {
    }

    public SimplePropositionNode(PropositionBo proposition) {
        super(proposition);
        this.setupParameterDisplayString();
    }

    private void setupParameterDisplayString() {
        List<PropositionParameterBo> parameters;
        if (this.proposition != null && this.proposition.getPropositionTypeCode().equalsIgnoreCase(PropositionType.SIMPLE.getCode()) && (parameters = this.proposition.getParameters()) != null && parameters.size() == 3) {
            this.setParameterDisplayString(this.getParamValue(parameters.get(0)) + " " + this.getParamValue(parameters.get(2)) + " " + this.getParamValue(parameters.get(1)));
        }
    }

    private String getParamValue(PropositionParameterBo prop) {
        if (PropositionParameterType.TERM.getCode().equalsIgnoreCase(prop.getParameterType())) {
            String termId = prop.getValue();
            TermBo term = null;
            if (termId != null) {
                term = (TermBo)this.getDataObjectService().find(TermBo.class, (Object)termId);
            }
            if (term != null) {
                return term.getSpecification().getName();
            }
            return "";
        }
        return prop.getValue();
    }

    public String getParameterDisplayString() {
        return this.parameterDisplayString;
    }

    public void setParameterDisplayString(String parameterDisplayString) {
        this.parameterDisplayString = parameterDisplayString;
    }

    public DataObjectService getDataObjectService() {
        return KRADServiceLocator.getDataObjectService();
    }
}

