/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.annotations.OptimisticLocking;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.util.tree.Node;
import org.kuali.rice.core.api.util.tree.Tree;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.impl.repository.ActionAttributeBo;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.RepositoryBoIncrementer;
import org.kuali.rice.krms.impl.repository.RuleAttributeBo;
import org.kuali.rice.krms.impl.ui.CompoundOpCodeNode;
import org.kuali.rice.krms.impl.ui.CompoundPropositionEditNode;
import org.kuali.rice.krms.impl.ui.RuleTreeNode;
import org.kuali.rice.krms.impl.ui.SimplePropositionEditNode;
import org.kuali.rice.krms.impl.ui.SimplePropositionNode;

@Entity
@Table(name="KRMS_RULE_T")
@OptimisticLocking(cascade=true)
public class RuleBo
implements RuleDefinitionContract,
Versioned,
Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = 1L;
    public static final String RULE_SEQ_NAME = "KRMS_RULE_S";
    static final RepositoryBoIncrementer ruleIdIncrementer = new RepositoryBoIncrementer("KRMS_RULE_S");
    static final RepositoryBoIncrementer actionIdIncrementer = new RepositoryBoIncrementer("KRMS_ACTN_S");
    static final RepositoryBoIncrementer ruleAttributeIdIncrementer = new RepositoryBoIncrementer("KRMS_RULE_ATTR_S");
    static final RepositoryBoIncrementer actionAttributeIdIncrementer = new RepositoryBoIncrementer("KRMS_ACTN_ATTR_S");
    @PortableSequenceGenerator(name="KRMS_RULE_S")
    @GeneratedValue(generator="KRMS_RULE_S")
    @Id
    @Column(name="RULE_ID")
    private String id;
    @Column(name="NMSPC_CD")
    private String namespace;
    @Column(name="DESC_TXT")
    private String description;
    @Column(name="NM")
    private String name;
    @Column(name="TYP_ID", nullable=true)
    private String typeId;
    @Column(name="ACTV")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active = true;
    @Column(name="VER_NBR")
    @Version
    private Long versionNumber;
    @ManyToOne(targetEntity=PropositionBo.class, fetch=FetchType.LAZY, cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="PROP_ID", referencedColumnName="PROP_ID")
    private PropositionBo proposition;
    @OneToMany(orphanRemoval=true, mappedBy="rule", fetch=FetchType.LAZY, cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="RULE_ID", referencedColumnName="RULE_ID")
    private List<ActionBo> actions = new ArrayList<ActionBo>();
    @OneToMany(orphanRemoval=true, mappedBy="rule", fetch=FetchType.LAZY, cascade={CascadeType.REFRESH, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.PERSIST})
    @JoinColumn(name="RULE_ID", referencedColumnName="RULE_ID")
    private List<RuleAttributeBo> attributeBos = new ArrayList<RuleAttributeBo>();
    @Transient
    private Tree<RuleTreeNode, String> propositionTree;
    @Transient
    private String propositionSummary;
    @Transient
    private StringBuffer propositionSummaryBuffer;
    @Transient
    private String selectedPropositionId;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_proposition_vh;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public PropositionBo getProposition() {
        return this._persistence_get_proposition();
    }

    public void setProposition(PropositionBo proposition) {
        this._persistence_set_proposition(proposition);
    }

    public void setTypeId(String typeId) {
        if (StringUtils.isBlank((String)typeId)) {
            this._persistence_set_typeId(null);
        } else {
            this._persistence_set_typeId(typeId);
        }
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (RuleAttributeBo attr : this._persistence_get_attributeBos()) {
            DataObjectService dataObjectService = KRADServiceLocator.getDataObjectService();
            dataObjectService.wrap((Object)attr).fetchRelationship("attributeDefinition", false, true);
            attributes.put(attr.getAttributeDefinition().getName(), attr.getValue());
        }
        return attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this._persistence_set_attributeBos(new ArrayList());
        if (!StringUtils.isBlank((String)this._persistence_get_typeId())) {
            List<KrmsAttributeDefinition> attributeDefinitions = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService().findAttributeDefinitionsByType(this.getTypeId());
            HashMap<String, KrmsAttributeDefinition> attributeDefinitionsByName = new HashMap<String, KrmsAttributeDefinition>();
            if (attributeDefinitions != null) {
                for (KrmsAttributeDefinition krmsAttributeDefinition : attributeDefinitions) {
                    attributeDefinitionsByName.put(krmsAttributeDefinition.getName(), krmsAttributeDefinition);
                }
            }
            for (Map.Entry entry : attributes.entrySet()) {
                KrmsAttributeDefinition attributeDefinition = (KrmsAttributeDefinition)attributeDefinitionsByName.get(entry.getKey());
                RuleAttributeBo attributeBo = new RuleAttributeBo();
                attributeBo.setRule(this);
                attributeBo.setValue((String)entry.getValue());
                attributeBo.setAttributeDefinition(KrmsAttributeDefinitionBo.from(attributeDefinition));
                this._persistence_get_attributeBos().add(attributeBo);
            }
        }
    }

    public String getPropositionSummary() {
        if (this.propositionTree == null) {
            this.propositionTree = this.refreshPropositionTree(false);
        }
        return this.propositionSummaryBuffer.toString();
    }

    public Tree getPropositionTree() {
        if (this.propositionTree == null) {
            this.propositionTree = this.refreshPropositionTree(false);
        }
        return this.propositionTree;
    }

    public void setPropositionTree(Tree<RuleTreeNode, String> tree) {
        this.propositionTree.equals(tree);
    }

    public Tree refreshPropositionTree(Boolean editMode) {
        Tree myTree = new Tree();
        Node rootNode = new Node();
        myTree.setRootElement(rootNode);
        this.propositionSummaryBuffer = new StringBuffer();
        PropositionBo prop = this.getProposition();
        if (prop != null && StringUtils.isBlank((String)prop.getDescription())) {
            prop.setDescription("");
        }
        this.buildPropTree(rootNode, prop, editMode);
        this.propositionTree = myTree;
        return myTree;
    }

    private void buildPropTree(Node sprout, PropositionBo prop, Boolean editMode) {
        if (prop != null) {
            String nodeLabel = prop.getDescription();
            if (StringUtils.isBlank((String)nodeLabel)) {
                nodeLabel = ": :  blank proposition name  : :";
            }
            if (PropositionType.SIMPLE.getCode().equalsIgnoreCase(prop.getPropositionTypeCode())) {
                Node child = new Node();
                child.setNodeLabel((Object)nodeLabel);
                if (prop.getEditMode()) {
                    child.setNodeLabel((Object)"");
                    child.setNodeType("ruleTreeNode simplePropositionEditNode");
                    SimplePropositionEditNode pNode = new SimplePropositionEditNode(prop);
                    child.setData((Object)pNode);
                } else {
                    child.setNodeType("ruleTreeNode simplePropositionNode");
                    SimplePropositionNode pNode = new SimplePropositionNode(prop);
                    child.setData((Object)pNode);
                }
                sprout.getChildren().add(child);
                this.propositionSummaryBuffer.append(prop.getParameterDisplayString());
            } else if (PropositionType.COMPOUND.getCode().equalsIgnoreCase(prop.getPropositionTypeCode())) {
                RuleTreeNode pNode;
                this.propositionSummaryBuffer.append(" ( ");
                Node aNode = new Node();
                aNode.setNodeLabel((Object)nodeLabel);
                if (prop.getEditMode()) {
                    aNode.setNodeLabel((Object)"");
                    aNode.setNodeType("ruleTreeNode compoundNode editNode");
                    pNode = new CompoundPropositionEditNode(prop);
                    aNode.setData((Object)pNode);
                } else {
                    aNode.setNodeType("ruleTreeNode compoundNode");
                    pNode = new RuleTreeNode(prop);
                    aNode.setData((Object)pNode);
                }
                sprout.getChildren().add(aNode);
                boolean first = true;
                List<PropositionBo> allMyChildren = prop.getCompoundComponents();
                int compoundSequenceNumber = 0;
                for (PropositionBo child : allMyChildren) {
                    ++compoundSequenceNumber;
                    child.setCompoundSequenceNumber(compoundSequenceNumber);
                    if (!first) {
                        this.addOpCodeNode(aNode, prop);
                    }
                    first = false;
                    this.buildPropTree(aNode, child, editMode);
                }
                this.propositionSummaryBuffer.append(" ) ");
            }
        }
    }

    private void addOpCodeNode(Node currentNode, PropositionBo prop) {
        String opCodeLabel = "";
        if (LogicalOperator.AND.getCode().equalsIgnoreCase(prop.getCompoundOpCode())) {
            opCodeLabel = "AND";
        } else if (LogicalOperator.OR.getCode().equalsIgnoreCase(prop.getCompoundOpCode())) {
            opCodeLabel = "OR";
        }
        this.propositionSummaryBuffer.append(" " + opCodeLabel + " ");
        Node aNode = new Node();
        aNode.setNodeLabel((Object)"");
        aNode.setNodeType("ruleTreeNode compoundOpCodeNode");
        aNode.setData((Object)new CompoundOpCodeNode(prop));
        currentNode.getChildren().add(aNode);
    }

    public static RuleDefinition to(RuleBo bo) {
        if (bo == null) {
            return null;
        }
        return RuleDefinition.Builder.create((RuleDefinitionContract)bo).build();
    }

    public static RuleBo from(RuleDefinition im) {
        if (im == null) {
            return null;
        }
        RuleBo bo = new RuleBo();
        bo._persistence_set_id(im.getId());
        bo._persistence_set_namespace(im.getNamespace());
        bo._persistence_set_name(im.getName());
        bo._persistence_set_description(im.getDescription());
        bo._persistence_set_typeId(im.getTypeId());
        bo._persistence_set_active(im.isActive());
        if (im.getProposition() != null) {
            PropositionBo propositionBo = PropositionBo.from(im.getProposition());
            bo._persistence_set_proposition(propositionBo);
            propositionBo.setRuleId(im.getId());
        }
        bo.setVersionNumber(im.getVersionNumber());
        bo._persistence_set_actions(new ArrayList());
        for (ActionDefinition action : im.getActions()) {
            ActionBo actionBo = ActionBo.from(action);
            bo._persistence_get_actions().add(actionBo);
            actionBo.setRule(bo);
        }
        ArrayList<RuleAttributeBo> attrs = new ArrayList<RuleAttributeBo>();
        for (Map.Entry entry : im.getAttributes().entrySet()) {
            KrmsAttributeDefinitionBo attrDefBo = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService().getKrmsAttributeBo((String)entry.getKey(), im.getNamespace());
            RuleAttributeBo attributeBo = new RuleAttributeBo();
            attributeBo.setRule(RuleBo.from(im));
            attributeBo.setAttributeDefinition(attrDefBo);
            attributeBo.setValue((String)entry.getValue());
            attributeBo.setAttributeDefinition(attrDefBo);
            attrs.add(attributeBo);
        }
        bo.setAttributeBos(attrs);
        return bo;
    }

    public static RuleBo copyRule(RuleBo existing) {
        RuleBo newRule = new RuleBo();
        newRule.setId(ruleIdIncrementer.getNewId());
        newRule.setNamespace(existing.getNamespace());
        newRule.setDescription(existing.getDescription());
        newRule.setTypeId(existing.getTypeId());
        newRule.setActive(true);
        PropositionBo newProp = PropositionBo.copyProposition(existing.getProposition());
        newProp.setRuleId(newRule.getId());
        newRule.setProposition(newProp);
        newRule.setAttributeBos(RuleBo.copyRuleAttributes(existing, newRule));
        newRule.setActions(RuleBo.copyRuleActions(existing, newRule));
        return newRule;
    }

    public RuleBo copyRule(String newRuleName) {
        RuleBo copiedRule = RuleBo.copyRule(this);
        copiedRule.setName(newRuleName);
        return copiedRule;
    }

    public static List<RuleAttributeBo> copyRuleAttributes(RuleBo existing, RuleBo newRule) {
        ArrayList<RuleAttributeBo> newAttributes = new ArrayList<RuleAttributeBo>();
        for (RuleAttributeBo attr : existing.getAttributeBos()) {
            RuleAttributeBo newAttr = new RuleAttributeBo();
            newAttr.setId(ruleAttributeIdIncrementer.getNewId());
            newAttr.setRule(newRule);
            newAttr.setAttributeDefinition(attr.getAttributeDefinition());
            newAttr.setValue(attr.getValue());
            newAttributes.add(newAttr);
        }
        return newAttributes;
    }

    public static List<ActionAttributeBo> copyActionAttributes(ActionBo existing, ActionBo newAction) {
        ArrayList<ActionAttributeBo> newAttributes = new ArrayList<ActionAttributeBo>();
        for (ActionAttributeBo attr : existing.getAttributeBos()) {
            ActionAttributeBo newAttr = new ActionAttributeBo();
            newAttr.setId(actionAttributeIdIncrementer.getNewId());
            newAttr.setAction(newAction);
            newAttr.setAttributeDefinition(attr.getAttributeDefinition());
            newAttr.setValue(attr.getValue());
            newAttributes.add(newAttr);
        }
        return newAttributes;
    }

    public static List<ActionBo> copyRuleActions(RuleBo existing, RuleBo newRule) {
        ArrayList<ActionBo> newActionList = new ArrayList<ActionBo>();
        for (ActionBo action : existing.getActions()) {
            ActionBo newAction = new ActionBo();
            newAction.setId(actionIdIncrementer.getNewId());
            newAction.setRule(newRule);
            newAction.setDescription(action.getDescription());
            newAction.setName(action.getName());
            newAction.setNamespace(action.getNamespace());
            newAction.setTypeId(action.getTypeId());
            newAction.setSequenceNumber(action.getSequenceNumber());
            newAction.setAttributeBos(RuleBo.copyActionAttributes(action, newAction));
            newActionList.add(newAction);
        }
        return newActionList;
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getNamespace() {
        return this._persistence_get_namespace();
    }

    public void setNamespace(String namespace) {
        this._persistence_set_namespace(namespace);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getTypeId() {
        return this._persistence_get_typeId();
    }

    public String getPropId() {
        if (this._persistence_get_proposition() != null) {
            return this._persistence_get_proposition().getId();
        }
        return null;
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public Long getVersionNumber() {
        return this._persistence_get_versionNumber();
    }

    public void setVersionNumber(Long versionNumber) {
        this._persistence_set_versionNumber(versionNumber);
    }

    public List<ActionBo> getActions() {
        return this._persistence_get_actions();
    }

    public void setActions(List<ActionBo> actions) {
        this._persistence_set_actions(actions);
    }

    public List<RuleAttributeBo> getAttributeBos() {
        return this._persistence_get_attributeBos();
    }

    public void setAttributeBos(List<RuleAttributeBo> attributeBos) {
        this._persistence_set_attributeBos(attributeBos);
    }

    public void setPropositionSummary(String propositionSummary) {
        this.propositionSummary = propositionSummary;
    }

    public String getSelectedPropositionId() {
        return this.selectedPropositionId;
    }

    public void setSelectedPropositionId(String selectedPropositionId) {
        this.selectedPropositionId = selectedPropositionId;
    }

    public Object _persistence_post_clone() {
        if (this._persistence_proposition_vh != null) {
            this._persistence_proposition_vh = (WeavedAttributeValueHolderInterface)this._persistence_proposition_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new RuleBo();
    }

    public Object _persistence_get(String string) {
        if (string == "attributeBos") {
            return this.attributeBos;
        }
        if (string == "proposition") {
            return this.proposition;
        }
        if (string == "namespace") {
            return this.namespace;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "typeId") {
            return this.typeId;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "actions") {
            return this.actions;
        }
        if (string == "versionNumber") {
            return this.versionNumber;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "attributeBos") {
            this.attributeBos = (List)object;
            return;
        }
        if (string == "proposition") {
            this.proposition = (PropositionBo)object;
            return;
        }
        if (string == "namespace") {
            this.namespace = (String)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "typeId") {
            this.typeId = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "actions") {
            this.actions = (List)object;
            return;
        }
        if (string == "versionNumber") {
            this.versionNumber = (Long)object;
            return;
        }
    }

    public List _persistence_get_attributeBos() {
        this._persistence_checkFetched("attributeBos");
        return this.attributeBos;
    }

    public void _persistence_set_attributeBos(List list) {
        this._persistence_checkFetchedForSet("attributeBos");
        this._persistence_propertyChange("attributeBos", this.attributeBos, list);
        this.attributeBos = list;
    }

    protected void _persistence_initialize_proposition_vh() {
        if (this._persistence_proposition_vh == null) {
            this._persistence_proposition_vh = new ValueHolder((Object)this.proposition);
            this._persistence_proposition_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_proposition_vh() {
        PropositionBo propositionBo;
        this._persistence_initialize_proposition_vh();
        if ((this._persistence_proposition_vh.isCoordinatedWithProperty() || this._persistence_proposition_vh.isNewlyWeavedValueHolder()) && (propositionBo = this._persistence_get_proposition()) != this._persistence_proposition_vh.getValue()) {
            this._persistence_set_proposition(propositionBo);
        }
        return this._persistence_proposition_vh;
    }

    public void _persistence_set_proposition_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_proposition_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            PropositionBo propositionBo = this._persistence_get_proposition();
            if (propositionBo != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_proposition((PropositionBo)object);
            }
        } else {
            this.proposition = null;
        }
    }

    public PropositionBo _persistence_get_proposition() {
        this._persistence_checkFetched("proposition");
        this._persistence_initialize_proposition_vh();
        this.proposition = (PropositionBo)this._persistence_proposition_vh.getValue();
        return this.proposition;
    }

    public void _persistence_set_proposition(PropositionBo propositionBo) {
        this._persistence_checkFetchedForSet("proposition");
        this._persistence_initialize_proposition_vh();
        this.proposition = (PropositionBo)this._persistence_proposition_vh.getValue();
        this._persistence_propertyChange("proposition", this.proposition, propositionBo);
        this.proposition = propositionBo;
        this._persistence_proposition_vh.setValue((Object)propositionBo);
    }

    public String _persistence_get_namespace() {
        this._persistence_checkFetched("namespace");
        return this.namespace;
    }

    public void _persistence_set_namespace(String string) {
        this._persistence_checkFetchedForSet("namespace");
        this._persistence_propertyChange("namespace", this.namespace, string);
        this.namespace = string;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_typeId() {
        this._persistence_checkFetched("typeId");
        return this.typeId;
    }

    public void _persistence_set_typeId(String string) {
        this._persistence_checkFetchedForSet("typeId");
        this._persistence_propertyChange("typeId", this.typeId, string);
        this.typeId = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public List _persistence_get_actions() {
        this._persistence_checkFetched("actions");
        return this.actions;
    }

    public void _persistence_set_actions(List list) {
        this._persistence_checkFetchedForSet("actions");
        this._persistence_propertyChange("actions", this.actions, list);
        this.actions = list;
    }

    public Long _persistence_get_versionNumber() {
        this._persistence_checkFetched("versionNumber");
        return this.versionNumber;
    }

    public void _persistence_set_versionNumber(Long l) {
        this._persistence_checkFetchedForSet("versionNumber");
        this._persistence_propertyChange("versionNumber", this.versionNumber, l);
        this.versionNumber = l;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

