/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.s3.api;

import java.util.HashMap;
import java.util.Map;

public class S3FileMetadata {
    public static final String FILE_NAME = "File-Name";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_MD5 = "Content-MD5";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String SERVER_SIDE_ENCRYPTION = "x-amz-server-side-encryption";
    public static final String SERVER_SIDE_ENCRYPTION_ALGORITHM = "AES256";
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public Long getContentLength() {
        return (Long)this.metadata.get(CONTENT_LENGTH);
    }

    public void setContentLength(Long contentLength) {
        this.metadata.put(CONTENT_LENGTH, contentLength);
    }

    public String getContentType() {
        return (String)this.metadata.get(CONTENT_TYPE);
    }

    public void setContentType(String contentType) {
        this.metadata.put(CONTENT_TYPE, contentType);
    }

    public String getFileName() {
        return (String)this.metadata.get(FILE_NAME);
    }

    public void setFileName(String fileName) {
        this.metadata.put(FILE_NAME, fileName);
    }

    public Map<String, Object> getMetadata() {
        return new HashMap<String, Object>(this.metadata);
    }

    public void setMetadata(Map<String, String> metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata cannot be null");
        }
        this.metadata = new HashMap<String, String>(metadata);
    }

    public void putMetadataValue(String key, Object value) {
        this.metadata.put(key, value);
    }

    public void deleteMetadataValue(String key) {
        this.metadata.remove(key);
    }

    public void getMetadataValue(String key) {
        this.metadata.get(key);
    }

    public String toString() {
        return "S3FileMetadata{metadata=" + this.metadata + "}";
    }
}

