/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.nonpersonnel;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.budget.framework.rate.ValidCeRateType;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ValidCeRateTypeMaintenanceDocumentRule
extends KcMaintenanceDocumentRuleBase {
    public boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkRateTypeExist(document);
    }

    public boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkRateTypeExist(document);
    }

    private boolean checkRateTypeExist(MaintenanceDocument maintenanceDocument) {
        HashMap<String, String> pkMap;
        ValidCeRateType validCeRateType;
        boolean valid = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new maintainable is: " + maintenanceDocument.getNewMaintainableObject().getClass());
        }
        if (StringUtils.isNotBlank((CharSequence)(validCeRateType = (ValidCeRateType)maintenanceDocument.getNewMaintainableObject().getDataObject()).getRateClassCode()) && StringUtils.isNotBlank((CharSequence)validCeRateType.getRateTypeCode())) {
            pkMap = new HashMap();
            pkMap.put("rateClassCode", validCeRateType.getRateClassCode());
            pkMap.put("rateTypeCode", validCeRateType.getRateTypeCode());
            RateType rateType = (RateType)KcServiceLocator.getService(BusinessObjectService.class).findByPrimaryKey(RateType.class, pkMap);
            if (rateType == null) {
                GlobalVariables.getMessageMap().putError("document.newMaintainableObject.rateTypeCode", "error.rateType.not.exist", new String[]{validCeRateType.getRateClassCode(), validCeRateType.getRateTypeCode()});
                valid = false;
            }
        }
        pkMap = new HashMap<String, String>();
        pkMap.put("costElement", validCeRateType.getCostElement());
        return valid &= this.checkExistenceFromTable(CostElement.class, pkMap, "costElement", "Cost Element");
    }
}

