/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.sponsor;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.sponsor.SponsorSearchResult;
import org.kuali.coeus.common.framework.sponsor.SponsorSearchService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="sponsorSearchService")
public class SponsorSearchServiceImpl
implements SponsorSearchService {
    @Autowired
    @Qualifier(value="kcEntityManager")
    private EntityManager entityManager;

    @Override
    public List<SponsorSearchResult> findSponsors(String searchString) {
        if (StringUtils.isBlank((CharSequence)searchString)) {
            throw new IllegalArgumentException("searchString is blank");
        }
        String likeCriteria = "%" + searchString.toUpperCase() + "%";
        TypedQuery query = this.entityManager.createQuery("SELECT NEW org.kuali.coeus.common.framework.sponsor.SponsorSearchResult(t.sponsorCode, t.sponsorName) FROM Sponsor t WHERE t.active=true AND (UPPER(t.sponsorCode) like :likeCriteria OR UPPER(t.acronym) like :likeCriteria or UPPER(t.sponsorName) like :likeCriteria)", SponsorSearchResult.class).setParameter("likeCriteria", (Object)likeCriteria);
        return ListUtils.emptyIfNull((List)query.setMaxResults(25).getResultList());
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

