/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller.interceptor;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletContextAware;

public class FilterRegistrator
implements InitializingBean,
ServletContextAware {
    private ServletContext servletContext;
    private Filter filter;
    private String filterName;
    private boolean asyncSupported;
    private Map<String, String> initParameters;
    private Mapping servletMapping;
    private Mapping urlMapping;

    public void afterPropertiesSet() throws Exception {
        FilterRegistration.Dynamic fr = this.servletContext.addFilter(this.filterName, this.filter);
        fr.setAsyncSupported(this.asyncSupported);
        if (this.initParameters != null) {
            fr.setInitParameters(this.initParameters);
        }
        if (this.servletMapping != null) {
            fr.addMappingForServletNames(this.servletMapping.dispatcherTypes != null ? EnumSet.copyOf(this.servletMapping.dispatcherTypes) : null, this.servletMapping.matchAfter, this.servletMapping.maps.toArray(new String[0]));
        }
        if (this.urlMapping != null && this.urlMapping.enabled) {
            fr.addMappingForUrlPatterns(this.urlMapping.dispatcherTypes != null ? EnumSet.copyOf(this.urlMapping.dispatcherTypes) : null, this.urlMapping.matchAfter, this.urlMapping.maps.toArray(new String[0]));
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this.asyncSupported = asyncSupported;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public void setInitParameters(Map<String, String> initParameters) {
        this.initParameters = initParameters;
    }

    public Mapping getServletMapping() {
        return this.servletMapping;
    }

    public void setServletMapping(Mapping servletMapping) {
        this.servletMapping = servletMapping;
    }

    public Mapping getUrlMapping() {
        return this.urlMapping;
    }

    public void setUrlMapping(Mapping urlMapping) {
        this.urlMapping = urlMapping;
    }

    public static class Mapping {
        private Set<DispatcherType> dispatcherTypes;
        private boolean matchAfter;
        List<String> maps;
        private boolean enabled = true;

        public Set<DispatcherType> getDispatcherTypes() {
            return this.dispatcherTypes;
        }

        public void setDispatcherTypes(Set<DispatcherType> dispatcherTypes) {
            this.dispatcherTypes = dispatcherTypes;
        }

        public boolean isMatchAfter() {
            return this.matchAfter;
        }

        public void setMatchAfter(boolean matchAfter) {
            this.matchAfter = matchAfter;
        }

        public List<String> getMaps() {
            return this.maps;
        }

        public void setMaps(List<String> maps) {
            this.maps = maps;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

