--
-- Kuali Coeus, a comprehensive research administration system for higher education.
--
-- Copyright 2005-2016 Kuali, Inc.
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
--
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--
INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire(QUESTIONNAIRE_REF_ID, QUESTIONNAIRE_ID, SEQUENCE_NUMBER, NAME, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, IS_FINAL, DOCUMENT_NUMBER, VER_NBR, OBJ_ID, file_name, template)
VALUES((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), -2, 1, 'PHS Fellowship Supplemental 3.1', 'The responses are used to populate the PHS 398 Fellowship Supplement v3-1 for submission via Grants.gov.', NOW(), 'admin', 'Y', null, 1, UUID(), null, null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 1 AND SEQUENCE_NUMBER = 3),1,0,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID)
VALUES ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 4 AND SEQUENCE_NUMBER = 2),4,0,'N',NULL,NULL,NOW(),'kr',3,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 5 AND SEQUENCE_NUMBER = 2),5,0,'N',NULL,NULL,NOW(),'kr',5,1,UUID(),NULL);


INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 6 AND SEQUENCE_NUMBER = 2),6,5,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);
INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 7 AND SEQUENCE_NUMBER = 2),7,6,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 24 AND SEQUENCE_NUMBER = 2),26,0,'N',NULL,NULL,NOW(),'kr',8,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 32 AND SEQUENCE_NUMBER = 2),27,26,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 28 AND SEQUENCE_NUMBER = 2),32,0,'N',NULL,NULL,NOW(),'kr',9,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 29 AND SEQUENCE_NUMBER = 2),33,32,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 33 AND SEQUENCE_NUMBER = 2),49,27,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 36 AND SEQUENCE_NUMBER = 2),72,0,'N',NULL,NULL,NOW(),'kr',10,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 37 AND SEQUENCE_NUMBER = 2),73,72,'Y','4','Y',NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 38 AND SEQUENCE_NUMBER = 2),74,73,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 51 AND SEQUENCE_NUMBER = 2),75,74,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 40 AND SEQUENCE_NUMBER = 2),76,75,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 41 AND SEQUENCE_NUMBER = 2),77,76,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 42 AND SEQUENCE_NUMBER = 2),78,0,'N',NULL,NULL,NOW(),'kr',7,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 35 AND SEQUENCE_NUMBER = 2),79,78,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 99 AND SEQUENCE_NUMBER = 1 AND LOOKUP_RETURN = 'GraduateLevelDegree1-2'),80,78,'Y','4','Y',NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 16 AND SEQUENCE_NUMBER = 2),81,80,'Y','2','MOTH',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 17 AND SEQUENCE_NUMBER = 2),82,80,'Y','2','DOTH',NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 18 AND SEQUENCE_NUMBER = 2),83,80,'Y','2','DDOT',NOW(),'kr',3,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 19 AND SEQUENCE_NUMBER = 2),84,80,'Y','2','VDOT',NOW(),'kr',4,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 100 AND SEQUENCE_NUMBER = 1 ORDER BY question_ref_id LIMIT 1),85,80,'Y','2','OTH',NOW(),'kr',5,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 21 AND SEQUENCE_NUMBER = 2),86,80,'Y','2','MDOT',NOW(),'kr',6,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 43 AND SEQUENCE_NUMBER = 2),87,49,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 44 AND SEQUENCE_NUMBER = 2),88,87,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 47 AND SEQUENCE_NUMBER = 2),120,72,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 48 AND SEQUENCE_NUMBER = 2),121,120,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 50 AND SEQUENCE_NUMBER = 2),122,121,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 49 AND SEQUENCE_NUMBER = 2),123,87,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 45 AND SEQUENCE_NUMBER = 2),124,123,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 46 AND SEQUENCE_NUMBER = 2),125,123,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 27 AND SEQUENCE_NUMBER = 2),126,125,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 31 AND SEQUENCE_NUMBER = 2),127,125,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 32 AND SEQUENCE_NUMBER = 2),128,127,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 33 AND SEQUENCE_NUMBER = 2),129,128,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 43 AND SEQUENCE_NUMBER = 2),130,129,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 44 AND SEQUENCE_NUMBER = 2),131,130,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 49 AND SEQUENCE_NUMBER = 2),132,130,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 45 AND SEQUENCE_NUMBER = 2),133,132,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 46 AND SEQUENCE_NUMBER = 2),134,132,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 27 AND SEQUENCE_NUMBER = 2),135,134,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 31 AND SEQUENCE_NUMBER = 2),136,134,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 32 AND SEQUENCE_NUMBER = 2),137,136,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 33 AND SEQUENCE_NUMBER = 2),138,137,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 43 AND SEQUENCE_NUMBER = 2),139,138,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 44 AND SEQUENCE_NUMBER = 2),140,139,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 49 AND SEQUENCE_NUMBER = 2),141,139,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 45 AND SEQUENCE_NUMBER = 2),142,141,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 46 AND SEQUENCE_NUMBER = 2),143,141,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 27 AND SEQUENCE_NUMBER = 2),144,143,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 31 AND SEQUENCE_NUMBER = 2),145,143,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 32 AND SEQUENCE_NUMBER = 2),146,145,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 33 AND SEQUENCE_NUMBER = 2),147,146,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 43 AND SEQUENCE_NUMBER = 2),148,147,'N',NULL,NULL,NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 44 AND SEQUENCE_NUMBER = 2),149,148,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 49 AND SEQUENCE_NUMBER = 2),150,148,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 45 AND SEQUENCE_NUMBER = 2),151,150,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 46 AND SEQUENCE_NUMBER = 2),152,150,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 27 AND SEQUENCE_NUMBER = 2),153,152,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 145 AND SEQUENCE_NUMBER = 1),154,0,'N',NULL,NULL,NOW(),'kr',4,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 146 AND SEQUENCE_NUMBER = 1),155,154,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 147 AND SEQUENCE_NUMBER = 1),156,155,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 148 AND SEQUENCE_NUMBER = 1),157,156,'Y','4','N',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 2 AND SEQUENCE_NUMBER = 2),158,0,'N',NULL,NULL,NOW(),'kr',2,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = 3 AND SEQUENCE_NUMBER = 2),159,158,'Y','4','Y',NOW(),'kr',1,1,UUID(),NULL);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

INSERT INTO question (QUESTION_REF_ID,QUESTION_ID,SEQUENCE_NUMBER,SEQUENCE_STATUS,QUESTION,STATUS,GROUP_TYPE_CODE,QUESTION_TYPE_ID,LOOKUP_CLASS,LOOKUP_RETURN,DISPLAYED_ANSWERS,MAX_ANSWERS,ANSWER_MAX_LENGTH,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,DOCUMENT_NUMBER) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),'200',1,'C','Please select a Field of Training from the list provided that best applies to the current proposal. (ONLY Items preceded by 3-digit codes are valid)','A',
2,6,'org.kuali.coeus.common.framework.custom.arg.ArgValueLookup','FOTv3',NULL,1,NULL,NOW(),'admin',1,UUID(),null);

INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

-- FOT question
INSERT INTO questionnaire_questions (QUESTIONNAIRE_QUESTIONS_ID,QUESTIONNAIRE_REF_ID_FK,QUESTION_REF_ID_FK,QUESTION_NUMBER,PARENT_QUESTION_NUMBER,CONDITION_FLAG,CONDITION_TYPE,CONDITION_VALUE,UPDATE_TIMESTAMP,UPDATE_USER,QUESTION_SEQ_NUMBER,VER_NBR,OBJ_ID,RULE_ID) VALUES
((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID),(SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1),
(SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID = '200' AND SEQUENCE_NUMBER = 1),160,0,'N',NULL,NULL,NOW(),'kr',6,1,UUID(),NULL);


INSERT INTO SEQ_QUESTIONNAIRE_REF_ID VALUES(NULL);

Insert into QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID,MODULE_ITEM_CODE,MODULE_SUB_ITEM_CODE,QUESTIONNAIRE_REF_ID_FK,QUESTIONNAIRE_SEQUENCE_NUMBER,RULE_ID,QUESTIONNAIRE_LABEL,UPDATE_TIMESTAMP,UPDATE_USER,VER_NBR,OBJ_ID,IS_MANDATORY)
values ((SELECT (MAX(ID)) FROM SEQ_QUESTIONNAIRE_REF_ID), 3, 2, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -2 AND SEQUENCE_NUMBER = 1), 1,null,'PHS Fellowship Supplemental 3.1',NOW(),'admin',1,UUID(),'N');

insert into SEQ_QUESTIONNAIRE_REF_ID values (NULL);

insert into s2s_form_to_questionnaire (S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES ((select max(id) from SEQ_QUESTIONNAIRE_REF_ID), 'http://apply.grants.gov/forms/PHS_Fellowship_Supplemental_3_1-V3.1', 'PHS_Fellowship_Supplemental_3_1', -2, NOW(), 'admin', UUID(), '1');
