/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.util;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpMethod;

public final class CsrfValidator {
    private static final Logger LOG = LogManager.getLogger(CsrfValidator.class);
    public static final String CSRF_PARAMETER = "csrfToken";
    public static final String CSRF_SESSION_TOKEN = "csrfSessionToken";
    public static final String CSRF_PROTECTION_ENABLED_PARAM = "CSRF_PROTECTION_ENABLED";

    private CsrfValidator() {
        throw new UnsupportedOperationException("do not call");
    }

    public static boolean validateCsrf(HttpServletRequest request, HttpServletResponse response) {
        if (HttpMethod.GET.matches(request.getMethod()) || HttpMethod.HEAD.matches(request.getMethod()) || HttpMethod.OPTIONS.matches(request.getMethod())) {
            CsrfValidator.placeSessionToken(request);
        } else {
            String givenCsrf = CsrfValidator.getRequestToken(request);
            String actualCsrf = CsrfValidator.getSessionToken(request);
            if (actualCsrf == null) {
                LOG.error("CSRF check failed because no CSRF token has been established on the session");
                response.setStatus(403);
                return false;
            }
            if (!StringUtils.equals((String)givenCsrf, (String)actualCsrf)) {
                LOG.error("CSRF check failed, actual value was: " + actualCsrf + ", given value was: " + givenCsrf + ", requested URL was: " + request.getRequestURL());
                response.setStatus(403);
                return false;
            }
        }
        return true;
    }

    public static String getSessionToken(HttpServletRequest request) {
        return (String)request.getSession().getAttribute(CSRF_SESSION_TOKEN);
    }

    public static String getRequestToken(HttpServletRequest request) {
        return request.getParameter(CSRF_PARAMETER);
    }

    private static void placeSessionToken(HttpServletRequest request) {
        if (CsrfValidator.getSessionToken(request) == null) {
            request.getSession().setAttribute(CSRF_SESSION_TOKEN, (Object)UUID.randomUUID().toString());
        }
    }
}

