/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.locking.LockManager;
import org.apache.ojb.odmg.locking.LockStrategy;
import org.apache.ojb.odmg.locking.LockStrategyFactory;

public class LockManagerDefaultImpl
implements LockManager {
    private Logger log = LoggerFactory.getLogger(LockManagerDefaultImpl.class);

    @Override
    public synchronized boolean readLock(TransactionImpl transactionImpl, Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.readLock(tx-" + transactionImpl.getGUID() + ", " + new Identity(object, transactionImpl.getBroker()).toString() + ")");
        }
        LockStrategy lockStrategy = LockStrategyFactory.getStrategyFor(object);
        return lockStrategy.readLock(transactionImpl, object);
    }

    @Override
    public boolean readLock(TransactionImpl transactionImpl, Identity identity, Object object) {
        return this.readLock(transactionImpl, object);
    }

    @Override
    public synchronized boolean writeLock(TransactionImpl transactionImpl, Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.writeLock(tx-" + transactionImpl.getGUID() + ", " + new Identity(object, transactionImpl.getBroker()).toString() + ")");
        }
        LockStrategy lockStrategy = LockStrategyFactory.getStrategyFor(object);
        return lockStrategy.writeLock(transactionImpl, object);
    }

    @Override
    public boolean writeLock(TransactionImpl transactionImpl, Identity identity, Object object) {
        return this.writeLock(transactionImpl, object);
    }

    @Override
    public synchronized boolean upgradeLock(TransactionImpl transactionImpl, Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.upgradeLock(tx-" + transactionImpl.getGUID() + ", " + new Identity(object, transactionImpl.getBroker()).toString() + ")");
        }
        LockStrategy lockStrategy = LockStrategyFactory.getStrategyFor(object);
        return lockStrategy.upgradeLock(transactionImpl, object);
    }

    @Override
    public boolean upgradeLock(TransactionImpl transactionImpl, Identity identity, Object object) {
        return this.upgradeLock(transactionImpl, object);
    }

    @Override
    public synchronized boolean releaseLock(TransactionImpl transactionImpl, Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.releaseLock(tx-" + transactionImpl.getGUID() + ", " + new Identity(object, transactionImpl.getBroker()).toString() + ")");
        }
        LockStrategy lockStrategy = LockStrategyFactory.getStrategyFor(object);
        return lockStrategy.releaseLock(transactionImpl, object);
    }

    @Override
    public boolean releaseLock(TransactionImpl transactionImpl, Identity identity, Object object) {
        return this.releaseLock(transactionImpl, object);
    }

    @Override
    public synchronized boolean checkRead(TransactionImpl transactionImpl, Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.checkRead(tx-" + transactionImpl.getGUID() + ", " + new Identity(object, transactionImpl.getBroker()).toString() + ")");
        }
        LockStrategy lockStrategy = LockStrategyFactory.getStrategyFor(object);
        return lockStrategy.checkRead(transactionImpl, object);
    }

    @Override
    public boolean checkRead(TransactionImpl transactionImpl, Identity identity, Object object) {
        return this.checkRead(transactionImpl, object);
    }

    @Override
    public synchronized boolean checkWrite(TransactionImpl transactionImpl, Object object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("LM.checkWrite(tx-" + transactionImpl.getGUID() + ", " + new Identity(object, transactionImpl.getBroker()).toString() + ")");
        }
        LockStrategy lockStrategy = LockStrategyFactory.getStrategyFor(object);
        return lockStrategy.checkWrite(transactionImpl, object);
    }

    @Override
    public boolean checkWrite(TransactionImpl transactionImpl, Identity identity, Object object) {
        return this.checkWrite(transactionImpl, object);
    }
}

