/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.JdbcAccess;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerNativeImpl
extends AbstractSequenceManager {
    private Log log = LogFactory.getLog(SequenceManagerNativeImpl.class);
    private static volatile long tempKey = -1L;

    public SequenceManagerNativeImpl(PersistenceBroker persistenceBroker) {
        super(persistenceBroker);
    }

    @Override
    public void afterStore(JdbcAccess jdbcAccess, ClassDescriptor classDescriptor, Object object) throws SequenceManagerException {
        FieldDescriptor fieldDescriptor = this.extractIdentityColumnField(classDescriptor);
        if (fieldDescriptor != null) {
            this.ifNotReadOnlyFail(fieldDescriptor);
            long l = this.getLastInsert(classDescriptor, fieldDescriptor);
            this.setFieldValue(object, fieldDescriptor, new Long(l));
        }
    }

    private FieldDescriptor extractIdentityColumnField(ClassDescriptor classDescriptor) {
        FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            if (!fieldDescriptorArray[i].isAutoIncrement() || !fieldDescriptorArray[i].isAccessReadOnly()) continue;
            return fieldDescriptorArray[i];
        }
        return null;
    }

    private void ifNotReadOnlyFail(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        if (!fieldDescriptor.isAccessReadOnly()) {
            throw new SequenceManagerException("Can't find Identity column: Identity columns/fields need to be declared as 'autoincrement' with 'readonly' access in field-descriptor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getLastInsert(ClassDescriptor classDescriptor, FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        long l = 0L;
        Statement statement = null;
        if (fieldDescriptor == null) throw new SequenceManagerException("No autoincrement field declared, please check repository for " + classDescriptor);
        try {
            statement = this.getBrokerForClass().serviceConnectionManager().getConnection().createStatement();
            ResultSet resultSet = statement.executeQuery(this.lastInsertSelect(classDescriptor.getFullTableName()));
            if (!resultSet.next()) {
                throw new SequenceManagerException("Could not find native identifier");
            }
            l = resultSet.getLong(1);
            resultSet.close();
            if (!this.log.isDebugEnabled()) return l;
            this.log.debug((Object)("After store - newid=" + l));
            return l;
        }
        catch (Exception exception) {
            throw new SequenceManagerException(exception);
        }
        finally {
            block11: {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!this.log.isDebugEnabled()) break block11;
                    this.log.debug((Object)"Threw SQLException while in getLastInsert and closing stmt", (Throwable)sQLException);
                }
            }
        }
    }

    protected String lastInsertSelect(String string) {
        return this.getBrokerForClass().serviceConnectionManager().getSupportedPlatform().getLastInsertIdentityQuery(string);
    }

    private void setFieldValue(Object object, FieldDescriptor fieldDescriptor, Long l) throws SequenceManagerException {
        Object object2 = fieldDescriptor.getJdbcType().sequenceKeyConversion(l);
        object2 = fieldDescriptor.getFieldConversion().sqlToJava(object2);
        PersistentField persistentField = fieldDescriptor.getPersistentField();
        persistentField.set(object, object2);
    }

    @Override
    protected long getUniqueLong(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        return --tempKey;
    }
}

